/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.apigw.exception;

public final class ApiGwException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    public static final String ERROR_CODE_BAD_SYNTAX = "BadSyntax";
    public static final String ERROR_CODE_INTERNAL_ERROR = "InternalError";
    public static final String ERROR_CODE_NOT_FOUND = "NotFound";
    public static final String ERROR_CODE_NOT_IMPLEMENTED = "NotImplemented";
    private final int _httpStatusCode;
    private final String _errorCode;

    public ApiGwException(int n, String string, String string2) {
        this(n, string, string2, null);
    }

    public ApiGwException(int n, String string, Throwable throwable) {
        this(n, string, null, throwable);
    }

    public ApiGwException(int n, String string, String string2, Throwable throwable) {
        super(ApiGwException.getMessage(string2, throwable), throwable);
        assert (n >= 100);
        assert (n <= 599);
        assert (string != null);
        assert (!string.isEmpty());
        this._httpStatusCode = n;
        this._errorCode = string;
    }

    public int getHttpStatusCode() {
        return this._httpStatusCode;
    }

    public String getErrorCode() {
        return this._errorCode;
    }

    private static String getMessage(String string, Throwable throwable) {
        if (string != null) {
            return string;
        }
        if (throwable != null && throwable.getMessage() != null) {
            return throwable.getMessage();
        }
        if (throwable != null) {
            return throwable.getClass().getCanonicalName();
        }
        return "Internal error. See logs for details.";
    }
}

