/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.apigw.handler.risetovise;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryCommand;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.aggregated.DefaultAggregatedModels;
import com.vmware.vcenter.apigw.exception.ApiGwException;
import com.vmware.vcenter.apigw.handler.ApiGwRequest;
import com.vmware.vcenter.apigw.handler.ApiGwRequestHandler;
import com.vmware.vcenter.apigw.handler.ApiGwResponse;
import com.vmware.vcenter.apigw.odata.ODataErrorSerializer;
import com.vmware.vcenter.apigw.odata.ODataQuery;
import com.vmware.vcenter.apigw.odata.ODataQueryParser;
import com.vmware.vcenter.apigw.servlet.ApiGwProperties;
import com.vmware.vcenter.apigw.servlet.ApiGwServlet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RiseToViseApiGwRequestHandler
implements ApiGwRequestHandler {
    private static final Logger _logger = LoggerFactory.getLogger(ApiGwServlet.class);
    private final QueryService _queryService;
    private final ObjectMapper _jsonObjectMapper;
    private final ODataErrorSerializer _errorSerializer;

    public RiseToViseApiGwRequestHandler(QueryService queryService, ObjectMapper objectMapper) {
        assert (queryService != null);
        assert (objectMapper != null);
        this._queryService = queryService;
        this._jsonObjectMapper = objectMapper;
        this._errorSerializer = new ODataErrorSerializer(objectMapper);
    }

    @Override
    public void handleRequest(ApiGwRequest apiGwRequest, ApiGwResponse apiGwResponse) throws IOException {
        Object object;
        assert (apiGwRequest != null);
        assert (apiGwResponse != null);
        RiseToViseApiGwRequestHandler.logRequest(apiGwRequest);
        try {
            ODataQuery oDataQuery = this.parseUrlQueryString(apiGwRequest);
            RiseToViseApiGwRequestHandler.restrictQuery(apiGwRequest, oDataQuery);
            object = this.executeQuery(apiGwRequest, oDataQuery);
        }
        catch (RuntimeException runtimeException) {
            RiseToViseApiGwRequestHandler.logError(apiGwRequest, runtimeException);
            this._errorSerializer.writeError(apiGwResponse, runtimeException);
            return;
        }
        this.logResponse(apiGwRequest, object);
        this.writeValueAsJson(apiGwResponse, object);
    }

    private Object executeQuery(ApiGwRequest apiGwRequest, ODataQuery oDataQuery) {
        ResultSet resultSet;
        QueryCommand queryCommand;
        assert (apiGwRequest != null);
        assert (oDataQuery != null);
        String string = apiGwRequest.getResourceId();
        if (string.isEmpty()) {
            throw new ApiGwException(501, "NotImplemented", "URL path without resource id is not yet supported");
        }
        try {
            queryCommand = this.toQueryCommand(apiGwRequest, oDataQuery);
        }
        catch (RuntimeException runtimeException) {
            throw new ApiGwException(400, "BadSyntax", runtimeException);
        }
        try {
            resultSet = queryCommand.fetch();
        }
        catch (RuntimeException runtimeException) {
            throw new ApiGwException(500, "InternalError", "Query execution failed. See logs for more details.", runtimeException);
        }
        if (resultSet.getItems().isEmpty()) {
            throw new ApiGwException(404, "NotFound", "No object found for id: " + string);
        }
        if (resultSet.getItems().size() != 1) {
            throw new ApiGwException(500, "InternalError", "Multiple objects found for id: " + string);
        }
        ResourceItem resourceItem = (ResourceItem)resultSet.getItems().iterator().next();
        Map<String, Object> map = RiseToViseApiGwRequestHandler.toPropValueByName(resourceItem, resultSet.getProperties());
        return map;
    }

    private QueryCommand toQueryCommand(ApiGwRequest apiGwRequest, ODataQuery oDataQuery) {
        assert (apiGwRequest != null);
        assert (oDataQuery != null);
        String string = apiGwRequest.getOpId();
        String string2 = apiGwRequest.getResourceCollection();
        Object object = RiseToViseApiGwRequestHandler.createResourceRef(apiGwRequest);
        PropertyPredicate propertyPredicate = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, object);
        Filter filter = new Filter(Collections.singletonList(propertyPredicate));
        QueryCommand.Builder builder = this._queryService.select(new ArrayList<String>(oDataQuery.select)).from(new String[]{string2}).where(filter);
        if (!string.isEmpty()) {
            builder.opId(string);
        }
        QueryCommand queryCommand = builder.build();
        return queryCommand;
    }

    private static Object createResourceRef(ApiGwRequest apiGwRequest) {
        assert (apiGwRequest != null);
        return new ManagedObjectReference(apiGwRequest.getResourceCollection(), apiGwRequest.getResourceId(), apiGwRequest.getNodeId());
    }

    private static Map<String, Object> toPropValueByName(ResourceItem resourceItem, Collection<String> collection) {
        assert (resourceItem != null);
        assert (collection != null);
        assert (resourceItem.getPropertyValues().size() == collection.size());
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(collection.size() + 1);
        linkedHashMap.put("@modelKey", resourceItem.getKey());
        for (String string : collection) {
            Object object = resourceItem.get(string);
            linkedHashMap.put(string, object);
        }
        return linkedHashMap;
    }

    private void writeValueAsJson(ApiGwResponse apiGwResponse, Object object) throws IOException {
        assert (apiGwResponse != null);
        assert (object != null);
        apiGwResponse.setContentType("application/json");
        apiGwResponse.setHeader("OData-Version", "4.0");
        OutputStream outputStream = apiGwResponse.getOutputStream();
        this._jsonObjectMapper.writeValue(outputStream, object);
        outputStream.flush();
    }

    private ODataQuery parseUrlQueryString(ApiGwRequest apiGwRequest) {
        assert (apiGwRequest != null);
        String string = apiGwRequest.getQueryString();
        try {
            ODataQuery oDataQuery = ODataQueryParser.parse(string);
            return oDataQuery;
        }
        catch (RuntimeException runtimeException) {
            throw new ApiGwException(400, "BadSyntax", runtimeException);
        }
    }

    private static void logRequest(ApiGwRequest apiGwRequest) {
        assert (apiGwRequest != null);
        _logger.info("Processing request opId='{}' node='{}' collection='{}' resource='{}'", new Object[]{apiGwRequest.getOpId(), apiGwRequest.getNodeId(), apiGwRequest.getResourceCollection(), apiGwRequest.getResourceId()});
    }

    private void logResponse(ApiGwRequest apiGwRequest, Object object) throws IOException {
        assert (apiGwRequest != null);
        assert (object != null);
        if (_logger.isTraceEnabled()) {
            StringWriter stringWriter = new StringWriter();
            ObjectWriter objectWriter = this._jsonObjectMapper.writer(SerializationFeature.INDENT_OUTPUT);
            objectWriter.writeValue((Writer)stringWriter, object);
            _logger.trace("Sending response for request opId='{}' node='{}' collection='{}' resource='{}': \n{}", new Object[]{apiGwRequest.getOpId(), apiGwRequest.getNodeId(), apiGwRequest.getResourceCollection(), apiGwRequest.getResourceId(), stringWriter});
        } else {
            _logger.info("Sending response for request opId='{}' node='{}' collection='{}' resource='{}'", new Object[]{apiGwRequest.getOpId(), apiGwRequest.getNodeId(), apiGwRequest.getResourceCollection(), apiGwRequest.getResourceId()});
        }
    }

    private static void logError(ApiGwRequest apiGwRequest, Exception exception) {
        assert (apiGwRequest != null);
        assert (exception != null);
        _logger.error("Error when processing request opId='{}' node='{}' collection='{}' resource='{}'", new Object[]{apiGwRequest.getOpId(), apiGwRequest.getNodeId(), apiGwRequest.getResourceCollection(), apiGwRequest.getResourceId(), exception});
    }

    private static void restrictQuery(ApiGwRequest apiGwRequest, ODataQuery oDataQuery) {
        assert (apiGwRequest != null);
        assert (oDataQuery != null);
        String string = apiGwRequest.getResourceCollection();
        String string2 = apiGwRequest.getResourceId();
        if (!string2.isEmpty() && DefaultAggregatedModels.getModelLookup().getAllAggregatedModels().contains(string)) {
            throw new ApiGwException(400, "BadSyntax", "Cannot ask for resource id on aggregated model: " + string);
        }
        for (String string3 : oDataQuery.select) {
            if (string3.endsWith("@formatted")) {
                throw new ApiGwException(400, "BadSyntax", "API-GW does not support @formatted");
            }
            if (string3.indexOf(46) < 0) continue;
            throw new ApiGwException(400, "BadSyntax", "API-GW does not support '.' as property path delimiter. Please use '/'. ");
        }
        ApiGwProperties.restrictQuery(apiGwRequest.getResourceCollection(), oDataQuery);
    }
}

