/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.apigw.odata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vcenter.apigw.exception.ApiGwException;
import com.vmware.vcenter.apigw.handler.ApiGwResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashMap;

public final class ODataErrorSerializer {
    private final ObjectMapper _jsonObjectMapper;

    public ODataErrorSerializer(ObjectMapper objectMapper) {
        assert (objectMapper != null);
        this._jsonObjectMapper = objectMapper;
    }

    public void writeError(ApiGwResponse apiGwResponse, Exception exception) throws IOException {
        Object object;
        assert (apiGwResponse != null);
        assert (exception != null);
        int n = 500;
        String string = "InternalError";
        if (exception instanceof ApiGwException) {
            object = (ApiGwException)exception;
            n = ((ApiGwException)object).getHttpStatusCode();
            string = ((ApiGwException)object).getErrorCode();
        }
        if ((object = exception.getMessage()) == null) {
            object = exception.getClass().getCanonicalName();
        }
        apiGwResponse.setStatus(n);
        Throwable throwable = ODataErrorSerializer.getEffectiveThrowable(exception);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("type", throwable.getClass().getCanonicalName());
        linkedHashMap.put("stackTrace", ODataErrorSerializer.printStackTrace(throwable));
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        linkedHashMap2.put("code", string);
        linkedHashMap2.put("message", object);
        linkedHashMap2.put("innererror", linkedHashMap);
        LinkedHashMap<String, LinkedHashMap<String, Object>> linkedHashMap3 = new LinkedHashMap<String, LinkedHashMap<String, Object>>();
        linkedHashMap3.put("error", linkedHashMap2);
        apiGwResponse.setContentType("application/json");
        apiGwResponse.setHeader("OData-Version", "4.0");
        OutputStream outputStream = apiGwResponse.getOutputStream();
        this._jsonObjectMapper.writeValue(outputStream, linkedHashMap3);
        outputStream.flush();
    }

    private static Throwable getEffectiveThrowable(Throwable throwable) {
        ApiGwException apiGwException;
        Throwable throwable2 = throwable;
        if (throwable instanceof ApiGwException && (apiGwException = (ApiGwException)throwable).getCause() != null) {
            throwable2 = apiGwException.getCause();
        }
        return throwable2;
    }

    private static String printStackTrace(Throwable throwable) {
        assert (throwable != null);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

