/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.apigw.odata;

import com.vmware.vcenter.apigw.odata.ODataQuery;
import com.vmware.vcenter.apigw.parse.ApiGwParseUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public final class ODataQueryParser {
    private static final String OPTION_SEPARATOR = "&";
    private static final char OPTION_NAME_SEPARATOR_CHAR = '=';
    private static final String OPTION_SELECT = "$select";
    private static final String SELECT_ITEM_SEPARATOR = ",";
    private static final String SELECT_ALL = "*";

    public static ODataQuery parse(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return new ODataQuery(Collections.emptyList());
        }
        Collection<String> collection = Collections.emptyList();
        block6: for (String string2 : stringArray = string.split(OPTION_SEPARATOR)) {
            if (string2.isEmpty()) {
                throw new IllegalArgumentException(String.format("Redundant '%s' in query string: '%s'", OPTION_SEPARATOR, string));
            }
            int n = string2.indexOf(61);
            if (n <= 0) {
                throw new IllegalArgumentException(String.format("Invalid option '%s' in query string: '%s'", string2, string));
            }
            String string3 = ApiGwParseUtil.percentDecode(string2.substring(0, n));
            String string4 = ApiGwParseUtil.percentDecode(string2.substring(n + 1));
            switch (string3) {
                case "$select": {
                    collection = ODataQueryParser.parseSelect(string4, string);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unrecognized option '%s' in query string: '%s'", string3, string));
                }
            }
        }
        return new ODataQuery(collection);
    }

    private static Collection<String> parseSelect(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        if (string.isEmpty()) {
            throw new IllegalArgumentException(String.format("Empty value of '%s' option in query string: '%s'", OPTION_SELECT, string2));
        }
        if (ApiGwParseUtil.containsWhitespace(string)) {
            throw new IllegalArgumentException(String.format("Found whitespace in '%s' option in query string: '%s'", OPTION_SELECT, string2));
        }
        String[] stringArray = string.split(SELECT_ITEM_SEPARATOR);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string3 : stringArray) {
            if (string3.isEmpty()) {
                throw new IllegalArgumentException(String.format("Empty property name in '%s' option in query string: '%s'", OPTION_SELECT, string2));
            }
            if (SELECT_ALL.equals(string3)) {
                throw new IllegalArgumentException(String.format("Found '%s' in '%s' option in query string: '%s'", SELECT_ALL, OPTION_SELECT, string2));
            }
            arrayList.add(string3);
        }
        return arrayList;
    }
}

