/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.apigw.parse;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public final class ApiGwParseUtil {
    public static String percentDecode(String string) {
        assert (string != null);
        if (string.isEmpty()) {
            return string;
        }
        int n = string.length();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '%') {
                byteArrayOutputStream.write(c);
                continue;
            }
            if (i + 2 >= n) {
                throw new IllegalArgumentException("Invalid percent encoding: " + string.substring(i));
            }
            char c2 = string.charAt(i + 1);
            char c3 = string.charAt(i + 2);
            int n2 = Character.digit(c2, 16);
            int n3 = Character.digit(c3, 16);
            if (n2 == -1 || n3 == -1) {
                throw new IllegalArgumentException("Invalid percent encoding: " + string.substring(i));
            }
            char c4 = (char)((n2 << 4) + n3);
            byteArrayOutputStream.write(c4);
            i += 2;
            bl = true;
        }
        if (!bl) {
            return string;
        }
        try {
            String string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static boolean containsWhitespace(String string) {
        int n;
        assert (string != null);
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (!Character.isWhitespace(n)) continue;
            return true;
        }
        return false;
    }
}

