/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.apigw.parse;

import com.vmware.vcenter.apigw.parse.ApiGwParseUtil;
import com.vmware.vcenter.apigw.parse.ApiGwResourcePath;

public final class ApiGwResourcePathParser {
    private static final char PATH_SEPARATOR_CHAR = '/';
    private static final String PATH_SEPARATOR = Character.toString('/');
    private static final String SCOPE_VCENTERS = "vcenters";
    private static final String SCOPE_LOCAL_VC = "vcenter";
    private static final String SCOPE_GLOBAL = "global";
    private final String _rootUrlPath;

    public ApiGwResourcePathParser(String string) {
        assert (string != null);
        assert (!string.isEmpty());
        assert (string.startsWith(PATH_SEPARATOR));
        if (!string.endsWith(PATH_SEPARATOR)) {
            string = string + PATH_SEPARATOR;
        }
        this._rootUrlPath = string;
    }

    public ApiGwResourcePath parse(String string) {
        String string2;
        assert (string != null);
        if (!string.startsWith(this._rootUrlPath)) {
            throw new IllegalArgumentException(String.format("Request path does not start with '%s' : '%s'", this._rootUrlPath, string));
        }
        String string3 = string.substring(this._rootUrlPath.length());
        String[] stringArray = ApiGwResourcePathParser.percentDecode(string3.split(PATH_SEPARATOR));
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Request path is too short : " + string);
        }
        switch (string2 = ApiGwResourcePathParser.parseScope(stringArray[0], string)) {
            case "vcenters": {
                return ApiGwResourcePathParser.parseVcentersPath(stringArray, string);
            }
            case "vcenter": {
                throw new UnsupportedOperationException("Local VC requests are not yet implemented");
            }
            case "global": {
                throw new UnsupportedOperationException("Global requests are not yet implemented");
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized scope segment '%s' in OData request path : '%s'", string2, string));
    }

    private static String parseScope(String string, String string2) {
        String string3 = string;
        if (string3.isEmpty()) {
            throw new IllegalArgumentException("Request path has empty scope segment : " + string2);
        }
        return string3;
    }

    private static ApiGwResourcePath parseVcentersPath(String[] stringArray, String string) {
        assert (stringArray != null);
        assert (stringArray.length > 0);
        assert (SCOPE_VCENTERS.equals(stringArray[0]));
        assert (string != null);
        if (stringArray.length < 3) {
            throw new IllegalArgumentException("Request path is too short : " + string);
        }
        String string2 = ApiGwResourcePathParser.parseNodeId(stringArray[1], string);
        String string3 = ApiGwResourcePathParser.parseResourceCollection(stringArray[2], string);
        String string4 = "";
        if (stringArray.length == 4) {
            string4 = ApiGwResourcePathParser.parseResourceId(stringArray[3], string);
        } else if (stringArray.length > 4) {
            throw new IllegalArgumentException(String.format("Too many segments in request path after resource collection '%s' : '%s'", string3, string));
        }
        return new ApiGwResourcePath(string2, string3, string4);
    }

    private static String parseNodeId(String string, String string2) {
        String string3 = string;
        if (string3.isEmpty()) {
            throw new IllegalArgumentException("Request path has empty node id segment : " + string2);
        }
        if (ApiGwParseUtil.containsWhitespace(string3)) {
            throw new IllegalArgumentException("Whitespace in node id segment of request path: " + string2);
        }
        return string3;
    }

    private static String parseResourceCollection(String string, String string2) {
        String string3 = string;
        if (string3.isEmpty()) {
            throw new IllegalArgumentException("Request path has empty resource collection segment: " + string2);
        }
        if (ApiGwParseUtil.containsWhitespace(string3)) {
            throw new IllegalArgumentException("Whitespace in resource collection segment of request path: " + string2);
        }
        if (string3.endsWith(")")) {
            throw new UnsupportedOperationException("Collection navigation is not supported: " + string2);
        }
        return string3;
    }

    private static String parseResourceId(String string, String string2) {
        String string3 = string;
        if (string3.isEmpty()) {
            throw new IllegalArgumentException("Request path has empty resource id segment : " + string2);
        }
        if (ApiGwParseUtil.containsWhitespace(string3)) {
            throw new IllegalArgumentException("Whitespace in resource id segment of request path: " + string2);
        }
        return string3;
    }

    private static String[] percentDecode(String[] stringArray) {
        assert (stringArray != null);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = ApiGwParseUtil.percentDecode(stringArray[i]);
        }
        return stringArray2;
    }
}

