/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcenter.apigw.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vcenter.apigw.exception.ApiGwException;
import com.vmware.vcenter.apigw.handler.ApiGwRequestHandler;
import com.vmware.vcenter.apigw.handler.risetovise.RiseToViseApiGwRequestHandler;
import com.vmware.vcenter.apigw.odata.ODataErrorSerializer;
import com.vmware.vcenter.apigw.parse.ApiGwResourcePath;
import com.vmware.vcenter.apigw.parse.ApiGwResourcePathParser;
import com.vmware.vcenter.apigw.servlet.ServletApiGwRequest;
import com.vmware.vcenter.apigw.servlet.ServletApiGwResponse;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiGwServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = LoggerFactory.getLogger(ApiGwServlet.class);
    private final String _servletPath;
    private final ODataErrorSerializer _errorSerializer;
    private final ApiGwRequestHandler _provider;

    public ApiGwServlet(String string, QueryServiceFactory queryServiceFactory, ObjectMapper objectMapper) {
        Validate.notEmpty((String)string);
        Validate.notNull((Object)queryServiceFactory);
        Validate.notNull((Object)objectMapper);
        this._servletPath = string;
        this._errorSerializer = new ODataErrorSerializer(objectMapper);
        this._provider = new RiseToViseApiGwRequestHandler(queryServiceFactory.getQueryService(), objectMapper);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        assert (httpServletRequest != null);
        assert (httpServletResponse != null);
        String string = ApiGwServlet.getOpId(httpServletRequest);
        _logger.info("Received request opId='{}' uri='{}'", (Object)string, (Object)ApiGwServlet.getFullUri(httpServletRequest));
        ServletApiGwResponse servletApiGwResponse = new ServletApiGwResponse(string, httpServletResponse);
        try {
            ApiGwResourcePath apiGwResourcePath = this.parseUrlPath(httpServletRequest);
            ServletApiGwRequest servletApiGwRequest = new ServletApiGwRequest(string, apiGwResourcePath.nodeId, apiGwResourcePath.resourceCollection, apiGwResourcePath.resourceId, httpServletRequest);
            this._provider.handleRequest(servletApiGwRequest, servletApiGwResponse);
        }
        catch (RuntimeException runtimeException) {
            _logger.error("Error when processing request opId='{}' uri='{}'", new Object[]{string, ApiGwServlet.getFullUri(httpServletRequest), runtimeException});
            this._errorSerializer.writeError(servletApiGwResponse, runtimeException);
        }
    }

    private ApiGwResourcePath parseUrlPath(HttpServletRequest httpServletRequest) {
        assert (httpServletRequest != null);
        String string = ApiGwServlet.requireContextPath(httpServletRequest);
        String string2 = ApiGwServlet.requireRequestURI(httpServletRequest);
        String string3 = string + this._servletPath;
        try {
            ApiGwResourcePathParser apiGwResourcePathParser = new ApiGwResourcePathParser(string3);
            ApiGwResourcePath apiGwResourcePath = apiGwResourcePathParser.parse(string2);
            return apiGwResourcePath;
        }
        catch (RuntimeException runtimeException) {
            throw new ApiGwException(400, "BadSyntax", runtimeException);
        }
    }

    private static String requireRequestURI(HttpServletRequest httpServletRequest) {
        assert (httpServletRequest != null);
        String string = httpServletRequest.getRequestURI();
        if (string == null || string.isEmpty()) {
            throw new ApiGwException(500, "InternalError", "Missing servlet request URI");
        }
        String string2 = ApiGwServlet.requireContextPath(httpServletRequest);
        if (!string.startsWith(string2)) {
            throw new ApiGwException(500, "InternalError", String.format("Servlet request URI '%s' does not start with context path '%s'", string, string2));
        }
        return string;
    }

    private static String requireContextPath(HttpServletRequest httpServletRequest) {
        assert (httpServletRequest != null);
        String string = httpServletRequest.getContextPath();
        if (string == null) {
            throw new ApiGwException(500, "InternalError", "Missing servlet context path");
        }
        return string;
    }

    private static String getOpId(HttpServletRequest httpServletRequest) {
        assert (httpServletRequest != null);
        String string = null;
        try {
            string = httpServletRequest.getHeader("X-Request-ID");
        }
        catch (RuntimeException runtimeException) {
            _logger.error("HttpServletRequest.getHeader() failed", (Throwable)runtimeException);
        }
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String getFullUri(HttpServletRequest httpServletRequest) {
        assert (httpServletRequest != null);
        String string = "";
        try {
            string = httpServletRequest.getRequestURI();
        }
        catch (RuntimeException runtimeException) {
            _logger.error("HttpServletRequest.getRequestURI failed", (Throwable)runtimeException);
            return "";
        }
        String string2 = null;
        try {
            string2 = httpServletRequest.getQueryString();
        }
        catch (RuntimeException runtimeException) {
            _logger.error("HttpServletRequest.getQueryString failed", (Throwable)runtimeException);
        }
        String string3 = string2 == null || string2.isEmpty() ? string : string + "?" + string2;
        return string3;
    }
}

