/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.adapters.federation.IdentifiableServiceInstance;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.vmomi.impl.HttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.util.VmomiVersion;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.schema.QuerySchemaCache;
import com.vmware.cis.data.provider.registry.DataProviderLookup;
import com.vmware.cis.data.provider.registry.QueryModelLookup;
import com.vmware.cis.data.provider.registry.VcenterDataProviderFactoryLookup;
import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.DataServiceRiseModeAdapter;
import com.vmware.vise.data.adapters.core.LookupServiceLocator;
import com.vmware.vise.data.adapters.core.ObjectPropertyRequestReducerDecorator;
import com.vmware.vise.data.adapters.core.QueryServiceConnection;
import com.vmware.vise.data.adapters.core.QueryServiceConnectionFactory;
import com.vmware.vise.data.adapters.core.QuickSearchDynamicProviderAdapter;
import com.vmware.vise.data.adapters.core.alien.AlienVcAwareQueryService;
import com.vmware.vise.data.adapters.core.mixfed.DataServiceMixedFederationAdapter;
import com.vmware.vise.data.adapters.core.mixfed.MixedFederationInventoryServiceTracker;
import com.vmware.vise.data.adapters.core.tagging.InventoryServiceTaggingQueryModel;
import com.vmware.vise.data.adapters.core.translator.cornercase.AllowMultipleModelKeyPredicates;
import com.vmware.vise.data.adapters.core.translator.cornercase.WebClientDerivedProperties;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.BuildProperties;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.data.adapters.common.DataAdapterConfiguration;
import com.vmware.vise.vim.data.adapters.common.SearchMetadataQueryCriteria;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.security.sso.SsoService;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataServiceCoreAdapter
implements DynamicProviderAdapter,
UserSessionListener {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceCoreAdapter.class);
    private static final String SESSION_KEY_DS2_CONTEXT = "SESSION_KEY_DS2_CONTEXT";
    private final ConfigurationService _configurationService;
    private final DynamicProviderAdapter _isa;
    private final SsoService _ssoService;
    private final ExecutorService _executor;
    private final SearchMetadataQueryCriteria _searchMetadataQueryCriteria;
    private final DataAdapterConfiguration _dataAdapterConfiguration;
    private final ResourceModelTypeProvider _vapiTypeProvider;
    private final HttpConfigurationFactory _vlsiHttpConfigFactory;
    private final VapiProtocolConnectionFactory _vapiConnectionFactory;
    private final DataProviderLookup _clientProviders;
    private final VcenterDataProviderFactoryLookup _vcenterDataProviderFactoryLookup;
    private final QueryModelLookup _queryModelLookup;
    private final KeystoreService _keystoreService;
    private final LookupService _lookupService;
    private final QuerySchemaCache _schemaCache;
    private final AtomicBoolean _schemaDumped = new AtomicBoolean(false);
    private volatile QuerySchema _dsSchema = null;

    public DataServiceCoreAdapter(DynamicProviderAdapter dynamicProviderAdapter, ConfigurationService configurationService, SsoService ssoService, ExecutorService executorService, SearchMetadataQueryCriteria searchMetadataQueryCriteria, DataAdapterConfiguration dataAdapterConfiguration, ResourceModelTypeProvider resourceModelTypeProvider, HttpConfigurationFactory httpConfigurationFactory, VapiProtocolConnectionFactory vapiProtocolConnectionFactory, DataProviderLookup dataProviderLookup, VcenterDataProviderFactoryLookup vcenterDataProviderFactoryLookup, QueryModelLookup queryModelLookup, KeystoreService keystoreService, LookupService lookupService, QuerySchemaCache querySchemaCache) {
        Validate.notNull((Object)dynamicProviderAdapter, (String)"isa");
        Validate.notNull((Object)configurationService, (String)"configurationService");
        Validate.notNull((Object)ssoService, (String)"ssoService");
        Validate.notNull((Object)executorService, (String)"executor");
        Validate.notNull((Object)searchMetadataQueryCriteria, (String)"searchMetadataQueryCriteria");
        Validate.notNull((Object)dataAdapterConfiguration, (String)"dataAdapterConfiguration");
        Validate.notNull((Object)resourceModelTypeProvider, (String)"vapiTypeProvider");
        Validate.notNull((Object)httpConfigurationFactory, (String)"vlsiHttpConfigFactory");
        Validate.notNull((Object)vapiProtocolConnectionFactory, (String)"vapiConnectionFactory");
        Validate.notNull((Object)dataProviderLookup, (String)"clientProviders");
        Validate.notNull((Object)vcenterDataProviderFactoryLookup, (String)"vcenterDataProviderFactoryLookup");
        Validate.notNull((Object)queryModelLookup, (String)"queryModelLookup");
        Validate.notNull((Object)keystoreService, (String)"keystoreService");
        Validate.notNull((Object)lookupService, (String)"lookupService");
        Validate.notNull((Object)querySchemaCache, (String)"schemaCache");
        this._isa = dynamicProviderAdapter;
        this._configurationService = configurationService;
        this._ssoService = ssoService;
        this._executor = executorService;
        this._searchMetadataQueryCriteria = searchMetadataQueryCriteria;
        this._dataAdapterConfiguration = dataAdapterConfiguration;
        this._vapiTypeProvider = resourceModelTypeProvider;
        this._vlsiHttpConfigFactory = httpConfigurationFactory;
        this._vapiConnectionFactory = vapiProtocolConnectionFactory;
        this._clientProviders = dataProviderLookup;
        this._queryModelLookup = queryModelLookup;
        this._vcenterDataProviderFactoryLookup = vcenterDataProviderFactoryLookup;
        this._keystoreService = keystoreService;
        this._lookupService = lookupService;
        this._schemaCache = querySchemaCache;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        Validate.notNull((Object)requestSpec);
        DynamicProviderAdapter dynamicProviderAdapter = this.getAdapterForCurrentSession();
        return dynamicProviderAdapter.getData(requestSpec);
    }

    private DynamicProviderAdapter getAdapterForCurrentSession() {
        HttpSession httpSession = SessionUtil.getHttpSession();
        final String string = SessionUtil.getClientId((HttpSession)httpSession);
        this.requireTokenInSession(string);
        Supplier supplier = Suppliers.memoize((Supplier)new Supplier<DataServiceSessionContext>(){

            public DataServiceSessionContext get() {
                DataServiceSessionContext dataServiceSessionContext;
                _logger.info("Creating new DS Core session for clientId: {}", (Object)SessionUtil.getHashedClientId((String)string));
                try {
                    dataServiceSessionContext = DataServiceCoreAdapter.this.newDsSessionContextFor(string);
                }
                catch (Exception exception) {
                    _logger.error("Could not initialize DS Core session for clientId: {}", (Object)SessionUtil.getHashedClientId((String)string), (Object)exception);
                    throw exception;
                }
                return dataServiceSessionContext;
            }
        });
        Supplier supplier2 = (Supplier)SessionUtil.setDataIfAbsent((String)SESSION_KEY_DS2_CONTEXT, (Object)supplier, (String)string);
        if (supplier2 != null) {
            supplier = supplier2;
        }
        return ((DataServiceSessionContext)supplier.get()).adapter;
    }

    private DataServiceSessionContext newDsSessionContextFor(final String string) {
        DataServiceCoreAdapter.cancelIfInterrupted();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId((String)string);
        List<LinkedVcGroup> list = Arrays.asList(linkedVcGroupRegistry.getLinkedVcGroups());
        MixedFederationInventoryServiceTracker mixedFederationInventoryServiceTracker = MixedFederationInventoryServiceTracker.forSession(string);
        QuickSearchDynamicProviderAdapter quickSearchDynamicProviderAdapter = new QuickSearchDynamicProviderAdapter(this._isa, mixedFederationInventoryServiceTracker);
        if (mixedFederationInventoryServiceTracker.onlyInvSvcNodes()) {
            _logger.info("Will not wire RISE data provider infrastructure because there are only nodes with InventoryService.");
            return new DataServiceSessionContext(quickSearchDynamicProviderAdapter);
        }
        final Map<String, IdentifiableServiceInstance> map = this.createVpxdInstanceIdByNodeId(list);
        QueryServiceConnection queryServiceConnection = this.connectToDsCore(new LookupServiceLocator(this._keystoreService, this._lookupService, list, this._configurationService), string, map);
        AlienVcAwareQueryService alienVcAwareQueryService = AlienVcAwareQueryService.withAlienVcSupport(new AlienVcAwareQueryService.QueryServiceConnectionPolicy(){

            @Override
            public QueryServiceConnection getConnection(ServiceLocator serviceLocator, AuthenticationTokenSource authenticationTokenSource) {
                return DataServiceCoreAdapter.this.connectToDsCore(serviceLocator, string, map);
            }
        }, queryServiceConnection, string);
        CoreQueryService coreQueryService = this.extendWithViseTranslation(alienVcAwareQueryService);
        QuerySchema querySchema = this.getCurrentSchema(coreQueryService);
        if (_logger.isDebugEnabled() && this._schemaDumped.compareAndSet(false, true)) {
            _logger.debug("Effective schema of all registered DataProviders: {}", (Object)querySchema);
        }
        ObjectPropertyRequestReducerDecorator objectPropertyRequestReducerDecorator = new ObjectPropertyRequestReducerDecorator(DataServiceMixedFederationAdapter.federateWithLegacyNodes(quickSearchDynamicProviderAdapter, new DataServiceRiseModeAdapter(coreQueryService, querySchema, this._executor, string), this._executor, this._searchMetadataQueryCriteria.getMetadataDirectory(), mixedFederationInventoryServiceTracker));
        _logger.info("Successfully created new DS Core session for clientId: {}", (Object)SessionUtil.getHashedClientId((String)string));
        return new DataServiceSessionContext(objectPropertyRequestReducerDecorator, alienVcAwareQueryService);
    }

    private Map<String, IdentifiableServiceInstance> createVpxdInstanceIdByNodeId(Collection<LinkedVcGroup> collection) {
        LinkedHashMap<String, IdentifiableServiceInstance> linkedHashMap = new LinkedHashMap<String, IdentifiableServiceInstance>();
        for (LinkedVcGroup linkedVcGroup : collection) {
            Collection collection2 = linkedVcGroup.getVcServices();
            for (VcService vcService : collection2) {
                ServiceEndpointEx serviceEndpointEx = DataServiceCoreAdapter.getVcEndpointEx(vcService);
                AboutInfo aboutInfo = vcService.getServiceInstanceContent().about;
                final String string = aboutInfo.version;
                final String string2 = aboutInfo.instanceUuid;
                final String string3 = aboutInfo.build;
                linkedHashMap.put(serviceEndpointEx.getLduGuid(), new IdentifiableServiceInstance(){

                    public String getVersion() {
                        return string;
                    }

                    public String getServiceInstanceUuid() {
                        return string2;
                    }

                    public String getBuild() {
                        return string3;
                    }
                });
            }
        }
        return linkedHashMap;
    }

    private static ServiceEndpointEx getVcEndpointEx(VcService vcService) {
        assert (vcService != null);
        assert (vcService.getServiceGuid() != null);
        String string = vcService.getServiceGuid();
        for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
            if (!string.equals(serviceEndpointEx.getInstanceUuid())) continue;
            return serviceEndpointEx;
        }
        _logger.error("Could not find VC among the endpoints of VcService for '{}': {}", (Object)vcService.getServiceUrl(), (Object)Arrays.toString(vcService.getServiceEndPoints()));
        throw new IllegalArgumentException("Could not find VC among the endpoints of VcService for " + vcService.getServiceUrl());
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        if (httpSessionEvent == null) {
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        if (httpSession == null) {
            return;
        }
        Supplier supplier = (Supplier)SessionUtil.removeData((String)SESSION_KEY_DS2_CONTEXT, (HttpSession)httpSession);
        if (supplier == null) {
            return;
        }
        AutoCloseable autoCloseable = ((DataServiceSessionContext)supplier.get()).connection;
        if (autoCloseable != null) {
            _logger.info("Closing DS session for HttpSession 0x{} clientId: {}", (Object)Integer.toHexString(System.identityHashCode(httpSession)), (Object)SessionUtil.getHashedClientId((HttpSession)httpSession));
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                _logger.warn("Error while closing data provider session", (Throwable)exception);
            }
        }
    }

    private QueryServiceConnection connectToDsCore(ServiceLocator serviceLocator, String string, Map<String, IdentifiableServiceInstance> map) {
        QueryServiceConnection queryServiceConnection = QueryServiceConnectionFactory.getConnection(serviceLocator, map, this._executor, this._vapiTypeProvider, this._vlsiHttpConfigFactory, this._vapiConnectionFactory, this._clientProviders, this._vcenterDataProviderFactoryLookup, this._queryModelLookup, this._schemaCache, this._ssoService, this.retrieveVmomiVersion(), string, this._dataAdapterConfiguration.getRiseAdapterLoginThreshold(), this._dataAdapterConfiguration.getRiseAdapterLogoutThreshold(), this._dataAdapterConfiguration.getRiseAdapterOperationThreshold());
        return queryServiceConnection;
    }

    private CoreQueryService extendWithViseTranslation(CoreQueryService coreQueryService) {
        AllowMultipleModelKeyPredicates allowMultipleModelKeyPredicates = new AllowMultipleModelKeyPredicates(InventoryServiceTaggingQueryModel.withInvSvcTagging(coreQueryService));
        final CoreQueryService coreQueryService2 = BuildProperties.isH5Client() ? allowMultipleModelKeyPredicates : WebClientDerivedProperties.withWebClientDerivedProperties(allowMultipleModelKeyPredicates);
        CoreQueryService coreQueryService3 = new CoreQueryService(){

            @Override
            public QuerySchema getSchema() {
                DataServiceCoreAdapter.cancelIfInterrupted();
                return coreQueryService2.getSchema();
            }

            @Override
            public ResultSet executeQuery(Query query) {
                DataServiceCoreAdapter.cancelIfInterrupted();
                return coreQueryService2.executeQuery(query);
            }
        };
        return coreQueryService3;
    }

    private VmomiVersion retrieveVmomiVersion() {
        String string = this._configurationService.getProperty("dataservice.vmodl.version");
        if (string != null) {
            try {
                return VmomiVersion.valueOf((String)string.toUpperCase());
            }
            catch (RuntimeException runtimeException) {
                _logger.error("Unsupported Value '{}' for {}", (Object)string, (Object)"dataservice.vmodl.version");
                throw runtimeException;
            }
        }
        String string2 = this._configurationService.getProperty("use.unstable.vmodl");
        Boolean bl = BooleanUtils.toBooleanObject((String)string2);
        boolean bl2 = bl != null ? bl : false;
        return bl2 ? VmomiVersion.NEWEST : VmomiVersion.PUBLIC;
    }

    private void requireTokenInSession(String string) {
        if (string == null) {
            throw new IllegalStateException("Data Service invoked a HttpSession without clientId, but a clientId is required.");
        }
        if (AuthSessionUtil.getSsoToken((String)string) == null) {
            throw new IllegalStateException("Data Service invoked in a user's session lacking authentication token, but a token is required.");
        }
    }

    private QuerySchema getCurrentSchema(CoreQueryService coreQueryService) {
        QuerySchema querySchema = this._dsSchema;
        QuerySchema querySchema2 = coreQueryService.getSchema();
        if (querySchema == null) {
            this._dsSchema = querySchema2;
            return querySchema2;
        }
        if (querySchema2.equals((Object)querySchema)) {
            return querySchema;
        }
        this._dsSchema = querySchema2;
        return querySchema2;
    }

    private static void cancelIfInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException(String.format("Call to %s was cancelled.", DataServiceCoreAdapter.class.getSimpleName()));
        }
    }

    private static final class DataServiceSessionContext {
        final DynamicProviderAdapter adapter;
        final AutoCloseable connection;

        DataServiceSessionContext(DynamicProviderAdapter dynamicProviderAdapter) {
            this(dynamicProviderAdapter, null);
        }

        DataServiceSessionContext(DynamicProviderAdapter dynamicProviderAdapter, AutoCloseable autoCloseable) {
            assert (dynamicProviderAdapter != null);
            this.adapter = dynamicProviderAdapter;
            this.connection = autoCloseable;
        }
    }
}

