/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.profiler.QueryIdLogConfigurator;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.MemoizingConnection;
import com.vmware.vise.data.adapters.core.RequestConverter;
import com.vmware.vise.data.adapters.core.ViseQueryExecutor;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.impl.Utils;
import com.vmware.vise.data.query.internal.profiling.ViseDsLogConfigurator;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataServiceRiseModeAdapter
implements DynamicProviderAdapter {
    private static final Logger _logger = LoggerFactory.getLogger(DataServiceRiseModeAdapter.class);
    private final CoreQueryService _queryService;
    private final ViseQueryExecutor _queryExecutor;
    private final ExecutorService _executor;

    DataServiceRiseModeAdapter(CoreQueryService coreQueryService, QuerySchema querySchema, ExecutorService executorService, String string) {
        assert (coreQueryService != null);
        assert (querySchema != null);
        assert (executorService != null);
        assert (string != null);
        this._queryService = coreQueryService;
        RequestConverter requestConverter = new RequestConverter(querySchema);
        this._queryExecutor = new ViseQueryExecutor(requestConverter, executorService);
        this._executor = executorService;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        assert (requestSpec != null);
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        MemoizingConnection memoizingConnection = new MemoizingConnection(this._queryService);
        long l = System.currentTimeMillis();
        DynamicProviderResultSet[] dynamicProviderResultSetArray = this.executeQueries(memoizingConnection, querySpecArray);
        if (_logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            _logger.debug("Entire request executed in {} ms", (Object)l2);
            _logger.debug("Core Data Service (RISE) returned results: \n{}", (Object)Utils.renderResultSets((com.vmware.vise.data.query.ResultSet[])dynamicProviderResultSetArray));
        }
        Response response = new Response();
        response.resultSet = dynamicProviderResultSetArray;
        return response;
    }

    private DynamicProviderResultSet[] executeQueries(CoreQueryService coreQueryService, QuerySpec[] querySpecArray) throws Exception {
        assert (coreQueryService != null);
        assert (querySpecArray != null);
        if (querySpecArray.length == 1) {
            DynamicProviderResultSet dynamicProviderResultSet = this.executeQuery(coreQueryService, querySpecArray[0]);
            return new DynamicProviderResultSet[]{dynamicProviderResultSet};
        }
        List<Callable<DynamicProviderResultSet>> list = this.createQueryTasks(coreQueryService, querySpecArray);
        List list2 = ExecutorUtil.executeTasks(list, (Executor)this._executor, (long)-1L, (TimeUnit)TimeUnit.MILLISECONDS, (boolean)true, (boolean)true, (boolean)true);
        assert (list2.size() == list.size());
        DynamicProviderResultSet[] dynamicProviderResultSetArray = DataServiceRiseModeAdapter.toResultSets(list2, querySpecArray);
        return dynamicProviderResultSetArray;
    }

    private List<Callable<DynamicProviderResultSet>> createQueryTasks(final CoreQueryService coreQueryService, QuerySpec[] querySpecArray) {
        assert (coreQueryService != null);
        assert (querySpecArray != null);
        ArrayList<Callable<DynamicProviderResultSet>> arrayList = new ArrayList<Callable<DynamicProviderResultSet>>(querySpecArray.length);
        for (int i = 0; i < querySpecArray.length; ++i) {
            final QuerySpec querySpec = querySpecArray[i];
            Callable<DynamicProviderResultSet> callable = new Callable<DynamicProviderResultSet>(){

                @Override
                public DynamicProviderResultSet call() throws Exception {
                    return DataServiceRiseModeAdapter.this.executeQuery(coreQueryService, querySpec);
                }
            };
            arrayList.add(callable);
        }
        return arrayList;
    }

    private static DynamicProviderResultSet[] toResultSets(Collection<ExecutorUtil.TaskResult<DynamicProviderResultSet>> collection, QuerySpec[] querySpecArray) {
        assert (collection != null);
        assert (querySpecArray != null);
        DynamicProviderResultSet[] dynamicProviderResultSetArray = new DynamicProviderResultSet[querySpecArray.length];
        int n = 0;
        for (ExecutorUtil.TaskResult<DynamicProviderResultSet> taskResult : collection) {
            QuerySpec querySpec = querySpecArray[n];
            DynamicProviderResultSet dynamicProviderResultSet = DataServiceRiseModeAdapter.toResultSet(taskResult, querySpec);
            dynamicProviderResultSetArray[n++] = dynamicProviderResultSet;
        }
        return dynamicProviderResultSetArray;
    }

    private static DynamicProviderResultSet toResultSet(ExecutorUtil.TaskResult<DynamicProviderResultSet> taskResult, QuerySpec querySpec) {
        assert (taskResult != null);
        assert (querySpec != null);
        if (taskResult.getException() != null) {
            DynamicProviderResultSet dynamicProviderResultSet = new DynamicProviderResultSet();
            dynamicProviderResultSet.queryName = querySpec.name;
            dynamicProviderResultSet.error = taskResult.getException();
            dynamicProviderResultSet.allowFallbackRequest = false;
            return dynamicProviderResultSet;
        }
        return (DynamicProviderResultSet)taskResult.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicProviderResultSet executeQuery(CoreQueryService coreQueryService, QuerySpec querySpec) {
        try (ViseDsLogConfigurator.ViseDsLogContext viseDsLogContext = ViseDsLogConfigurator.onQueryStart((QuerySpec)querySpec);){
            CoreQueryService coreQueryService2 = this.createQSWrapperForViseQuery(coreQueryService);
            DynamicProviderResultSet dynamicProviderResultSet = this.processRiseQuery(coreQueryService2, querySpec);
            return dynamicProviderResultSet;
        }
    }

    private DynamicProviderResultSet processRiseQuery(CoreQueryService coreQueryService, QuerySpec querySpec) {
        assert (querySpec != null);
        long l = System.currentTimeMillis();
        DynamicProviderResultSet dynamicProviderResultSet = this._queryExecutor.execute(coreQueryService, querySpec);
        dynamicProviderResultSet.allowFallbackRequest = false;
        if (_logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            _logger.debug("Single query executed in {} ms", (Object)l2);
        }
        return dynamicProviderResultSet;
    }

    private CoreQueryService createQSWrapperForViseQuery(CoreQueryService coreQueryService) {
        return new NestedQueryCounter(coreQueryService);
    }

    private static final class NestedQueryCounter
    implements CoreQueryService {
        private final CoreQueryService _delegate;
        private final QueryIdLogConfigurator.QueryCounter _queryCounter;

        public NestedQueryCounter(CoreQueryService coreQueryService) {
            this._delegate = coreQueryService;
            this._queryCounter = QueryIdLogConfigurator.newQueryCounter((String)"");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResultSet executeQuery(Query query) {
            try (QueryIdLogConfigurator queryIdLogConfigurator = this._queryCounter.onQueryStart();){
                ResultSet resultSet = this._delegate.executeQuery(query);
                return resultSet;
            }
        }

        @Override
        public QuerySchema getSchema() {
            return this._delegate.getSchema();
        }

        public String toString() {
            return this._delegate.toString();
        }
    }
}

