/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticator;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiSession;
import com.vmware.cis.data.internal.provider.AuthenticationTokenSource;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinkedVcGroupRegistryBasedVmomiAuthenticatorFactory
implements VmomiAuthenticatorFactory {
    private static final Logger _logger = LoggerFactory.getLogger(LinkedVcGroupRegistryBasedVmomiAuthenticatorFactory.class);
    private final LinkedVcGroupRegistry _vcRegistry;

    public LinkedVcGroupRegistryBasedVmomiAuthenticatorFactory(LinkedVcGroupRegistry linkedVcGroupRegistry) {
        assert (linkedVcGroupRegistry != null);
        this._vcRegistry = linkedVcGroupRegistry;
    }

    public VmomiAuthenticator getAuthenticator(ServiceEndpointInfo serviceEndpointInfo) {
        assert (serviceEndpointInfo != null);
        VcService vcService = this.getVcServiceByServiceUuid(serviceEndpointInfo.getServiceUuid());
        if (vcService != null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Reusing VC session for VC at '{}' with id '{}' from VcService [url = '{}', guid='{}', version='{}']", new Object[]{serviceEndpointInfo.getUrl(), serviceEndpointInfo.getServiceUuid(), vcService.getServiceUrl(), vcService.getServiceGuid(), vcService.getServiceVersion()});
            }
            return new VcServiceBasedVmomiAuthenticator(vcService);
        }
        _logger.debug("Creating own VC session because there is no VcService for VC at '{}' with id '{}'", (Object)serviceEndpointInfo.getUrl(), (Object)serviceEndpointInfo.getServiceUuid());
        return null;
    }

    private VcService getVcServiceByServiceUuid(String string) {
        assert (string != null);
        for (LinkedVcGroup linkedVcGroup : this._vcRegistry.getLinkedVcGroups()) {
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                for (ServiceEndpointEx serviceEndpointEx : vcService.getServiceEndPoints()) {
                    if (!string.equals(serviceEndpointEx.getInstanceUuid()) || !vcService.getServiceGuid().equals(serviceEndpointEx.getVcGuid())) continue;
                    return vcService;
                }
            }
        }
        return null;
    }

    private static final class VcServiceBasedVmomiSession
    implements VmomiSession {
        private final VcService _vcService;

        VcServiceBasedVmomiSession(VcService vcService) {
            assert (vcService != null);
            this._vcService = vcService;
        }

        public String getSessionCookie() {
            String string = this._vcService.getConnectionInfo().getSessionCookie();
            if (string == null) {
                throw new IllegalStateException("Session is closed");
            }
            return string;
        }

        public String renewSessionCookie(String string) {
            assert (string != null);
            String string2 = this.getSessionCookie();
            if (!string2.equals(string)) {
                _logger.debug("Detected renewed VC session for VC at '{}'", (Object)this._vcService.getServiceUrl());
                return string2;
            }
            ManagedObjectReference managedObjectReference = new ManagedObjectReference("ServiceInstance", "ServiceInstance", null);
            ServiceInstance serviceInstance = (ServiceInstance)this._vcService.getManagedObject(managedObjectReference);
            serviceInstance.currentTime();
            _logger.debug("Renewed expired VC session for VC at '{}'", (Object)this._vcService.getServiceUrl());
            return this.getSessionCookie();
        }

        public void logout() {
        }
    }

    private static final class VcServiceBasedVmomiAuthenticator
    implements VmomiAuthenticator {
        private final VcService _vcService;

        VcServiceBasedVmomiAuthenticator(VcService vcService) {
            assert (vcService != null);
            this._vcService = vcService;
        }

        public VmomiSession login(AuthenticationTokenSource authenticationTokenSource) {
            return new VcServiceBasedVmomiSession(this._vcService);
        }
    }
}

