/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.google.common.collect.HashMultimap;
import com.vmware.cis.data.internal.adapters.lookup.ServiceEndpointInfo;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.provider.SsoDomain;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.lookup.LookupService;
import com.vmware.vise.vim.lookup.LookupUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LookupServiceLocator
implements ServiceLocator {
    private static final Logger _logger = LoggerFactory.getLogger(LookupServiceLocator.class);
    private static final String SETTING_DEV_MODE = "local.development";
    private final KeystoreService _truststoreProvider;
    private final LookupService _lookupService;
    private final Collection<LinkedVcGroup> _linkedVcGroups;
    private final boolean _isDevMode;

    public LookupServiceLocator(KeystoreService keystoreService, LookupService lookupService, Collection<LinkedVcGroup> collection, ConfigurationService configurationService) {
        Validate.notNull((Object)keystoreService, (String)"truststoreProvider");
        Validate.notNull((Object)lookupService, (String)"lookupService");
        Validate.notNull(collection, (String)"linkedVcGroups");
        Validate.notNull((Object)configurationService, (String)"configurationService");
        this._truststoreProvider = keystoreService;
        this._lookupService = lookupService;
        this._linkedVcGroups = collection;
        this._isDevMode = LookupServiceLocator.isDevMode(configurationService);
    }

    public Collection<ServiceEndpointInfo> findServiceEndpoints(String string, String string2, String string3, String string4) {
        Map<String, Class<?>> map = LookupServiceLocator.extractNodeIdsOfActiveVcServices(this._linkedVcGroups);
        if (map.isEmpty()) {
            _logger.warn("No target nodes found from the LinkedVcGroupRegistry. No Data Providers will be discovered.");
            return Collections.emptyList();
        }
        _logger.debug("DS federation will include the services on the nodes: {}", map.keySet());
        Map<String, Collection<EndpointAtNode>> map2 = this.findEndpoints(map, string, string2, string3, string4);
        ArrayList<ServiceEndpointInfo> arrayList = new ArrayList<ServiceEndpointInfo>();
        for (String string5 : map2.keySet()) {
            for (EndpointAtNode endpointAtNode : map2.get(string5)) {
                ServiceRegistration.Endpoint endpoint = endpointAtNode.endpoint;
                String string6 = endpointAtNode.nodeId;
                String string7 = endpointAtNode.serviceId;
                Class<?> clazz = endpointAtNode.vmodlVersion;
                ServiceEndpointInfo serviceEndpointInfo = new ServiceEndpointInfo(string5, endpoint.getUrl(), string6, this._truststoreProvider.getKeyStore(), endpoint.getEndpointType().getType(), endpoint.getEndpointType().getProtocol(), string7, clazz, endpointAtNode.ssoDomain);
                arrayList.add(serviceEndpointInfo);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Map<String, Collection<EndpointAtNode>> findEndpoints(Map<String, Class<?>> map, String string, String string2, String string3, String string4) {
        ServiceRegistration.Filter filter = LookupServiceLocator.createSearchFilter(string, string2, string3, string4);
        Object[] objectArray = this.searchLookupService(filter);
        String string5 = LookupUtil.getLocalHostId((LookupService)this._lookupService);
        if (string5 == null) {
            _logger.warn("The hostId is unknown in LookupService, not possible to find local nodes.");
        }
        if (ArrayUtils.isEmpty((Object[])objectArray)) {
            return Collections.emptyMap();
        }
        HashMultimap hashMultimap = HashMultimap.create();
        for (Object object : objectArray) {
            if (!LookupServiceLocator.serviceTypeMatchesFilter(object.getServiceType(), string, string2)) continue;
            String string6 = LookupServiceLocator.makeServiceTypeId(object.getServiceType().getProduct(), object.getServiceType().getType());
            String string7 = object.getNodeId();
            Object[] objectArray2 = object.getServiceEndpoints();
            if (ArrayUtils.isEmpty((Object[])objectArray2)) {
                _logger.warn("No endpoints were returned by the LookupService for entry {}. Entry ignored.", (Object)string6);
                continue;
            }
            ArrayList<EndpointAtNode> arrayList = new ArrayList<EndpointAtNode>(objectArray2.length);
            String string8 = LookupUtil.getServiceHostId((ServiceRegistration.Info)object);
            for (Object object2 : objectArray2) {
                if (!LookupServiceLocator.endpointMatchesFilter(object2.getEndpointType(), string3, string4)) continue;
                if (string5 != null && !this._isDevMode) {
                    LookupServiceLocator.applyLocalUrl((ServiceRegistration.Endpoint)object2, string5, string8);
                }
                arrayList.add(new EndpointAtNode((ServiceRegistration.Endpoint)object2, string7, object.getServiceId(), map.get(string7), LookupServiceLocator.extractSsoDomain((ServiceRegistration.Info)object)));
            }
            hashMultimap.putAll((Object)string6, arrayList);
        }
        return hashMultimap.asMap();
    }

    private ServiceRegistration.Info[] searchLookupService(ServiceRegistration.Filter filter) {
        _logger.debug("Searching LS for services with filter: {}", (Object)filter);
        Object[] objectArray = this._lookupService.getServiceRegistrationInfos(filter);
        _logger.debug("LS search finished.");
        if (_logger.isTraceEnabled()) {
            _logger.trace("LS returned results: {}", (Object)Arrays.toString(objectArray));
        }
        return objectArray;
    }

    private static SsoDomain extractSsoDomain(ServiceRegistration.Info info) {
        String string = LookupServiceLocator.getServiceAttribute(info, "domainId");
        if (string == null) {
            return null;
        }
        String string2 = LookupServiceLocator.getServiceAttribute(info, "domainName");
        String string3 = LookupServiceLocator.getServiceAttribute(info, "domainType");
        return new SsoDomain(string, string2, string3);
    }

    private static ServiceRegistration.Filter createSearchFilter(String string, String string2, String string3, String string4) {
        ServiceRegistration.EndpointType endpointType;
        ServiceRegistration.ServiceType serviceType;
        if (string != null && string2 != null) {
            serviceType = new ServiceRegistration.ServiceType();
            serviceType.setProduct(string);
            serviceType.setType(string2);
        } else {
            serviceType = null;
        }
        if (string3 != null || string4 != null) {
            endpointType = new ServiceRegistration.EndpointType();
            endpointType.setType(string3);
            endpointType.setProtocol(string4);
        } else {
            endpointType = null;
        }
        ServiceRegistration.Filter filter = new ServiceRegistration.Filter();
        filter.setServiceType(serviceType);
        filter.setEndpointType(endpointType);
        filter.setSearchAllSsoDomains(Boolean.valueOf(true));
        return filter;
    }

    private static Map<String, Class<?>> extractNodeIdsOfActiveVcServices(Collection<LinkedVcGroup> collection) {
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (LinkedVcGroup linkedVcGroup : collection) {
            Object[] objectArray = linkedVcGroup.getServiceEndPoints();
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            LinkedHashMap<String, Class> linkedHashMap2 = new LinkedHashMap<String, Class>(linkedVcGroup.getVcServices().size());
            for (VcService vcService : linkedVcGroup.getVcServices()) {
                linkedHashMap2.put(vcService.getServiceGuid(), vcService.getVmodlVersion());
            }
            linkedHashMap2.put(linkedVcGroup.getStartUpVcService().getServiceGuid(), linkedVcGroup.getStartUpVcService().getVmodlVersion());
            for (Object object : objectArray) {
                if (!linkedHashMap2.containsKey(object.getInstanceUuid())) continue;
                linkedHashMap.put(object.getLduGuid(), (Class<?>)linkedHashMap2.get(object.getInstanceUuid()));
            }
        }
        return linkedHashMap;
    }

    private static void applyLocalUrl(ServiceRegistration.Endpoint endpoint, String string, String string2) {
        ServiceRegistration.Attribute[] attributeArray;
        if (string2.equals(string) && (attributeArray = endpoint.getEndpointAttributes()) != null) {
            ServiceRegistration.EndpointType endpointType = endpoint.getEndpointType();
            for (ServiceRegistration.Attribute attribute : attributeArray) {
                if (!"cis.common.ep.localurl".equals(attribute.getKey())) continue;
                endpoint.setUrl(URI.create(attribute.getValue()));
                if (!"vapi.json.https".equals(endpointType.getProtocol())) continue;
                endpointType.setProtocol("vapi.json.http");
            }
        }
    }

    private static boolean serviceTypeMatchesFilter(ServiceRegistration.ServiceType serviceType, String string, String string2) {
        return !(string != null && !string.equals(serviceType.getProduct()) || string2 != null && !string2.equals(serviceType.getType()));
    }

    private static boolean endpointMatchesFilter(ServiceRegistration.EndpointType endpointType, String string, String string2) {
        return !(string != null && !string.equals(endpointType.getType()) || string2 != null && !string2.equals(endpointType.getProtocol()));
    }

    private static String makeServiceTypeId(String string, String string2) {
        return string + ":" + string2;
    }

    private static String getServiceAttribute(ServiceRegistration.Info info, String string) {
        assert (info != null);
        assert (string != null);
        ServiceRegistration.Attribute[] attributeArray = info.getServiceAttributes();
        if (attributeArray == null) {
            return null;
        }
        for (ServiceRegistration.Attribute attribute : attributeArray) {
            if (!string.equals(attribute.getKey())) continue;
            return attribute.getValue();
        }
        return null;
    }

    private static boolean isDevMode(ConfigurationService configurationService) {
        String string = configurationService.getProperty(SETTING_DEV_MODE);
        if (string == null || string.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(string);
    }

    private static final class EndpointAtNode {
        public final ServiceRegistration.Endpoint endpoint;
        public final String nodeId;
        public final String serviceId;
        public final Class<?> vmodlVersion;
        public final SsoDomain ssoDomain;

        public EndpointAtNode(ServiceRegistration.Endpoint endpoint, String string, String string2, Class<?> clazz, SsoDomain ssoDomain) {
            this.endpoint = endpoint;
            this.nodeId = string;
            this.serviceId = string2;
            this.vmodlVersion = clazz;
            this.ssoDomain = ssoDomain;
        }
    }
}

