/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MemoizingConnection
implements CoreQueryService {
    private static final Logger _logger = LoggerFactory.getLogger(MemoizingConnection.class);
    private final CoreQueryService _delegate;
    private final ConcurrentMap<Key, ResultSet> _memory;

    public MemoizingConnection(CoreQueryService coreQueryService) {
        this._delegate = coreQueryService;
        this._memory = new ConcurrentHashMap<Key, ResultSet>();
    }

    @Override
    public ResultSet executeQuery(Query query) {
        ResultSet resultSet = (ResultSet)this._memory.get(Key.forQuery(query));
        if (resultSet == null) {
            _logger.trace("Cache miss for query: {}", (Object)query);
            return this.executeAndMemoizeResult(query);
        }
        if (resultSet.getItems().isEmpty()) {
            _logger.trace("Cache hit for query with same constraint; cached result is empty. Query: {}", (Object)query);
            return resultSet;
        }
        return this.tryReturnMemoizedResultSet(query, resultSet);
    }

    @Override
    public QuerySchema getSchema() {
        return this._delegate.getSchema();
    }

    private ResultSet tryReturnMemoizedResultSet(Query query, ResultSet resultSet) {
        assert (!resultSet.getItems().isEmpty());
        List<String> list = MemoizingConnection.minus(query.getProperties(), resultSet.getProperties());
        if (list.isEmpty()) {
            _logger.trace("Cache hit for query: {}", (Object)query);
            return resultSet;
        }
        if (MemoizingConnection.queryTargetsSingleObject(query)) {
            _logger.trace("Partial cache hit for single-object query: {} ; additional properties to retrieve: {}", (Object)query, list);
            return this.queryRemainingPropertiesOnly(query, resultSet, list);
        }
        _logger.trace("Cache miss for query: {}", (Object)query);
        return this._delegate.executeQuery(query);
    }

    private ResultSet queryRemainingPropertiesOnly(Query query, ResultSet resultSet, List<String> list) {
        assert (!resultSet.getItems().isEmpty());
        Query query2 = QueryCopy.copyAndSelect((Query)query, list).build();
        ResultSet resultSet2 = this._delegate.executeQuery(query2);
        if (resultSet2.getItems().isEmpty()) {
            this.memoizeResultForQuery(query, resultSet2);
            return resultSet2;
        }
        ResultSet resultSet3 = MemoizingConnection.concatResults(resultSet, resultSet2);
        this.memoizeResultForQuery(query, resultSet3);
        return resultSet3;
    }

    private ResultSet executeAndMemoizeResult(Query query) {
        ResultSet resultSet = this._delegate.executeQuery(query);
        this.memoizeResultForQuery(query, resultSet);
        return resultSet;
    }

    private void memoizeResultForQuery(Query query, ResultSet resultSet) {
        this._memory.put(Key.forQuery(query), resultSet);
        if (query.getWithTotalCount()) {
            this._memory.put(Key.forQueryWithoutTotalCount(query), resultSet);
        } else if (MemoizingConnection.queryTargetsSingleObject(query)) {
            int n = resultSet.getItems().size();
            ResultSet resultSet2 = ResultSet.Builder.copy((ResultSet)resultSet).totalCount(Integer.valueOf(n)).build();
            this._memory.put(Key.forQueryWithTotalCount(query), resultSet2);
        }
    }

    private static ResultSet concatResults(ResultSet resultSet, ResultSet resultSet2) {
        assert (!resultSet.getItems().isEmpty());
        assert (resultSet.getItems().size() == resultSet2.getItems().size());
        ConcatList concatList = new ConcatList(resultSet.getProperties(), resultSet2.getProperties());
        ResultSet.Builder builder = ResultSet.Builder.properties(concatList);
        for (int i = 0; i < resultSet.getItems().size(); ++i) {
            ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(i);
            ResourceItem resourceItem2 = (ResourceItem)resultSet2.getItems().get(i);
            ConcatList concatList2 = new ConcatList(resourceItem.getPropertyValues(), resourceItem2.getPropertyValues());
            builder.item(resourceItem.getKey(), concatList2);
        }
        return builder.totalCount(resultSet.getTotalCount()).build();
    }

    private static boolean queryTargetsSingleObject(Query query) {
        return query.getFilter() != null && query.getLimit() != 0 && query.getFilter().getCriteria().size() == 1 && MemoizingConnection.predicateDefinesSingleObject((PropertyPredicate)query.getFilter().getCriteria().get(0));
    }

    private static boolean predicateDefinesSingleObject(PropertyPredicate propertyPredicate) {
        PropertyPredicate.ComparisonOperator comparisonOperator = propertyPredicate.getOperator();
        Object object = propertyPredicate.getComparableValue();
        return PropertyUtil.isModelKey((String)propertyPredicate.getProperty()) && (comparisonOperator == PropertyPredicate.ComparisonOperator.EQUAL || comparisonOperator == PropertyPredicate.ComparisonOperator.IN) && MemoizingConnection.cardinalityOf(object) == 1;
    }

    private static int cardinalityOf(Object object) {
        return object instanceof Collection ? ((Collection)object).size() : 1;
    }

    private static List<String> minus(List<String> list, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        arrayList.removeAll(list2);
        return arrayList;
    }

    private static final class ConcatList<T>
    extends AbstractList<T> {
        private final Collection<List<? extends T>> _children;
        private final int _size;

        @SafeVarargs
        public ConcatList(List<? extends T> ... listArray) {
            this._children = Arrays.asList(listArray);
            this._size = this.sumSizes(this._children);
        }

        @Override
        public T get(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            int n2 = n;
            for (List<T> list : this._children) {
                if (n2 < list.size()) {
                    return list.get(n2);
                }
                n2 -= list.size();
            }
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }

        @Override
        public int size() {
            return this._size;
        }

        private int sumSizes(Collection<List<? extends T>> collection) {
            int n = 0;
            for (List<T> list : collection) {
                n += list.size();
            }
            return n;
        }
    }

    private static final class Key {
        private final Filter filter;
        private final List<SortCriterion> sortCriteria;
        private final Collection<String> resourceModels;
        private final int offset;
        private final int limit;
        private final boolean withTotalCount;
        private final int computedHashCode;

        public static Key forQuery(Query query) {
            return new Key(query.getFilter(), query.getSortCriteria(), query.getResourceModels(), query.getOffset(), query.getLimit(), query.getWithTotalCount());
        }

        public static Key forQueryWithoutTotalCount(Query query) {
            return new Key(query.getFilter(), query.getSortCriteria(), query.getResourceModels(), query.getOffset(), query.getLimit(), false);
        }

        public static Key forQueryWithTotalCount(Query query) {
            return new Key(query.getFilter(), query.getSortCriteria(), query.getResourceModels(), query.getOffset(), query.getLimit(), true);
        }

        private Key(Filter filter, List<SortCriterion> list, Collection<String> collection, int n, int n2, boolean bl) {
            this.filter = filter;
            this.sortCriteria = list;
            this.resourceModels = collection;
            this.offset = n;
            this.limit = n2;
            this.withTotalCount = bl;
            this.computedHashCode = this.computeHashCode();
        }

        public boolean equals(Object object) {
            boolean bl;
            if (object instanceof Key) {
                Key key = (Key)object;
                bl = ObjectUtils.equals((Object)this.filter, (Object)key.filter) && this.sortCriteria.equals(key.sortCriteria) && this.resourceModels.equals(key.resourceModels) && this.offset == key.offset && this.limit == key.limit && this.withTotalCount == key.withTotalCount;
            } else {
                bl = false;
            }
            return bl;
        }

        public int hashCode() {
            return this.computedHashCode;
        }

        private int computeHashCode() {
            return new HashCodeBuilder(37, 41).append((Object)this.filter).append(this.sortCriteria).append(this.resourceModels).append(this.offset).append(this.limit).append(this.withTotalCount).toHashCode();
        }
    }
}

