/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.internal.adapters.federation.IdentifiableServiceInstance;
import com.vmware.cis.data.internal.adapters.lookup.ServiceLocator;
import com.vmware.cis.data.internal.adapters.util.vapi.VapiProtocolConnectionFactory;
import com.vmware.cis.data.internal.adapters.vapi.VapiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.adapters.vcenter.VcenterDataProviders;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiAuthenticatorFactory;
import com.vmware.cis.data.internal.adapters.vmomi.VmomiDataProviderConfig;
import com.vmware.cis.data.internal.adapters.vmomi.impl.HttpConfigurationFactory;
import com.vmware.cis.data.internal.adapters.vmomi.util.VmomiVersion;
import com.vmware.cis.data.internal.provider.CompositeDataProviderConnection;
import com.vmware.cis.data.internal.provider.MultiSsoDomainAuthenticationTokenSource;
import com.vmware.cis.data.internal.provider.ProviderBySchemaLookup;
import com.vmware.cis.data.internal.provider.ProviderRepository;
import com.vmware.cis.data.internal.provider.QueryDispatcher;
import com.vmware.cis.data.internal.provider.QueryQualifyingConnection;
import com.vmware.cis.data.internal.provider.ext.search.QuickSearchDataProvider;
import com.vmware.cis.data.internal.provider.profiler.DataProviderProfilerFactory;
import com.vmware.cis.data.internal.provider.profiler.OperationThresholdConfig;
import com.vmware.cis.data.internal.provider.profiler.ProfiledDataProvider;
import com.vmware.cis.data.internal.provider.schema.QuerySchemaCache;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cis.data.provider.registry.DataProviderLookup;
import com.vmware.cis.data.provider.registry.QueryModelLookup;
import com.vmware.cis.data.provider.registry.VcenterDataProviderFactoryLookup;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.data.adapters.core.LinkedVcGroupRegistryBasedVmomiAuthenticatorFactory;
import com.vmware.vise.data.adapters.core.QueryServiceConnection;
import com.vmware.vise.data.adapters.core.SessionTokenSource;
import com.vmware.vise.data.adapters.core.ViseVapiPropertyValueConverter;
import com.vmware.vise.data.adapters.core.VmodlContextLoader;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import com.vmware.vise.vim.security.sso.SsoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

final class QueryServiceConnectionFactory {
    QueryServiceConnectionFactory() {
    }

    static QueryServiceConnection getConnection(ServiceLocator serviceLocator, Map<String, IdentifiableServiceInstance> map, ExecutorService executorService, ResourceModelTypeProvider resourceModelTypeProvider, HttpConfigurationFactory httpConfigurationFactory, VapiProtocolConnectionFactory vapiProtocolConnectionFactory, DataProviderLookup dataProviderLookup, VcenterDataProviderFactoryLookup vcenterDataProviderFactoryLookup, QueryModelLookup queryModelLookup, QuerySchemaCache querySchemaCache, SsoService ssoService, VmomiVersion vmomiVersion, String string, long l, long l2, long l3) {
        VmodlContext vmodlContext = VmodlContextLoader.getContext();
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistryByClientId((String)string);
        LinkedVcGroupRegistryBasedVmomiAuthenticatorFactory linkedVcGroupRegistryBasedVmomiAuthenticatorFactory = new LinkedVcGroupRegistryBasedVmomiAuthenticatorFactory(linkedVcGroupRegistry);
        Collection collection = queryModelLookup.getRegisteredQueryModels();
        VmomiDataProviderConfig vmomiDataProviderConfig = VmomiDataProviderConfig.Builder.create().withVmodlContext(vmodlContext).withHttpConfigurationFactory(httpConfigurationFactory).withAuthenticatorFactory((VmomiAuthenticatorFactory)linkedVcGroupRegistryBasedVmomiAuthenticatorFactory).withVmomiVersion(vmomiVersion).build();
        VapiDataProviderConfig vapiDataProviderConfig = VapiDataProviderConfig.Builder.create().withPropertyValueConverter((VapiPropertyValueConverter)new ViseVapiPropertyValueConverter(resourceModelTypeProvider)).withVapiConnectionFactory(vapiProtocolConnectionFactory).withExtendedModels(QueryServiceConnectionFactory.getVapiModels(collection)).build();
        OperationThresholdConfig operationThresholdConfig = OperationThresholdConfig.Builder.create().withProviderLoginThreshold(l).withProviderLogoutThreshold(l2).withProviderOperationThreshold(l3).build();
        SessionTokenSource sessionTokenSource = new SessionTokenSource(ssoService, string);
        CompositeDataProviderConnection compositeDataProviderConnection = VcenterDataProviders.fromLocator((ServiceLocator)serviceLocator, (MultiSsoDomainAuthenticationTokenSource)sessionTokenSource).withVpxdInstanceIdByNodeMap(map).withVmomiDataProviderConfig(vmomiDataProviderConfig).withProviderFactories(vcenterDataProviderFactoryLookup.get()).withVapiDataProviderConfig(vapiDataProviderConfig).withProviderOperationThreshold(operationThresholdConfig).withQuerySchemaCache(querySchemaCache).withExecutor(executorService).withLocalSsoDomain(QueryServiceConnectionFactory.getLocalSsoDomain()).connect();
        ArrayList<DataProvider> arrayList = new ArrayList<DataProvider>();
        arrayList.addAll(compositeDataProviderConnection.getDataProviders());
        arrayList.addAll(QueryServiceConnectionFactory.profileProviders(dataProviderLookup.getProviders(), l3));
        ProviderBySchemaLookup providerBySchemaLookup = ProviderRepository.forProviders(arrayList);
        QueryQualifyingConnection queryQualifyingConnection = new QueryQualifyingConnection(ProfiledDataProvider.create((DataProvider)new QuickSearchDataProvider((DataProvider)new QueryDispatcher(providerBySchemaLookup, executorService), executorService)));
        QueryService queryService = QueryService.Builder.forProvider((DataProvider)queryQualifyingConnection).withExecutor(executorService).build();
        return new QueryServiceConnection(queryService, (AutoCloseable)compositeDataProviderConnection);
    }

    private static Collection<Class<?>> getVapiModels(Collection<Class<?>> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        for (Class<?> clazz : collection) {
            String string = QueryServiceConnectionFactory.getQueryModelName(clazz);
            if (!ModelUtils.isVmodl2Name((String)string)) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private static String getQueryModelName(Class<?> clazz) {
        QueryModel queryModel = clazz.getAnnotation(QueryModel.class);
        assert (queryModel != null);
        return queryModel.value();
    }

    private static List<DataProvider> profileProviders(Collection<DataProvider> collection, long l) {
        ArrayList<DataProvider> arrayList = new ArrayList<DataProvider>(collection.size());
        for (DataProvider dataProvider : collection) {
            arrayList.add(DataProviderProfilerFactory.profileProvider((DataProvider)dataProvider, (long)l));
        }
        return arrayList;
    }

    private static com.vmware.cis.data.internal.provider.SsoDomain getLocalSsoDomain() {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        return new com.vmware.cis.data.internal.provider.SsoDomain(ssoDomain.getId(), ssoDomain.getName(), ssoDomain.getType());
    }
}

