/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.adapters.core.mixfed.MixedFederationInventoryServiceTracker;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.impl.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

final class QuickSearchDynamicProviderAdapter
implements DynamicProviderAdapter {
    private static final String VM = "VirtualMachine";
    private static final String MOR_TYPE_CATEGORY = "InventoryServiceCategory";
    private static final String MOR_TYPE_TAG = "InventoryServiceTag";
    private static final String TYPE_CATEGORY = "inventoryservice:InventoryServiceCategory";
    private static final String TYPE_TAG = "inventoryservice:InventoryServiceTag";
    private static final String GUEST_IP_ADDRESS = "guest.ipAddress";
    private static final String NAME = "name";
    private static final Collection<String> QUICK_SEARCH_CHILD_TYPES = Arrays.asList("ClusterComputeResource", "Datacenter", "Datastore", "DistributedVirtualPortgroup", "DistributedVirtualSwitch", "Folder", "HostSystem", "Network", "OpaqueNetwork", "ResourcePool", "StoragePod", "VirtualMachine", "inventoryservice:InventoryServiceCategory", "inventoryservice:InventoryServiceTag", "com.vmware.content.library.Item", "com.vmware.content.Library");
    private static final PropertyConstraint isSystemFolder = new PropertyConstraint();
    private static final PropertyConstraint isRootResourcePool;
    private final DynamicProviderAdapter _dpa;
    private final MixedFederationInventoryServiceTracker _invSvcTracker;

    QuickSearchDynamicProviderAdapter(DynamicProviderAdapter dynamicProviderAdapter, MixedFederationInventoryServiceTracker mixedFederationInventoryServiceTracker) {
        assert (dynamicProviderAdapter != null);
        assert (mixedFederationInventoryServiceTracker != null);
        this._dpa = dynamicProviderAdapter;
        this._invSvcTracker = mixedFederationInventoryServiceTracker;
    }

    public Response getData(RequestSpec requestSpec) throws Exception {
        assert (requestSpec != null);
        if (!QuickSearchDynamicProviderAdapter.containsQuickSearchQuery(requestSpec)) {
            return this._dpa.getData(requestSpec);
        }
        RequestSpec requestSpec2 = this.toExecutable(requestSpec);
        Response response = this._dpa.getData(requestSpec2);
        QuickSearchDynamicProviderAdapter.sortQuickSearchResultsByChildType(response, requestSpec);
        return response;
    }

    public String toString() {
        return this._dpa.toString();
    }

    private static boolean containsQuickSearchQuery(RequestSpec requestSpec) {
        assert (requestSpec != null);
        assert (requestSpec.querySpec != null);
        for (QuerySpec querySpec : requestSpec.querySpec) {
            if (!QuickSearchDynamicProviderAdapter.isQuickSearchQuery(querySpec)) continue;
            return true;
        }
        return false;
    }

    private static boolean isQuickSearchQuery(QuerySpec querySpec) {
        assert (querySpec != null);
        return "QuickSearch".equals(querySpec.resourceSpec.constraint.targetType);
    }

    private RequestSpec toExecutable(RequestSpec requestSpec) {
        assert (requestSpec != null);
        QuerySpec[] querySpecArray = new QuerySpec[requestSpec.querySpec.length];
        for (int i = 0; i < requestSpec.querySpec.length; ++i) {
            QuerySpec querySpec;
            querySpecArray[i] = querySpec = this.toExecutable(requestSpec.querySpec[i]);
        }
        RequestSpec requestSpec2 = new RequestSpec();
        requestSpec2.querySpec = querySpecArray;
        requestSpec2.enableProfiling = requestSpec.enableProfiling;
        return requestSpec2;
    }

    private QuerySpec toExecutable(QuerySpec querySpec) {
        assert (querySpec != null);
        if (!QuickSearchDynamicProviderAdapter.isQuickSearchQuery(querySpec)) {
            return querySpec;
        }
        QuickSearchDynamicProviderAdapter.validateQuickSearchQuery(querySpec);
        String string = QuickSearchDynamicProviderAdapter.getSearchTerm(querySpec);
        Collection<String> collection = QuickSearchDynamicProviderAdapter.getSelect(querySpec);
        int n = querySpec.resultSpec.maxResultCount;
        QuerySpec querySpec2 = this.toQuickSearchQuery(string, collection, n, querySpec.name);
        return querySpec2;
    }

    private static void validateQuickSearchQuery(QuerySpec querySpec) {
        assert (querySpec != null);
        assert (querySpec.resourceSpec != null);
        assert (querySpec.resultSpec != null);
        if (!(querySpec.resourceSpec.constraint instanceof PropertyConstraint)) {
            throw new UnsupportedOperationException("Unexpected constraint in quick search query: " + querySpec.resourceSpec.constraint);
        }
        PropertyConstraint propertyConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint;
        if (!"searchTerm".equals(propertyConstraint.propertyName)) {
            throw new UnsupportedOperationException("Cannot filter quick search by property " + propertyConstraint.propertyName);
        }
        if (!(propertyConstraint.comparableValue instanceof String)) {
            throw new UnsupportedOperationException("Cannot filter quick search by value of class " + propertyConstraint.comparableValue.getClass().getCanonicalName());
        }
        if (querySpec.resourceSpec.propertySpecs == null) {
            throw new UnsupportedOperationException("Missing PropertySpec in quick search query");
        }
        if (querySpec.resourceSpec.propertySpecs.length > 1) {
            throw new UnsupportedOperationException("Multiple PropertySpecs for quick search");
        }
        if (querySpec.resultSpec.maxResultCount == null) {
            throw new UnsupportedOperationException("Limit is required for quick search query");
        }
        if (querySpec.resultSpec.maxResultCount <= 0) {
            throw new UnsupportedOperationException("Limit must be positive for quick search query: " + querySpec.resultSpec.maxResultCount);
        }
    }

    private static String getSearchTerm(QuerySpec querySpec) {
        assert (querySpec.resourceSpec.constraint instanceof PropertyConstraint);
        PropertyConstraint propertyConstraint = (PropertyConstraint)querySpec.resourceSpec.constraint;
        assert (propertyConstraint.comparableValue instanceof String);
        return (String)propertyConstraint.comparableValue;
    }

    private static Collection<String> getSelect(QuerySpec querySpec) {
        assert (querySpec != null);
        assert (querySpec.resourceSpec.propertySpecs != null);
        assert (querySpec.resourceSpec.propertySpecs.length <= 1);
        if (querySpec.resourceSpec.propertySpecs.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(querySpec.resourceSpec.propertySpecs[0].propertyNames);
    }

    private QuerySpec toQuickSearchQuery(String string, Collection<String> collection, int n, String string2) {
        assert (string != null);
        assert (collection != null);
        assert (n > 0);
        boolean bl = !this._invSvcTracker.onlyInvSvcNodes();
        ArrayList<Constraint> arrayList = new ArrayList<Constraint>(QUICK_SEARCH_CHILD_TYPES.size() + 1);
        for (String object2 : QUICK_SEARCH_CHILD_TYPES) {
            if (QuickSearchDynamicProviderAdapter.isTaggingType(object2) && bl) continue;
            arrayList.add((Constraint)QuickSearchDynamicProviderAdapter.constraintOnName(object2, string));
        }
        arrayList.add((Constraint)QuickSearchDynamicProviderAdapter.constraintOnVmIp(string));
        ArrayList arrayList2 = new ArrayList(QUICK_SEARCH_CHILD_TYPES.size());
        for (String string3 : QUICK_SEARCH_CHILD_TYPES) {
            if (QuickSearchDynamicProviderAdapter.isTaggingType(string3) && bl) continue;
            arrayList2.add(QuickSearchDynamicProviderAdapter.propertySpec(string3, collection));
        }
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = string2;
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.constraint = QuickSearchDynamicProviderAdapter.except(new Constraint[]{QuickSearchDynamicProviderAdapter.or(arrayList), QuickSearchDynamicProviderAdapter.or(new Constraint[]{isSystemFolder, isRootResourcePool})});
        querySpec.resourceSpec.propertySpecs = arrayList2.toArray(new PropertySpec[arrayList2.size()]);
        querySpec.resultSpec = new ResultSpec();
        querySpec.resultSpec.maxResultCount = n;
        querySpec.resultSpec.order = Utils.DEFAULT_ORDERING_CRITERIA;
        return querySpec;
    }

    private static PropertyConstraint constraintOnName(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = string;
        propertyConstraint.propertyName = NAME;
        propertyConstraint.comparator = Comparator.CONTAINS;
        propertyConstraint.comparableValue = string2;
        return propertyConstraint;
    }

    private static PropertyConstraint constraintOnVmIp(String string) {
        assert (string != null);
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = VM;
        propertyConstraint.propertyName = GUEST_IP_ADDRESS;
        propertyConstraint.comparator = Comparator.CONTAINS;
        propertyConstraint.comparableValue = string;
        return propertyConstraint;
    }

    private static CompositeConstraint or(Collection<Constraint> collection) {
        assert (collection != null);
        assert (!collection.isEmpty());
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.nestedConstraints = collection.toArray(new Constraint[collection.size()]);
        return compositeConstraint;
    }

    private static CompositeConstraint or(Constraint ... constraintArray) {
        assert (constraintArray != null);
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        compositeConstraint.targetType = null;
        compositeConstraint.nestedConstraints = constraintArray;
        return compositeConstraint;
    }

    private static CompositeConstraint except(Constraint ... constraintArray) {
        assert (constraintArray != null);
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.EXCEPT;
        compositeConstraint.targetType = null;
        compositeConstraint.nestedConstraints = constraintArray;
        return compositeConstraint;
    }

    private static PropertySpec propertySpec(String string, Collection<String> collection) {
        assert (string != null);
        assert (collection != null);
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string2 : collection) {
            String string3 = QuickSearchDynamicProviderAdapter.toPropertyForType(string, string2);
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = string;
        propertySpec.propertyNames = arrayList.toArray(new String[arrayList.size()]);
        return propertySpec;
    }

    private static String toPropertyForType(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        if (NAME.equals(string2)) {
            return string2;
        }
        if (!VM.equals(string)) {
            return null;
        }
        return string2;
    }

    private static boolean isTaggingType(String string) {
        return TYPE_CATEGORY.equals(string) || TYPE_TAG.equals(string);
    }

    private static void sortQuickSearchResultsByChildType(Response response, RequestSpec requestSpec) {
        assert (response != null);
        assert (requestSpec != null);
        assert (response.resultSet.length == requestSpec.querySpec.length);
        for (int i = 0; i < requestSpec.querySpec.length; ++i) {
            ResultSet resultSet = response.resultSet[i];
            QuerySpec querySpec = requestSpec.querySpec[i];
            if (!QuickSearchDynamicProviderAdapter.isQuickSearchQuery(querySpec)) continue;
            ResultItem[] resultItemArray = QuickSearchDynamicProviderAdapter.sortByChildType(resultSet.items);
            resultSet.items = resultItemArray;
        }
    }

    private static ResultItem[] sortByChildType(ResultItem[] resultItemArray) {
        assert (resultItemArray != null);
        ResultItem[] resultItemArray2 = new ResultItem[resultItemArray.length];
        int n = 0;
        for (int i = 1; i <= 3; ++i) {
            for (int j = 0; j < resultItemArray.length; ++j) {
                ResultItem resultItem = resultItemArray[j];
                if (i != QuickSearchDynamicProviderAdapter.getPriority(resultItem.resourceObject)) continue;
                resultItemArray2[n++] = resultItem;
            }
        }
        assert (n == resultItemArray.length);
        return resultItemArray2;
    }

    private static int getPriority(Object object) {
        assert (object != null);
        if (!(object instanceof ManagedObjectReference)) {
            return 3;
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
        if (MOR_TYPE_TAG.equals(managedObjectReference.getType()) || MOR_TYPE_CATEGORY.equals(managedObjectReference.getType())) {
            return 2;
        }
        return 1;
    }

    static {
        QuickSearchDynamicProviderAdapter.isSystemFolder.targetType = "Folder";
        QuickSearchDynamicProviderAdapter.isSystemFolder.propertyName = "isSystemFolder";
        QuickSearchDynamicProviderAdapter.isSystemFolder.comparator = Comparator.EQUALS;
        QuickSearchDynamicProviderAdapter.isSystemFolder.comparableValue = true;
        isRootResourcePool = new PropertyConstraint();
        QuickSearchDynamicProviderAdapter.isRootResourcePool.targetType = "ResourcePool";
        QuickSearchDynamicProviderAdapter.isRootResourcePool.propertyName = "isRootRP";
        QuickSearchDynamicProviderAdapter.isRootResourcePool.comparator = Comparator.EQUALS;
        QuickSearchDynamicProviderAdapter.isRootResourcePool.comparableValue = true;
    }
}

