/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core;

import com.vmware.cis.data.internal.adapters.vapi.VapiPropertyValueConverter;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vapi.bindings.ApiEnumeration;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverterImpl;
import com.vmware.vapi.internal.bindings.convert.ConverterFactory;
import com.vmware.vapi.internal.bindings.convert.NameToTypeResolver;
import com.vmware.vapi.internal.bindings.convert.impl.DefaultConverterFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.data.adapters.core.VapiPropertyTypeResolver;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.search.vapi.Vmodl2PropertyUnmarshaller;
import com.vmware.vise.vim.commons.vapi.ResourceModelTypeProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;

final class ViseVapiPropertyValueConverter
implements VapiPropertyValueConverter {
    private static final ResourceModelTypeProvider _vapiBuiltinTypes = new Vmodl2PropertyUnmarshaller.VapiBuiltinTypesProvider();
    private final ResourceModelTypeProvider _vapiTypeProvider;
    private final TypeConverter _vapiTypeConverter;

    ViseVapiPropertyValueConverter(ResourceModelTypeProvider resourceModelTypeProvider) {
        Validate.notNull((Object)resourceModelTypeProvider);
        this._vapiTypeProvider = resourceModelTypeProvider;
        this._vapiTypeConverter = new TypeConverterImpl((ConverterFactory)new DefaultConverterFactory(new NameToTypeResolver(){

            public Type resolve(String string) {
                StructType structType = ViseVapiPropertyValueConverter.this._vapiTypeProvider.getResourceModelType(string);
                if (structType != null) {
                    return structType;
                }
                return _vapiBuiltinTypes.getResourceModelType(string);
            }
        }));
    }

    public Object fromVapiResultDataValue(String string, DataValue dataValue, DataValue dataValue2) {
        assert (string != null);
        ViseVapiPropertyValueConverter.validateResourceType(dataValue, string);
        if (dataValue2 == null) {
            return null;
        }
        if (PropertyUtil.isModelKey((String)string)) {
            ViseVapiPropertyValueConverter.validateStringValue(dataValue2, string);
            return VapiUriSchemeUtil.createUri((String)((StringValue)dataValue).getValue(), (String)((StringValue)dataValue2).getValue());
        }
        Type type = this.fixOptionals(this.getVapiTypeOfProperty(string), dataValue2);
        if (this.isKey(type)) {
            ViseVapiPropertyValueConverter.validateStringValue(dataValue2, string);
            String string2 = ((IdType)type).getResourceType();
            String string3 = ((StringValue)dataValue2).getValue();
            if (ViseVapiPropertyValueConverter.isVmodl1(string2)) {
                return CisIdConverter.fromGlobalCisId((String)string3, (String)string2);
            }
            return VapiUriSchemeUtil.createUri((String)string2, (String)string3);
        }
        if (type == null && dataValue2 instanceof StructValue) {
            StructValue structValue = (StructValue)dataValue2;
            type = this._vapiTypeProvider.getResourceModelType(structValue.getName());
        }
        if (type != null) {
            return this.toBinding(dataValue2, type, string);
        }
        return this.fromUntypedDataValue(dataValue2);
    }

    private static boolean isVmodl1(String string) {
        return string.indexOf(46) == -1;
    }

    private static void validateResourceType(DataValue dataValue, String string) {
        if (dataValue == null) {
            throw new IllegalArgumentException("The resourceType of " + string + " property must not be null!");
        }
        if (!(dataValue instanceof StringValue)) {
            throw new IllegalArgumentException(String.format("Resource type of property '%s' must be a StringValue and not %s: %s", string, dataValue.getClass().getCanonicalName(), dataValue));
        }
    }

    private static void validateStringValue(DataValue dataValue, String string) {
        if (!(dataValue instanceof StringValue)) {
            throw new IllegalArgumentException(String.format("Property '%s' must be a StringValue and not %s: %s", string, dataValue.getClass().getCanonicalName(), dataValue));
        }
    }

    private boolean isKey(Type type) {
        return type instanceof IdType;
    }

    public DataValue toVapiComparableValue(String string, Object object) {
        assert (string != null);
        assert (object != null);
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return new IntegerValue(n.longValue());
        }
        if (object instanceof Long) {
            return new IntegerValue(((Long)object).longValue());
        }
        if (object instanceof Boolean) {
            return BooleanValue.getInstance((boolean)((Boolean)object));
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return new DoubleValue(f.doubleValue());
        }
        if (object instanceof Double) {
            return new DoubleValue(((Double)object).doubleValue());
        }
        if (object instanceof ApiEnumeration) {
            return new StringValue(((ApiEnumeration)object).name());
        }
        if (object instanceof ManagedObjectReference) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            return new StringValue(CisIdConverter.toGlobalCisId((ManagedObjectReference)managedObjectReference, (String)managedObjectReference.getServerGuid()));
        }
        if (object instanceof URI && VapiUriSchemeUtil.isVapiUri((URI)((URI)object))) {
            URI uRI = (URI)object;
            String string2 = VapiUriSchemeUtil.getId((URI)uRI);
            return new StringValue(string2);
        }
        throw new IllegalArgumentException(String.format("Unsupported comparable value of type %s: %s", object.getClass().getCanonicalName(), object));
    }

    public List<DataValue> toVapiComparableList(String string, Collection<?> collection) {
        assert (string != null);
        assert (collection != null);
        ArrayList<DataValue> arrayList = new ArrayList<DataValue>(collection.size());
        for (Object obj : collection) {
            arrayList.add(this.toVapiComparableValue(string, obj));
        }
        return arrayList;
    }

    public boolean isTypeRequired() {
        return true;
    }

    private Type fixOptionals(Type type, DataValue dataValue) {
        if (type == null) {
            return null;
        }
        if (type instanceof OptionalType && !(dataValue instanceof OptionalValue)) {
            return ((OptionalType)type).getElementType();
        }
        return type;
    }

    private Object toBinding(DataValue dataValue, Type type, String string) {
        try {
            return this._vapiTypeConverter.convertToJava(dataValue, type);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException("Could not convert value of property " + string, runtimeException);
        }
    }

    private Object fromUntypedDataValue(DataValue dataValue) {
        if (dataValue instanceof StringValue) {
            return ((StringValue)dataValue).getValue();
        }
        if (dataValue instanceof IntegerValue) {
            return ((IntegerValue)dataValue).getValue();
        }
        if (dataValue instanceof BooleanValue) {
            return ((BooleanValue)dataValue).getValue();
        }
        if (dataValue instanceof SecretValue) {
            return ((SecretValue)dataValue).getValue();
        }
        if (dataValue instanceof DoubleValue) {
            return ((DoubleValue)dataValue).getValue();
        }
        if (dataValue instanceof BlobValue) {
            return ((BlobValue)dataValue).getValue();
        }
        return dataValue;
    }

    private Type getVapiTypeOfProperty(String string) {
        assert (string != null);
        if (PropertyUtil.isSpecialProperty((String)string)) {
            return null;
        }
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)string);
        String string2 = ViseVapiPropertyValueConverter.toCanonicalName(qualifiedProperty.getResourceModel());
        StructType structType = this._vapiTypeProvider.getResourceModelType(string2);
        if (structType == null) {
            return null;
        }
        Type type = VapiPropertyTypeResolver.resolvePropertyType(structType, qualifiedProperty.getSimpleProperty());
        return type;
    }

    private static String toCanonicalName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = '\u0000';
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isUpperCase(c2)) {
                if (Character.isLowerCase(c)) {
                    stringBuilder.append('_');
                }
                stringBuilder.append(Character.toLowerCase(c2));
            } else {
                stringBuilder.append(c2);
            }
            c = c2;
        }
        return stringBuilder.toString();
    }
}

