/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.alien;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.internal.adapters.vmomi.util.VmomiProperty;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class VcGuidFilterAnalyzer {
    private static final Set<PropertyPredicate.ComparisonOperator> EQUALITY_OPERATORS = EnumSet.of(PropertyPredicate.ComparisonOperator.EQUAL, PropertyPredicate.ComparisonOperator.IN);
    private static final char VC_GUID_DELIMITER = ':';
    private static final String PROPERTY_INSTANCE_UUID = "@instanceUuid";

    VcGuidFilterAnalyzer() {
    }

    static Set<String> getVcGuidsForFilter(Filter filter) {
        if (filter == null) {
            return null;
        }
        if (filter.getCriteria().size() == 1) {
            return VcGuidFilterAnalyzer.getVcGuidsForPredicate((PropertyPredicate)filter.getCriteria().get(0));
        }
        switch (filter.getOperator()) {
            case AND: {
                return VcGuidFilterAnalyzer.getVcGuidsForConjunction(filter.getCriteria());
            }
            case OR: {
                return VcGuidFilterAnalyzer.getVcGuidsForDisjunction(filter.getCriteria());
            }
        }
        throw new IllegalStateException("Unsupported logical operator " + filter.getOperator().name());
    }

    private static Set<String> getVcGuidsForConjunction(List<PropertyPredicate> list) {
        Iterator<PropertyPredicate> iterator = list.iterator();
        assert (iterator.hasNext());
        LinkedHashSet<String> linkedHashSet = null;
        while (iterator.hasNext()) {
            Set<String> set = VcGuidFilterAnalyzer.getVcGuidsForPredicate(iterator.next());
            if (set == null) continue;
            if (linkedHashSet != null) {
                linkedHashSet.retainAll(set);
                continue;
            }
            linkedHashSet = new LinkedHashSet<String>(set);
        }
        return linkedHashSet;
    }

    private static Set<String> getVcGuidsForDisjunction(List<PropertyPredicate> list) {
        assert (!list.isEmpty());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (PropertyPredicate propertyPredicate : list) {
            Set<String> set = VcGuidFilterAnalyzer.getVcGuidsForPredicate(propertyPredicate);
            if (set == null) {
                return null;
            }
            linkedHashSet.addAll(set);
        }
        return linkedHashSet;
    }

    private static Set<String> getVcGuidsForPredicate(PropertyPredicate propertyPredicate) {
        if (VcGuidFilterAnalyzer.isInstanceUuid(propertyPredicate)) {
            return VcGuidFilterAnalyzer.getVcGuidsForInstanceUuidPredicate(propertyPredicate);
        }
        if (VcGuidFilterAnalyzer.isModelKey(propertyPredicate)) {
            return VcGuidFilterAnalyzer.getVcGuidsForComparableValues(propertyPredicate);
        }
        if (VcGuidFilterAnalyzer.isMoIdForeignKey(propertyPredicate)) {
            return VcGuidFilterAnalyzer.getVcGuidsForMoIdForeignKeyPredicate(propertyPredicate);
        }
        if (VcGuidFilterAnalyzer.isEquality(propertyPredicate)) {
            return VcGuidFilterAnalyzer.getVcGuidsForComparableValues(propertyPredicate);
        }
        return null;
    }

    private static boolean isEquality(PropertyPredicate propertyPredicate) {
        return EQUALITY_OPERATORS.contains(propertyPredicate.getOperator());
    }

    private static boolean isInstanceUuid(PropertyPredicate propertyPredicate) {
        String string = propertyPredicate.getProperty();
        if (!string.endsWith(PROPERTY_INSTANCE_UUID)) {
            return false;
        }
        return PROPERTY_INSTANCE_UUID.equals(QualifiedProperty.forQualifiedName((String)string).getSimpleProperty());
    }

    private static boolean isModelKey(PropertyPredicate propertyPredicate) {
        return "@modelKey".equals(propertyPredicate.getProperty());
    }

    private static boolean isMoIdForeignKey(PropertyPredicate propertyPredicate) {
        return VmomiProperty.isForeignKey((String)propertyPredicate.getProperty());
    }

    private static Set<String> getVcGuidsForInstanceUuidPredicate(PropertyPredicate propertyPredicate) {
        PropertyPredicate.ComparisonOperator comparisonOperator = propertyPredicate.getOperator();
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)comparisonOperator)) {
            String string = (String)propertyPredicate.getComparableValue();
            return Collections.singleton(string);
        }
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)comparisonOperator)) {
            Collection collection = (Collection)propertyPredicate.getComparableValue();
            return VcGuidFilterAnalyzer.asSet(collection);
        }
        return null;
    }

    private static Set<String> getVcGuidsForMoIdForeignKeyPredicate(PropertyPredicate propertyPredicate) {
        PropertyPredicate.ComparisonOperator comparisonOperator = propertyPredicate.getOperator();
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)comparisonOperator)) {
            String string = (String)propertyPredicate.getComparableValue();
            String string2 = VcGuidFilterAnalyzer.getVcGuidForMoIdForeignKey(string);
            if (string2 == null) {
                return null;
            }
            return Collections.singleton(string2);
        }
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)comparisonOperator)) {
            Collection collection = (Collection)propertyPredicate.getComparableValue();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(collection.size());
            for (String string : collection) {
                String string3 = VcGuidFilterAnalyzer.getVcGuidForMoIdForeignKey(string);
                if (string3 == null) {
                    return null;
                }
                linkedHashSet.add(string3);
            }
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return null;
    }

    private static String getVcGuidForMoIdForeignKey(String string) {
        int n = string.lastIndexOf(58);
        if (n > 0 && n + 1 < string.length()) {
            return string.substring(n + 1);
        }
        return null;
    }

    private static Set<String> getVcGuidsForComparableValues(PropertyPredicate propertyPredicate) {
        PropertyPredicate.ComparisonOperator comparisonOperator = propertyPredicate.getOperator();
        if (PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)comparisonOperator)) {
            String string = VcGuidFilterAnalyzer.getVcGuidForComparableValue(propertyPredicate.getComparableValue());
            if (string == null) {
                return null;
            }
            return Collections.singleton(string);
        }
        if (PropertyPredicate.ComparisonOperator.IN.equals((Object)comparisonOperator)) {
            Collection collection = (Collection)propertyPredicate.getComparableValue();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(collection.size());
            for (Object e : collection) {
                String string = VcGuidFilterAnalyzer.getVcGuidForComparableValue(e);
                if (string == null) {
                    return null;
                }
                linkedHashSet.add(string);
            }
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return null;
    }

    private static String getVcGuidForComparableValue(Object object) {
        if (object instanceof ManagedObjectReference) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            return managedObjectReference.getServerGuid();
        }
        return null;
    }

    private static <T> Set<T> asSet(Collection<T> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return Collections.unmodifiableSet(new LinkedHashSet<T>(collection));
    }
}

