/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.tagging;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.vapi.std.DynamicID;
import com.vmware.vim.binding.dataservice.tagging.Tag;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.tagging.FixedValueTranslator;
import com.vmware.vise.data.adapters.core.tagging.InventoryServiceTaggingIdConverter;
import com.vmware.vise.data.adapters.core.tagging.ModelKeyAndTypeModelTranslator;
import com.vmware.vise.data.adapters.core.tagging.ModelTranslator;
import com.vmware.vise.data.adapters.core.tagging.NameAndValuePropertyTranslator;
import com.vmware.vise.data.adapters.core.tagging.PropertyTranslatingConnection;
import com.vmware.vise.data.adapters.core.tagging.PropertyTranslator;
import com.vmware.vise.data.adapters.core.tagging.PropertyValueTranslator;
import com.vmware.vise.data.uri.VapiUriSchemeUtil;
import com.vmware.vise.search.model.ModelUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class InventoryServiceTaggingQueryModel {
    public static final String MODEL_INVSVC_TAG = "inventoryservice:InventoryServiceTag";
    public static final String MODEL_INVSVC_TAG_ASSOCIATION = "inventoryservice:InventoryServiceTagAssociation";
    public static final String SIMPLE_PROPERTY_TAG = "tag";
    public static final String SIMPLE_PROPERTY_ENTITY = "entity";
    public static final String PROPERTY_INVSVC_TAG_ASSOCIATION_TAG = "inventoryservice:InventoryServiceTagAssociation/tag";
    public static final String PROPERTY_INVSVC_TAG_ASSOCIATION_ENTITY = "inventoryservice:InventoryServiceTagAssociation/entity";
    public static final String RELATION_INVSVC_TAG = "inventoryservice:tag";
    public static final String RELATION_ENTITY = "entity";
    private static Map<String, ModelTranslator> TRANSLATOR_BY_MODEL;
    private static Map<String, PropertyTranslator> TRANSLATOR_BY_PROPERTY;

    public static CoreQueryService withInvSvcTagging(CoreQueryService coreQueryService) {
        Validate.notNull((Object)coreQueryService);
        return new PropertyTranslatingConnection(coreQueryService, TRANSLATOR_BY_MODEL, TRANSLATOR_BY_PROPERTY);
    }

    static {
        VmodlTypeMap vmodlTypeMap = new HashMap();
        vmodlTypeMap.put(MODEL_INVSVC_TAG_ASSOCIATION, new ModelKeyAndTypeModelTranslator("com.vmware.cis.tagging.TagAssociationModel", new NoneValueConverer(), new FixedValueTranslator("com.vmware.cis.tagging.TagAssociation", MODEL_INVSVC_TAG_ASSOCIATION)));
        TRANSLATOR_BY_MODEL = Collections.unmodifiableMap(vmodlTypeMap);
        vmodlTypeMap = new HashMap();
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_ASSOCIATION_TAG, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.TagAssociationModel/tagId", new MorToId(), QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID)));
        vmodlTypeMap.put(PROPERTY_INVSVC_TAG_ASSOCIATION_ENTITY, NameAndValuePropertyTranslator.derivedFrom("com.vmware.cis.tagging.TagAssociationModel/objectId", new AssociationEntity(), QuerySchema.PropertyInfo.forFilterableProperty((QuerySchema.PropertyType)QuerySchema.PropertyType.ID)));
        TRANSLATOR_BY_PROPERTY = Collections.unmodifiableMap(vmodlTypeMap);
        vmodlTypeMap = VmodlTypeMap.Factory.getTypeMap();
        String string = Tag.class.getAnnotation(wsdlName.class).value();
        VmodlType vmodlType = vmodlTypeMap.getVmodlType(string);
        if (vmodlType == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(InventoryServiceTaggingQueryModel.class.getClassLoader());
            try {
                VmodlContext.initContext((String[])new String[]{"com.vmware.vim.binding.dataservice"});
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalStateException("Could not load VMODL1 bindings for Tagging into the global VMODL1 context", runtimeException);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
    }

    private static final class AssociationEntity
    implements PropertyValueTranslator {
        private AssociationEntity() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            assert (object != null);
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayList<DynamicID> arrayList = new ArrayList<DynamicID>(collection.size());
                for (Object e : collection) {
                    arrayList.add(AssociationEntity.toDynamicID(string, e));
                }
                return arrayList;
            }
            return AssociationEntity.toDynamicID(string, object);
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            if (!(object instanceof DynamicID)) {
                throw new IllegalArgumentException(String.format("Expected DynamicID value for property '%s' but found ", string, object.getClass()));
            }
            DynamicID dynamicID = (DynamicID)object;
            if (ModelUtils.isVmodl2Name((String)dynamicID.getType())) {
                return VapiUriSchemeUtil.createUri((String)dynamicID.getType(), (String)dynamicID.getId());
            }
            return CisIdConverter.fromGlobalCisId((String)dynamicID.getId(), (String)dynamicID.getType());
        }

        private static DynamicID toDynamicID(String string, Object object) {
            assert (object != null);
            if (object instanceof URI) {
                URI uRI = (URI)object;
                return new DynamicID(VapiUriSchemeUtil.getType((URI)uRI), VapiUriSchemeUtil.getId((URI)uRI));
            }
            if (object instanceof ManagedObjectReference) {
                ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
                String string2 = managedObjectReference.getType();
                String string3 = CisIdConverter.toGlobalCisId((ManagedObjectReference)managedObjectReference, (String)managedObjectReference.getServerGuid());
                return new DynamicID(string2, string3);
            }
            throw new IllegalArgumentException(String.format("Unexpected comparable value for property '%s': %s", string, object.getClass()));
        }
    }

    private static final class MorToId
    implements PropertyValueTranslator {
        private MorToId() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                ArrayList<String> arrayList = new ArrayList<String>(collection.size());
                for (Object e : collection) {
                    arrayList.add(MorToId.toId(string, e));
                }
                return arrayList;
            }
            return MorToId.toId(string, object);
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            if (object == null) {
                return null;
            }
            assert (object instanceof String);
            String string2 = (String)object;
            return InventoryServiceTaggingIdConverter.taggingIdToMor(string2);
        }

        private static String toId(String string, Object object) {
            assert (object != null);
            if (!(object instanceof ManagedObjectReference)) {
                throw new IllegalArgumentException(String.format("Expected ManagedObjectReference comparable value for property '%s' but found ", string, object.getClass()));
            }
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)object;
            return InventoryServiceTaggingIdConverter.taggingMorToId(managedObjectReference);
        }
    }

    private static final class NoneValueConverer
    implements PropertyValueTranslator {
        private NoneValueConverer() {
        }

        @Override
        public Object onComparableValue(String string, Object object) {
            return object;
        }

        @Override
        public Object onPropertyValue(String string, Object object) {
            return object;
        }
    }
}

