/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.tagging;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.util.SchemaUtil;
import com.vmware.cis.data.internal.provider.util.property.PropertyByName;
import com.vmware.cis.data.internal.provider.util.property.PropertyByNameBackedByResourceItem;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyByName;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyValueByNameViaIndexMap;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.tagging.ModelTranslator;
import com.vmware.vise.data.adapters.core.tagging.PropertyTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

final class PropertyTranslatingConnection
implements CoreQueryService {
    private final CoreQueryService _delegate;
    private final Map<String, ModelTranslator> _translatorByModel;
    private final Map<String, PropertyTranslator> _translatorByProperty;

    PropertyTranslatingConnection(CoreQueryService coreQueryService, Map<String, ModelTranslator> map, Map<String, PropertyTranslator> map2) {
        assert (coreQueryService != null);
        assert (map != null);
        assert (map2 != null);
        this._delegate = coreQueryService;
        this._translatorByModel = Collections.unmodifiableMap(map);
        this._translatorByProperty = Collections.unmodifiableMap(map2);
    }

    @Override
    public ResultSet executeQuery(Query query) {
        boolean bl;
        Validate.notNull((Object)query);
        boolean bl2 = this.skipSelect(query);
        boolean bl3 = this.skipModels(query);
        boolean bl4 = this.skipFilter(query);
        boolean bl5 = this.skipSort(query);
        boolean bl6 = bl = bl2 && bl3 && bl4 && bl5;
        if (bl) {
            return this._delegate.executeQuery(query);
        }
        List<String> list = bl2 ? query.getProperties() : this.translateSelect(query);
        Collection<String> collection = bl3 ? query.getResourceModels() : this.translateModels(query);
        Filter filter = bl4 ? query.getFilter() : this.translateFilter(query);
        List<SortCriterion> list2 = bl5 ? query.getSortCriteria() : this.translateSort(query);
        Query query2 = QueryCopy.copyAndSelect((Query)query, list).from(collection).where(filter).orderBy(list2).build();
        ResultSet resultSet = this._delegate.executeQuery(query2);
        if (bl2) {
            return resultSet;
        }
        return this.translateResult(resultSet, query);
    }

    private boolean skipSelect(Query query) {
        assert (query != null);
        List list = query.getProperties();
        Collection collection = query.getResourceModels();
        for (String string : list) {
            if (this.getPropertyTranslator(string, collection) == null) continue;
            return false;
        }
        return true;
    }

    private boolean skipModels(Query query) {
        assert (query != null);
        Collection collection = query.getResourceModels();
        for (String string : collection) {
            if (!this._translatorByModel.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    private boolean skipFilter(Query query) {
        assert (query != null);
        Filter filter = query.getFilter();
        Collection collection = query.getResourceModels();
        if (filter == null) {
            return true;
        }
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            if (this.getPropertyTranslator(propertyPredicate.getProperty(), collection) == null) continue;
            return false;
        }
        return true;
    }

    private boolean skipSort(Query query) {
        assert (query != null);
        List list = query.getSortCriteria();
        Collection collection = query.getResourceModels();
        for (SortCriterion sortCriterion : list) {
            if (this.getPropertyTranslator(sortCriterion.getProperty(), collection) == null) continue;
            return false;
        }
        return true;
    }

    private List<String> translateSelect(Query query) {
        assert (query != null);
        List list = query.getProperties();
        Collection collection = query.getResourceModels();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list.size());
        for (String string : list) {
            linkedHashSet.add(this.translateSelectedProperty(string, collection));
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private Collection<String> translateModels(Query query) {
        assert (query != null);
        Collection collection = query.getResourceModels();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(collection.size());
        for (String string : collection) {
            linkedHashSet.add(this.translateModel(string));
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private String translateModel(String string) {
        assert (string != null);
        ModelTranslator modelTranslator = this._translatorByModel.get(string);
        if (modelTranslator != null) {
            return modelTranslator.onModel(string);
        }
        return string;
    }

    private String translateSelectedProperty(String string, Collection<String> collection) {
        assert (string != null);
        assert (collection != null);
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, collection);
        if (propertyTranslator == null) {
            return string;
        }
        String string2 = propertyTranslator.onSelectedProperty(string);
        assert (string2 != null);
        return string2;
    }

    private Filter translateFilter(Query query) {
        assert (query != null);
        Filter filter = query.getFilter();
        Collection collection = query.getResourceModels();
        if (filter == null) {
            return null;
        }
        ArrayList<PropertyPredicate> arrayList = new ArrayList<PropertyPredicate>(filter.getCriteria().size());
        for (PropertyPredicate propertyPredicate : filter.getCriteria()) {
            arrayList.add(this.translatePredicate(propertyPredicate, collection));
        }
        return new Filter(arrayList, filter.getOperator());
    }

    private PropertyPredicate translatePredicate(PropertyPredicate propertyPredicate, Collection<String> collection) {
        assert (propertyPredicate != null);
        assert (collection != null);
        String string = propertyPredicate.getProperty();
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, collection);
        if (propertyTranslator == null) {
            return propertyPredicate;
        }
        PropertyPredicate propertyPredicate2 = propertyTranslator.onPropertyPredicate(propertyPredicate);
        assert (propertyPredicate2 != null);
        return propertyPredicate2;
    }

    private List<SortCriterion> translateSort(Query query) {
        assert (query != null);
        List list = query.getSortCriteria();
        Collection collection = query.getResourceModels();
        ArrayList<SortCriterion> arrayList = new ArrayList<SortCriterion>(list.size());
        for (SortCriterion sortCriterion : list) {
            arrayList.add(this.translateSort(sortCriterion, collection));
        }
        return arrayList;
    }

    private SortCriterion translateSort(SortCriterion sortCriterion, Collection<String> collection) {
        assert (sortCriterion != null);
        assert (collection != null);
        String string = sortCriterion.getProperty();
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, collection);
        if (propertyTranslator == null) {
            return sortCriterion;
        }
        SortCriterion sortCriterion2 = propertyTranslator.onSortCriterion(sortCriterion);
        assert (sortCriterion2 != null);
        return sortCriterion2;
    }

    private ResultSet translateResult(ResultSet resultSet, Query query) {
        assert (resultSet != null);
        assert (query != null);
        List list = query.getProperties();
        Collection collection = query.getResourceModels();
        ResourceItemPropertyValueByNameViaIndexMap resourceItemPropertyValueByNameViaIndexMap = new ResourceItemPropertyValueByNameViaIndexMap(resultSet.getProperties());
        ResultSet.Builder builder = ResultSet.Builder.properties((List)list);
        for (ResourceItem resourceItem : resultSet.getItems()) {
            PropertyByNameBackedByResourceItem propertyByNameBackedByResourceItem = new PropertyByNameBackedByResourceItem(resourceItem, (ResourceItemPropertyByName)resourceItemPropertyValueByNameViaIndexMap);
            final Object object = resourceItem.getKey();
            Object object2 = this.translatePropertyValue("@modelKey", new PropertyByName(){

                public Object getValue(String string) {
                    return object;
                }
            }, collection);
            builder.item(object2, this.translateItem((PropertyByName)propertyByNameBackedByResourceItem, list, collection));
        }
        return builder.totalCount(resultSet.getTotalCount()).build();
    }

    private List<Object> translateItem(PropertyByName propertyByName, List<String> list, Collection<String> collection) {
        assert (propertyByName != null);
        assert (list != null);
        assert (collection != null);
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (String string : list) {
            arrayList.add(this.translatePropertyValue(string, propertyByName, collection));
        }
        return arrayList;
    }

    private Object translatePropertyValue(String string, PropertyByName propertyByName, Collection<String> collection) {
        assert (string != null);
        assert (propertyByName != null);
        assert (collection != null);
        PropertyTranslator propertyTranslator = this.getPropertyTranslator(string, collection);
        if (propertyTranslator == null) {
            return propertyByName.getValue(string);
        }
        return propertyTranslator.onPropertyValue(string, propertyByName);
    }

    private PropertyTranslator getPropertyTranslator(String string, Collection<String> collection) {
        assert (string != null);
        assert (collection != null);
        if (PropertyUtil.isSpecialProperty((String)string)) {
            return this.getTranslatorForSpecialProperty(string, collection);
        }
        return this._translatorByProperty.get(string);
    }

    private PropertyTranslator getTranslatorForSpecialProperty(String string, Collection<String> collection) {
        assert (string != null);
        assert (collection != null);
        for (String string2 : collection) {
            PropertyTranslator propertyTranslator;
            ModelTranslator modelTranslator = this._translatorByModel.get(string2);
            if (modelTranslator == null || (propertyTranslator = modelTranslator.getTranslatorForSpecialProperty(string2, string)) == null) continue;
            return propertyTranslator;
        }
        return null;
    }

    @Override
    public QuerySchema getSchema() {
        String string2;
        HashMap<String, QuerySchema.PropertyInfo> hashMap = new HashMap<String, QuerySchema.PropertyInfo>(this._translatorByProperty.size());
        for (String string2 : this._translatorByProperty.keySet()) {
            PropertyTranslator propertyTranslator = this._translatorByProperty.get(string2);
            hashMap.put(string2, propertyTranslator.getPropertyInfo());
        }
        QuerySchema querySchema = this._delegate.getSchema();
        string2 = QuerySchema.forProperties(hashMap);
        return SchemaUtil.merge((QuerySchema)querySchema, (QuerySchema)string2);
    }
}

