/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.collect.Sets;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import java.util.Collections;
import java.util.Set;

final class AggregatedModelOps {
    private final AggregatedModelLookup _aggregatedModelLookup;

    public AggregatedModelOps(AggregatedModelLookup aggregatedModelLookup) {
        this._aggregatedModelLookup = aggregatedModelLookup;
    }

    public Set<String> decomposition(String string) {
        return this._aggregatedModelLookup.getAllAggregatedModels().contains(string) ? this._aggregatedModelLookup.getChildrenOfAggregatedModel(string) : Collections.singleton(string);
    }

    public Set<String> intersection(String string, String string2) {
        if (string.equals(string2)) {
            return Collections.singleton(string);
        }
        Set<String> set = this.decomposition(string);
        Set<String> set2 = this.decomposition(string2);
        Sets.SetView setView = Sets.intersection(set, set2);
        return this.tryCollapseToExistingAggregate((Set<String>)setView);
    }

    public final Set<String> difference(String string, String string2) {
        Set<String> set = this.decomposition(string);
        Set<String> set2 = this.decomposition(string2);
        Sets.SetView setView = Sets.difference(set, set2);
        return this.tryCollapseToExistingAggregate((Set<String>)setView);
    }

    private Set<String> tryCollapseToExistingAggregate(Set<String> set) {
        for (String string : this._aggregatedModelLookup.getAllAggregatedModels()) {
            Set set2 = this._aggregatedModelLookup.getChildrenOfAggregatedModel(string);
            if (!set.equals(set2)) continue;
            return Collections.singleton(string);
        }
        return set;
    }
}

