/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.vise.data.adapters.core.CorePropertyConverter;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.ClientSideTypeCoercer;
import com.vmware.vise.data.adapters.core.translator.PropertyConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.TextSearchTools;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QueryOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FilterablePropertyHandler
implements PropertyConstraintTranslator.PropertyConstraintTranslationHandler {
    private static final String PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE = "inventoryservice:InventoryServiceCategory/associableEntityType";
    private static final String PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE_NAME = "inventoryservice:InventoryServiceCategory/associableEntityTypeName";
    private final Logger _logger = LoggerFactory.getLogger(PropertyConstraintTranslator.class);
    private final CorePropertyConverter _propertyConverter;
    private final RequestPropertyValidator _propertyValidator;

    FilterablePropertyHandler(CorePropertyConverter corePropertyConverter, RequestPropertyValidator requestPropertyValidator) {
        assert (corePropertyConverter != null);
        assert (requestPropertyValidator != null);
        this._propertyConverter = corePropertyConverter;
        this._propertyValidator = requestPropertyValidator;
    }

    @Override
    public Map<String, TranslationResult> tryTranslateConstraint(CoreQueryService coreQueryService, PropertyConstraint propertyConstraint, Map<String, Object> map) {
        String string = this._propertyConverter.toCoreProperty(propertyConstraint.targetType, propertyConstraint.propertyName);
        if (!this._propertyValidator.canFilterByProperty(string)) {
            return null;
        }
        QuerySchema.PropertyInfo propertyInfo = this._propertyValidator.getPropertyInfo(string);
        if (!QuerySchema.PropertyType.STRING.equals((Object)propertyInfo.getType()) && this.isTextComparator(propertyConstraint.comparator)) {
            if (FilterablePropertyHandler.isStrictModeEnabled(map)) {
                this._logger.debug("Cannot evaluate textual comparators over non-string property '{}' of type '{}'.", (Object)string, (Object)propertyInfo.getType());
                return Collections.emptyMap();
            }
            return null;
        }
        Object object = propertyConstraint.comparableValue;
        try {
            object = ClientSideTypeCoercer.tryToCoerce(object, propertyInfo.getType());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._logger.debug("Client side type coercion of the comparable value wasn't successful: {}", propertyConstraint.comparableValue);
            return Collections.emptyMap();
        }
        Comparator comparator = propertyConstraint.comparator;
        if ((string.equals(PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE) || string.equals(PROPERTY_INVSVC_CATEGORY_ASSOCIABLE_ENTITY_TYPE_NAME)) && Comparator.CONTAINS.equals((Object)comparator)) {
            comparator = Comparator.EQUALS;
        }
        TranslationResult translationResult = this.translateToCore(string, comparator, object, propertyInfo);
        return Collections.singletonMap(propertyConstraint.targetType, translationResult);
    }

    private TranslationResult translateToCore(String string, Comparator comparator, Object object, QuerySchema.PropertyInfo propertyInfo) {
        Filter filter;
        PropertyPredicate.ComparisonOperator comparisonOperator = FilterablePropertyHandler.getEquivalentCoreOperator(comparator);
        boolean bl = propertyInfo.getType().equals((Object)QuerySchema.PropertyType.STRING);
        if (comparisonOperator != null) {
            PropertyPredicate propertyPredicate = new PropertyPredicate(string, comparisonOperator, object, bl);
            filter = new Filter(Arrays.asList(propertyPredicate));
        } else {
            switch (comparator) {
                case STARTS_WITH: 
                case ENDS_WITH: {
                    filter = FilterablePropertyHandler.convertToStringMatchingFilter(string, comparator, object, false);
                    break;
                }
                case CONTAINS: {
                    filter = FilterablePropertyHandler.convertToStringMatchingFilter(string, comparator, object, bl);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported comparator: " + comparator);
                }
            }
        }
        return filter == null ? TranslationResult.all() : TranslationResult.filter(filter);
    }

    private static PropertyPredicate.ComparisonOperator getEquivalentCoreOperator(Comparator comparator) {
        switch (comparator) {
            case EQUALS: {
                return PropertyPredicate.ComparisonOperator.EQUAL;
            }
            case NOT_EQUALS: {
                return PropertyPredicate.ComparisonOperator.NOT_EQUAL;
            }
            case GREATER: {
                return PropertyPredicate.ComparisonOperator.GREATER;
            }
            case GREATER_OR_EQUALS: {
                return PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL;
            }
            case SMALLER: {
                return PropertyPredicate.ComparisonOperator.LESS;
            }
            case SMALLER_OR_EQUALS: {
                return PropertyPredicate.ComparisonOperator.LESS_OR_EQUAL;
            }
        }
        return null;
    }

    private static Filter convertToStringMatchingFilter(String string, Comparator comparator, Object object, boolean bl) {
        Validate.isTrue((boolean)(object instanceof String), (String)String.format("Comparator %s  expects comparablueValue of type String, but got %s", comparator.name(), object.getClass().getName()));
        String string2 = (String)object;
        if (string2.isEmpty()) {
            return null;
        }
        if (comparator == Comparator.STARTS_WITH) {
            return FilterablePropertyHandler.matchFilter(string, TextSearchTools.escapeTermForLiteralMatch(string2) + "*", bl);
        }
        if (comparator == Comparator.ENDS_WITH) {
            return FilterablePropertyHandler.matchFilter(string, "*" + TextSearchTools.escapeTermForLiteralMatch(string2), bl);
        }
        assert (comparator == Comparator.CONTAINS);
        String string3 = FilterablePropertyHandler.escapeForContainsMatching(string2);
        if (StringUtils.strip((String)string3, (String)"*").isEmpty()) {
            return null;
        }
        return FilterablePropertyHandler.matchFilter(string, string3, bl);
    }

    private static String escapeForContainsMatching(String string) {
        assert (string != null);
        TextSearchTools.SearchTermWildcardInfo searchTermWildcardInfo = TextSearchTools.getSearchTermWildcardInfo(string);
        string = TextSearchTools.escapeWilcards(searchTermWildcardInfo.getBaseTerm());
        if (searchTermWildcardInfo.hasLeadingWildcard() || !searchTermWildcardInfo.hasTrailingWildcard()) {
            string = "*" + string;
        }
        if (searchTermWildcardInfo.hasTrailingWildcard() || !searchTermWildcardInfo.hasLeadingWildcard()) {
            string = string + "*";
        }
        return string;
    }

    private static Filter matchFilter(String string, String string2, boolean bl) {
        PropertyPredicate propertyPredicate = new PropertyPredicate(string, PropertyPredicate.ComparisonOperator.LIKE, (Object)string2, bl);
        return new Filter(Arrays.asList(propertyPredicate), LogicalOperator.AND);
    }

    private boolean isTextComparator(Comparator comparator) {
        switch (comparator) {
            case STARTS_WITH: 
            case ENDS_WITH: 
            case CONTAINS: 
            case TEXTUALLY_MATCHES: {
                return true;
            }
        }
        return false;
    }

    private static boolean isStrictModeEnabled(Map<String, Object> map) {
        if (map == null) {
            return false;
        }
        Object object = map.get(QueryOption.VISE_TO_RISE_TRANSLATOR_STRICT_MODE.name());
        return Boolean.TRUE.equals(object);
    }
}

