/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.base.Function;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ext.aggregated.AggregatedModelLookup;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.ClientSideFiltering;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.ResultSetTable;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ForwardRelationshipResolver
implements Function<CoreQueryService, Map<String, TranslationResult>> {
    private static final Logger _logger = LoggerFactory.getLogger(ForwardRelationshipResolver.class);
    private final AggregatedModelLookup _aggregatedModelLookup;
    private final RequestPropertyValidator _propertyValidator;
    private final CoreResourceModelResolver _resourceModelResolver;
    private final String _sourceType;
    private final String _relationshipProperty;
    private final Map<String, TranslationResult> _relatedObjectsByType;
    private final Map<String, Object> _queryOptions;

    public ForwardRelationshipResolver(AggregatedModelLookup aggregatedModelLookup, RequestPropertyValidator requestPropertyValidator, CoreResourceModelResolver coreResourceModelResolver, String string, String string2, Map<String, TranslationResult> map, Map<String, Object> map2) {
        this._aggregatedModelLookup = aggregatedModelLookup;
        this._propertyValidator = requestPropertyValidator;
        this._resourceModelResolver = coreResourceModelResolver;
        this._sourceType = string;
        this._relationshipProperty = string2;
        this._relatedObjectsByType = map;
        this._queryOptions = map2;
    }

    public Map<String, TranslationResult> apply(CoreQueryService coreQueryService) {
        if (!this._propertyValidator.canSelectByProperty(this._relationshipProperty)) {
            return Collections.emptyMap();
        }
        TranslationResult translationResult = this.translateSupportedRelationship(coreQueryService);
        return Collections.singletonMap(this._sourceType, translationResult);
    }

    public TranslationResult translateSupportedRelationship(CoreQueryService coreQueryService) {
        TranslatorTools.Select select = new TranslatorTools.Select("RelationalConstraint", this._propertyValidator, this._resourceModelResolver, coreQueryService);
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Map.Entry<String, TranslationResult> entry : this._relatedObjectsByType.entrySet()) {
            Collection<Object> collection;
            String string = entry.getKey();
            TranslationResult translationResult = entry.getValue();
            if (translationResult.getOutcome() == TranslationResult.Outcome.MatchesNothing) continue;
            if (!this._aggregatedModelLookup.getAllAggregatedModels().contains(string) && (collection = TranslatorTools.tryGetKeysFromModelKeySet(translationResult)) != null) {
                for (Object object : collection) {
                    hashSet.add(object);
                }
                continue;
            }
            ResultSet resultSet = select.execute(string, translationResult, "@modelKey", "@type");
            List<Object> list = ResultSetTable.getKeys(resultSet);
            List<Object> list2 = ResultSetTable.getProperty(resultSet, "@type");
            if (list.size() != list2.size()) {
                throw new IllegalStateException(String.format("Internal error: %s not returned for all items in the result.", "@type"));
            }
            for (int i = 0; i < list.size(); ++i) {
                Object object = list.get(i);
                hashSet.add(object);
            }
        }
        if (this._propertyValidator.canFilterByProperty(this._relationshipProperty)) {
            return TranslatorTools.toEqualityPredicateResult(this._relationshipProperty, hashSet, false);
        }
        return this.filterAtClientSide(coreQueryService, hashSet);
    }

    private TranslationResult filterAtClientSide(CoreQueryService coreQueryService, Set<Object> set) {
        if (!ClientSideFiltering.isClientSideFilteringEnabled(this._relationshipProperty, this._queryOptions)) {
            throw new UnsupportedOperationException("Cannot filter by non-filterable property: " + this._relationshipProperty);
        }
        _logger.warn("Forward RelationalConstraint with relation = {} will be evaluated client-side because the relationship property is not filterable.", (Object)this._relationshipProperty);
        ResultSet resultSet = this.selectRelationshipForFiltering(coreQueryService);
        int n = resultSet.getProperties().indexOf(this._relationshipProperty);
        if (n == -1) {
            return TranslationResult.empty();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Object e = resourceItem.getPropertyValues().get(n);
            if (!this.containsAny(e, set)) continue;
            arrayList.add(resourceItem.getKey());
        }
        return TranslatorTools.toEqualityPredicateResult("@modelKey", arrayList, false);
    }

    private boolean containsAny(Object object, Set<Object> set) {
        if (object == null) {
            return false;
        }
        Collection<?> collection = ForwardRelationshipResolver.toCollection(object);
        return CollectionUtils.containsAny(set, collection);
    }

    private ResultSet selectRelationshipForFiltering(CoreQueryService coreQueryService) {
        String string = String.format("RelationalConstraint %s client-side", this._relationshipProperty);
        TranslatorTools.Select select = new TranslatorTools.Select(string, this._propertyValidator, this._resourceModelResolver, coreQueryService);
        ResultSet resultSet = select.execute(this._sourceType, TranslationResult.all(), "@modelKey", this._relationshipProperty);
        return resultSet;
    }

    private static Collection<?> toCollection(Object object) {
        if (object instanceof Collection) {
            return (Collection)object;
        }
        if (object.getClass().isArray()) {
            return Arrays.asList((Object[])object);
        }
        return Collections.singleton(object);
    }
}

