/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.ReferenceConverter;
import com.vmware.vise.data.adapters.core.RequestPropertyValidator;
import com.vmware.vise.data.adapters.core.translator.CoreResourceModelResolver;
import com.vmware.vise.data.adapters.core.translator.ResultSetTable;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InverseRelationshipResolver
implements Function<CoreQueryService, Map<String, TranslationResult>> {
    private static final Logger _logger = LoggerFactory.getLogger(InverseRelationshipResolver.class);
    private final String _currentObjectType;
    private final RequestPropertyValidator _propertyValidator;
    private final CoreResourceModelResolver _resourceModelResolver;
    private final Multimap<String, String> _relationshipsByRelatedType;
    private final Map<String, TranslationResult> _relatedObjectsByType;

    public InverseRelationshipResolver(RequestPropertyValidator requestPropertyValidator, CoreResourceModelResolver coreResourceModelResolver, String string, Multimap<String, String> multimap, Map<String, TranslationResult> map) {
        this._propertyValidator = requestPropertyValidator;
        this._resourceModelResolver = coreResourceModelResolver;
        this._currentObjectType = string;
        this._relationshipsByRelatedType = multimap;
        this._relatedObjectsByType = map;
    }

    public Map<String, TranslationResult> apply(CoreQueryService coreQueryService) {
        Object object;
        Object object2;
        TranslatorTools.Select select = new TranslatorTools.Select("RelationalConstraint", this._propertyValidator, this._resourceModelResolver, coreQueryService);
        HashMultimap hashMultimap = HashMultimap.create();
        for (Map.Entry<String, TranslationResult> entry : this._relatedObjectsByType.entrySet()) {
            String string = entry.getKey();
            object2 = this._relationshipsByRelatedType.get((Object)string);
            if (object2.isEmpty()) continue;
            object = object2.toArray(new String[object2.size()]);
            ResultSet resultSet = select.execute(string, (TranslationResult)entry.getValue(), (String)object);
            List<Object> list = InverseRelationshipResolver.getProperties(resultSet, (Collection<String>)object2);
            list = InverseRelationshipResolver.flattenForInclusionComparison(list);
            _logger.trace("Inverse RelationalConstraint translated to set of object ids: {}", list);
            for (Object object3 : list) {
                String string2;
                if (this._currentObjectType != null) {
                    string2 = this._currentObjectType;
                } else if (object3 instanceof ManagedObjectReference || object3 instanceof URI) {
                    string2 = ReferenceConverter.getResourceObjectType(object3);
                } else {
                    throw new UnsupportedOperationException(String.format("Unable to determine object type for: [%s] returned by: %s", object3, object2));
                }
                hashMultimap.put((Object)string2, object3);
            }
        }
        HashMap hashMap = new HashMap(hashMultimap.keySet().size());
        for (String string : hashMultimap.keySet()) {
            block11: {
                object2 = TranslatorTools.toEqualityPredicateResult("@modelKey", hashMultimap.get((Object)string), false);
                if (string != null) {
                    try {
                        object = this._resourceModelResolver.getDefaultModel(string);
                        if (!this._propertyValidator.isModelSupported((String)object)) {
                            _logger.warn("Model '{}' extracted for type '{}' is not supported", object, (Object)string);
                        }
                        break block11;
                    }
                    catch (Exception exception) {
                        _logger.warn("Failed to retrieve model for type '{}'", (Object)string);
                    }
                    continue;
                }
            }
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    private static List<Object> flattenForInclusionComparison(List<Object> list) {
        assert (list != null);
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>(list.size());
        for (Object object : list) {
            if (object == null) continue;
            if (object instanceof Collection) {
                linkedHashSet.addAll((Collection)object);
                continue;
            }
            if (object.getClass().isArray()) {
                linkedHashSet.addAll(Arrays.asList((Object[])object));
                continue;
            }
            linkedHashSet.add(object);
        }
        return new ArrayList<Object>(linkedHashSet);
    }

    private static List<Object> getProperties(ResultSet resultSet, Collection<String> collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string : collection) {
            arrayList.addAll(ResultSetTable.getProperty(resultSet, string));
        }
        return arrayList;
    }
}

