/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator;

import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class TextSearchTools {
    public static final String WILDCARD_MATCH_SYMBOL = "*";
    private static final String ESCAPE_SYMBOL = "\\";
    private static final String ESCAPED_WILDCARD = "\\*";
    private static final Pattern UNESCAPED_WILDCARD = Pattern.compile("(?<!\\\\)(\\\\\\\\)*\\*");
    private static final Pattern UNESCAPED_WILDCARD_AT_END = Pattern.compile(UNESCAPED_WILDCARD + "$");

    public static SearchTermWildcardInfo getSearchTermWildcardInfo(String string) {
        boolean bl;
        boolean bl2;
        String string2 = string;
        if (string2.startsWith(WILDCARD_MATCH_SYMBOL)) {
            string2 = StringUtils.removeStart((String)string2, (String)WILDCARD_MATCH_SYMBOL);
            bl2 = true;
        } else {
            bl2 = false;
        }
        if (UNESCAPED_WILDCARD_AT_END.matcher(string2).find()) {
            string2 = StringUtils.removeEnd((String)string2, (String)WILDCARD_MATCH_SYMBOL);
            bl = true;
        } else {
            bl = false;
        }
        return new SearchTermWildcardInfo(bl2, bl, string2);
    }

    public static String escapeTermForLiteralMatch(String string) {
        return string.replace(ESCAPE_SYMBOL, "\\\\").replace(WILDCARD_MATCH_SYMBOL, ESCAPED_WILDCARD);
    }

    public static String unescapeSearchTemplate(String string) {
        return string.replace("\\\\", ESCAPE_SYMBOL).replace(ESCAPED_WILDCARD, WILDCARD_MATCH_SYMBOL);
    }

    public static String escapeWilcards(String string) {
        return UNESCAPED_WILDCARD.matcher(string).replaceAll("$1\\\\*");
    }

    public static final class SearchTermWildcardInfo {
        private final boolean _hasLeadingWildcard;
        private final boolean _hasTrailingWildcard;
        private final String _baseTerm;

        public SearchTermWildcardInfo(boolean bl, boolean bl2, String string) {
            this._hasLeadingWildcard = bl;
            this._hasTrailingWildcard = bl2;
            this._baseTerm = string;
        }

        public boolean hasLeadingWildcard() {
            return this._hasLeadingWildcard;
        }

        public boolean hasTrailingWildcard() {
            return this._hasTrailingWildcard;
        }

        public String getBaseTerm() {
            return this._baseTerm;
        }
    }
}

