/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator.cornercase;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import com.vmware.vise.data.adapters.core.translator.ClientSideFiltering;
import com.vmware.vise.data.adapters.core.translator.ConstraintTranslator;
import com.vmware.vise.data.adapters.core.translator.TranslationResult;
import com.vmware.vise.data.adapters.core.translator.TranslatorResolver;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class RelationalConstraintSpecialCases
implements ConstraintTranslator<RelationalConstraint> {
    public static final String TYPE_MANAGED_ENTITY = "ManagedEntity";
    public static final String TYPE_CUSTOM_FIELD_STRING_VALUE = "CustomFieldStringValue";
    public static final String TYPE_CUSTOM_FIELD_DEF = "CustomFieldDef";
    public static final String TYPE_RESOURCE_POOL = "ResourcePool";
    public static final String TYPE_VAPP = "VirtualApp";
    public static final String TYPE_VM = "VirtualMachine";
    public static final String RELATION_CUSTOM_STRING_VALUE = "customStringValue";
    public static final String RELATION_CUSTOM_FIELD_DEF = "fieldDef";
    public static final String RELATION_VAPP_CONTENTS = "vappcontents";
    public static final String RELATION_RESOURCE_POOL = "resourcePool";
    public static final String RELATION_PARENT_VAPP = "parentVApp";
    public static final String RELATION_VM = "vm";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_ENTITY = "entity";
    public static final String PROPERTY_IS_NORMAL_VM = "isNormalVM";
    private final TranslatorResolver _translatorResolver;
    private final ConstraintTranslator<RelationalConstraint> _relationTranslator;

    public RelationalConstraintSpecialCases(TranslatorResolver translatorResolver, ConstraintTranslator<RelationalConstraint> constraintTranslator) {
        assert (translatorResolver != null);
        assert (constraintTranslator != null);
        this._translatorResolver = translatorResolver;
        this._relationTranslator = constraintTranslator;
    }

    @Override
    public Map<String, TranslationResult> translate(CoreQueryService coreQueryService, RelationalConstraint relationalConstraint, Map<String, Object> map) {
        Validate.notNull((Object)coreQueryService);
        Validate.notNull((Object)relationalConstraint);
        if (TYPE_VAPP.equals(relationalConstraint.constraintOnRelatedObject.targetType) && RELATION_VAPP_CONTENTS.equals(relationalConstraint.relation) && relationalConstraint.hasInverseRelation) {
            return this.translateVappContentsRelation(coreQueryService, relationalConstraint, map);
        }
        return this._relationTranslator.translate(coreQueryService, RelationalConstraintSpecialCases.intercept(relationalConstraint, map), map);
    }

    private static RelationalConstraint intercept(RelationalConstraint relationalConstraint, Map<String, Object> map) {
        String string = relationalConstraint.relation;
        String string2 = RelationalConstraintSpecialCases.getTypeThatDefinesRelation(relationalConstraint);
        if ("inventoryservice:tag".equals(string)) {
            return RelationalConstraintSpecialCases.interceptTagRelation(relationalConstraint);
        }
        if (PROPERTY_ENTITY.equals(string) && "inventoryservice:InventoryServiceTag".equals(string2)) {
            return RelationalConstraintSpecialCases.interceptEntityRelation(relationalConstraint);
        }
        if (RELATION_CUSTOM_STRING_VALUE.equals(string) && !relationalConstraint.hasInverseRelation) {
            return RelationalConstraintSpecialCases.interceptCustomStringValueRelation(relationalConstraint, map);
        }
        return relationalConstraint;
    }

    private static String getTypeThatDefinesRelation(RelationalConstraint relationalConstraint) {
        assert (relationalConstraint != null);
        return relationalConstraint.hasInverseRelation ? relationalConstraint.constraintOnRelatedObject.targetType : relationalConstraint.targetType;
    }

    private static RelationalConstraint interceptTagRelation(RelationalConstraint relationalConstraint) {
        assert (relationalConstraint != null);
        if (relationalConstraint.hasInverseRelation) {
            return RelationalConstraintSpecialCases.tagToAssociationToEntity(relationalConstraint);
        }
        return RelationalConstraintSpecialCases.entityToAssociationToTag(relationalConstraint);
    }

    private static RelationalConstraint interceptEntityRelation(RelationalConstraint relationalConstraint) {
        assert (relationalConstraint != null);
        if (relationalConstraint.hasInverseRelation) {
            return RelationalConstraintSpecialCases.entityToAssociationToTag(relationalConstraint);
        }
        return RelationalConstraintSpecialCases.tagToAssociationToEntity(relationalConstraint);
    }

    private static RelationalConstraint entityToAssociationToTag(RelationalConstraint relationalConstraint) {
        assert (relationalConstraint != null);
        RelationalConstraint relationalConstraint2 = new RelationalConstraint();
        relationalConstraint2.targetType = "inventoryservice:InventoryServiceTagAssociation";
        relationalConstraint2.relation = "tag";
        relationalConstraint2.hasInverseRelation = false;
        relationalConstraint2.constraintOnRelatedObject = relationalConstraint.constraintOnRelatedObject;
        RelationalConstraint relationalConstraint3 = new RelationalConstraint();
        relationalConstraint3.targetType = relationalConstraint.targetType;
        relationalConstraint3.relation = PROPERTY_ENTITY;
        relationalConstraint3.hasInverseRelation = true;
        relationalConstraint3.constraintOnRelatedObject = relationalConstraint2;
        return relationalConstraint3;
    }

    private static RelationalConstraint tagToAssociationToEntity(RelationalConstraint relationalConstraint) {
        assert (relationalConstraint != null);
        RelationalConstraint relationalConstraint2 = new RelationalConstraint();
        relationalConstraint2.targetType = "inventoryservice:InventoryServiceTagAssociation";
        relationalConstraint2.relation = PROPERTY_ENTITY;
        relationalConstraint2.hasInverseRelation = false;
        relationalConstraint2.constraintOnRelatedObject = relationalConstraint.constraintOnRelatedObject;
        RelationalConstraint relationalConstraint3 = new RelationalConstraint();
        relationalConstraint3.targetType = relationalConstraint.targetType;
        relationalConstraint3.relation = "tag";
        relationalConstraint3.hasInverseRelation = true;
        relationalConstraint3.constraintOnRelatedObject = relationalConstraint2;
        return relationalConstraint3;
    }

    private static RelationalConstraint interceptCustomStringValueRelation(RelationalConstraint relationalConstraint, Map<String, Object> map) {
        assert (relationalConstraint != null);
        if (!ClientSideFiltering.isClientSideFilteringEnabled(RELATION_CUSTOM_STRING_VALUE, map)) {
            throw new UnsupportedOperationException("Cannot filter by non-filterable property: customStringValue");
        }
        CompositeConstraint compositeConstraint = RelationalConstraintSpecialCases.getCustomValueRelationConstraintOnRelated(relationalConstraint.constraintOnRelatedObject);
        Constraint[] constraintArray = compositeConstraint.nestedConstraints;
        PropertyConstraint propertyConstraint = RelationalConstraintSpecialCases.getCustomFieldNamePropertyConstraint(constraintArray);
        PropertyConstraint propertyConstraint2 = RelationalConstraintSpecialCases.getCustomFieldValuePropertyConstraint(constraintArray);
        PropertyConstraint propertyConstraint3 = new PropertyConstraint();
        propertyConstraint3.targetType = "CustomFieldAssociation";
        propertyConstraint3.propertyName = PROPERTY_NAME;
        propertyConstraint3.comparator = propertyConstraint.comparator;
        propertyConstraint3.comparableValue = propertyConstraint.comparableValue;
        PropertyConstraint propertyConstraint4 = new PropertyConstraint();
        propertyConstraint4.targetType = "CustomFieldAssociation";
        propertyConstraint4.propertyName = PROPERTY_VALUE;
        propertyConstraint4.comparator = propertyConstraint2.comparator;
        propertyConstraint4.comparableValue = propertyConstraint2.comparableValue;
        CompositeConstraint compositeConstraint2 = new CompositeConstraint();
        compositeConstraint2.targetType = "CustomFieldAssociation";
        compositeConstraint2.nestedConstraints = new Constraint[]{propertyConstraint3, propertyConstraint4};
        RelationalConstraint relationalConstraint2 = new RelationalConstraint();
        relationalConstraint2.targetType = TYPE_MANAGED_ENTITY;
        relationalConstraint2.relation = PROPERTY_ENTITY;
        relationalConstraint2.hasInverseRelation = true;
        relationalConstraint2.constraintOnRelatedObject = compositeConstraint2;
        return relationalConstraint2;
    }

    private static CompositeConstraint getCustomValueRelationConstraintOnRelated(Constraint constraint) {
        Validate.notNull((Object)constraint, (String)"Custom field constraint must not be null");
        if (!(constraint instanceof CompositeConstraint)) {
            throw new UnsupportedOperationException(String.format("Expected custom field CompositeConstraint but found %s", constraint.getClass().getSimpleName()));
        }
        CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
        if (!Conjoiner.AND.equals((Object)compositeConstraint.conjoiner)) {
            throw new UnsupportedOperationException(String.format("Expected custom field CompositeConstraint.conjoiner to be AND but found %s", compositeConstraint.conjoiner));
        }
        Validate.notNull((Object)compositeConstraint.nestedConstraints, (String)"Custom field CompositeConstraint.nestedConstraints is null");
        if (compositeConstraint.nestedConstraints.length != 2) {
            throw new UnsupportedOperationException(String.format("Expected custom field CompositeConstraint with two nested constraints but found %s", compositeConstraint.nestedConstraints.length));
        }
        return compositeConstraint;
    }

    private static PropertyConstraint getCustomFieldValuePropertyConstraint(Constraint[] constraintArray) {
        assert (constraintArray != null);
        PropertyConstraint propertyConstraint = null;
        for (Constraint constraint : constraintArray) {
            if (!(constraint instanceof PropertyConstraint)) continue;
            propertyConstraint = (PropertyConstraint)constraint;
            break;
        }
        Validate.notNull(propertyConstraint, (String)"Could not find PropertyConstraint on custom field value");
        if (!TYPE_CUSTOM_FIELD_STRING_VALUE.equals(propertyConstraint.targetType)) {
            throw new UnsupportedOperationException(String.format("Expected PropertyConstraint on custom field value with targetType '%s' but found '%s'", TYPE_CUSTOM_FIELD_STRING_VALUE, propertyConstraint.targetType));
        }
        if (!PROPERTY_VALUE.equals(propertyConstraint.propertyName)) {
            throw new UnsupportedOperationException(String.format("Expected PropertyConstraint on custom field value with propertyName '%s' but found '%s'", PROPERTY_VALUE, propertyConstraint.propertyName));
        }
        return propertyConstraint;
    }

    private static PropertyConstraint getCustomFieldNamePropertyConstraint(Constraint[] propertyConstraint) {
        assert (propertyConstraint != null);
        RelationalConstraint relationalConstraint = null;
        for (Constraint constraint : propertyConstraint) {
            if (!(constraint instanceof RelationalConstraint)) continue;
            relationalConstraint = (RelationalConstraint)constraint;
            break;
        }
        Validate.notNull(relationalConstraint, (String)"Could not find RelationalConstraint on custom field definition");
        if (!TYPE_CUSTOM_FIELD_STRING_VALUE.equals(relationalConstraint.targetType)) {
            throw new UnsupportedOperationException(String.format("Expected RelationalConstraint on custom field definition with targetType '%s' but found '%s'", TYPE_CUSTOM_FIELD_STRING_VALUE, relationalConstraint.targetType));
        }
        if (!RELATION_CUSTOM_FIELD_DEF.equals(relationalConstraint.relation)) {
            throw new UnsupportedOperationException(String.format("Expected RelationalConstraint on custom field definition with relation '%s' but found '%s'", RELATION_CUSTOM_FIELD_DEF, relationalConstraint.relation));
        }
        if (relationalConstraint.hasInverseRelation) {
            throw new UnsupportedOperationException("Expected RelationalConstraint on custom field definition to be forward and not inverse");
        }
        if (!(relationalConstraint.constraintOnRelatedObject instanceof PropertyConstraint)) {
            throw new UnsupportedOperationException(String.format("Expected RelationalConstraint on custom field definition to have constraintOnRelatedObject that is PropertyConstraint and not %s", relationalConstraint.constraintOnRelatedObject.getClass().getSimpleName()));
        }
        PropertyConstraint propertyConstraint2 = (PropertyConstraint)relationalConstraint.constraintOnRelatedObject;
        if (!TYPE_CUSTOM_FIELD_DEF.equals(propertyConstraint2.targetType)) {
            throw new UnsupportedOperationException(String.format("Expected PropertyConstraint on custom field name with targetType '%s' but found '%s'", TYPE_CUSTOM_FIELD_DEF, propertyConstraint2.targetType));
        }
        if (!PROPERTY_NAME.equals(propertyConstraint2.propertyName)) {
            throw new UnsupportedOperationException(String.format("Expected PropertyConstraint on custom field name with propertyName '%s' but found '%s'", PROPERTY_NAME, propertyConstraint2.propertyName));
        }
        return propertyConstraint2;
    }

    private Map<String, TranslationResult> translateVappContentsRelation(CoreQueryService coreQueryService, RelationalConstraint relationalConstraint, Map<String, Object> map) {
        assert (coreQueryService != null);
        assert (relationalConstraint != null);
        assert (RELATION_VAPP_CONTENTS.equals(relationalConstraint.relation));
        assert (relationalConstraint.hasInverseRelation);
        if (!ClientSideFiltering.isClientSideFilteringEnabled(RELATION_VAPP_CONTENTS, map)) {
            throw new UnsupportedOperationException("Cannot filter by non-filterable property: vappcontents");
        }
        RelationalConstraint relationalConstraint2 = new RelationalConstraint();
        relationalConstraint2.relation = RELATION_RESOURCE_POOL;
        relationalConstraint2.hasInverseRelation = true;
        relationalConstraint2.constraintOnRelatedObject = relationalConstraint.constraintOnRelatedObject;
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.targetType = TYPE_RESOURCE_POOL;
        propertyConstraint.propertyName = "@type";
        propertyConstraint.comparator = Comparator.EQUALS;
        propertyConstraint.comparableValue = TYPE_RESOURCE_POOL;
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.AND;
        compositeConstraint.nestedConstraints = new Constraint[]{relationalConstraint2, propertyConstraint};
        RelationalConstraint relationalConstraint3 = new RelationalConstraint();
        relationalConstraint3.targetType = TYPE_VAPP;
        relationalConstraint3.relation = RELATION_PARENT_VAPP;
        relationalConstraint3.hasInverseRelation = false;
        relationalConstraint3.constraintOnRelatedObject = relationalConstraint.constraintOnRelatedObject;
        RelationalConstraint relationalConstraint4 = new RelationalConstraint();
        relationalConstraint4.targetType = TYPE_VM;
        relationalConstraint4.relation = RELATION_VM;
        relationalConstraint4.hasInverseRelation = true;
        relationalConstraint4.constraintOnRelatedObject = relationalConstraint.constraintOnRelatedObject;
        PropertyConstraint propertyConstraint2 = new PropertyConstraint();
        propertyConstraint2.targetType = TYPE_VM;
        propertyConstraint2.propertyName = PROPERTY_IS_NORMAL_VM;
        propertyConstraint2.comparator = Comparator.EQUALS;
        propertyConstraint2.comparableValue = true;
        CompositeConstraint compositeConstraint2 = new CompositeConstraint();
        compositeConstraint2.conjoiner = Conjoiner.AND;
        compositeConstraint2.nestedConstraints = new Constraint[]{relationalConstraint4, propertyConstraint2};
        CompositeConstraint compositeConstraint3 = new CompositeConstraint();
        compositeConstraint3.conjoiner = Conjoiner.OR;
        compositeConstraint3.nestedConstraints = new Constraint[]{compositeConstraint, relationalConstraint3, compositeConstraint2};
        return this._translatorResolver.getTranslator(compositeConstraint3).translate(coreQueryService, compositeConstraint3, map);
    }
}

