/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.core.translator.cornercase;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.util.QueryCopy;
import com.vmware.vise.data.adapters.core.CoreQueryService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

final class WebClientDerivedPropertyProviderConnection
implements CoreQueryService {
    private final CoreQueryService _delegate;
    private final ImmutableMap<String, DerivedPropertyProviderInfo> _derivedProperties;

    WebClientDerivedPropertyProviderConnection(CoreQueryService coreQueryService, ImmutableMap<String, DerivedPropertyProviderInfo> immutableMap) {
        this._delegate = coreQueryService;
        this._derivedProperties = immutableMap;
    }

    @Override
    public ResultSet executeQuery(Query query) {
        if (this.skipQuery(query)) {
            return this._delegate.executeQuery(query);
        }
        List<String> list = this.replaceDerivedProperties(query.getProperties());
        Query query2 = QueryCopy.copyAndSelect((Query)query, list).build();
        ResultSet resultSet = this._delegate.executeQuery(query2);
        ResultSet.Builder builder = ResultSet.Builder.properties((List)query.getProperties());
        this.handleDerivedProperties(builder, query.getProperties(), resultSet.getItems());
        return builder.totalCount(resultSet.getTotalCount()).build();
    }

    private List<String> replaceDerivedProperties(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            DerivedPropertyProviderInfo derivedPropertyProviderInfo = (DerivedPropertyProviderInfo)this._derivedProperties.get((Object)string);
            if (derivedPropertyProviderInfo != null) {
                string = derivedPropertyProviderInfo.property;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private void handleDerivedProperties(ResultSet.Builder builder, List<String> list, List<ResourceItem> list2) {
        HashMap<Integer, DerivedPropertyProviderInfo> hashMap = new HashMap<Integer, DerivedPropertyProviderInfo>();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            DerivedPropertyProviderInfo derivedPropertyProviderInfo = (DerivedPropertyProviderInfo)this._derivedProperties.get((Object)string);
            if (derivedPropertyProviderInfo == null) continue;
            hashMap.put(i, derivedPropertyProviderInfo);
        }
        for (ResourceItem resourceItem : list2) {
            builder.item(resourceItem.getKey(), this.handleDerivedProperties(resourceItem, hashMap));
        }
    }

    private List<Object> handleDerivedProperties(ResourceItem resourceItem, Map<Integer, DerivedPropertyProviderInfo> map) {
        List list = resourceItem.getPropertyValues();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            DerivedPropertyProviderInfo derivedPropertyProviderInfo = map.get(i);
            if (derivedPropertyProviderInfo != null) {
                object = derivedPropertyProviderInfo.derivedPropertyProvider.apply(object);
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    private boolean skipQuery(Query query) {
        for (String string : query.getProperties()) {
            if (!this._derivedProperties.containsKey((Object)string)) continue;
            return false;
        }
        return true;
    }

    @Override
    public QuerySchema getSchema() {
        return this._delegate.getSchema();
    }

    static class DerivedPropertyProviderInfo {
        private String property;
        private Function<Object, Object> derivedPropertyProvider;

        DerivedPropertyProviderInfo() {
        }

        public static DerivedPropertyProviderInfo of(String string, Function<Object, Object> function) {
            Validate.notEmpty((String)string);
            Validate.notNull(function);
            DerivedPropertyProviderInfo derivedPropertyProviderInfo = new DerivedPropertyProviderInfo();
            derivedPropertyProviderInfo.property = string;
            derivedPropertyProviderInfo.derivedPropertyProvider = function;
            return derivedPropertyProviderInfo;
        }
    }
}

