/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.internal.util.ContentLibraryQualifier;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

final class RiseToViseProperty {
    public static final String INVERSE_SUFFIX = "/@deprecatedInverse";
    private static final String MOID_SUFFIX = "@moId";
    private static final String PROPERTY_SERVER_GUID = "serverGuid";
    private static final String CORE_API_PROPERTY_LENGTH_SUFFIX = "/length";
    private static final String CORE_API_PROPERTY_FORMATTED_SUFFIX = "/@formatted";
    private static final String CORE_API_PROPERTY_LENGTH_SUFFIX_VAPI_REPLACEMENT = "/_length";
    private static final String CORE_API_PROPERTY_LENGTH_SUFFIX_VMODL_REPLACEMENT = "._length";
    private static final String CORE_API_PROPERTY_FORMATTED_SUFFIX_REPLACEMENT = ".@formatted";
    private static final char VISE_API_VMODL1_PROPERTY_PATH_SEPARATOR = '.';
    private static final Map<String, String> _typeHintedByRegularProperty = RiseToViseProperty.getTypeHintedByRegularProperty();

    RiseToViseProperty() {
    }

    public String toViseProperty(String string) {
        assert (string != null);
        if (PropertyUtil.isSpecialProperty((String)string)) {
            return string;
        }
        if (string.endsWith(MOID_SUFFIX)) {
            throw new UnsupportedOperationException("Support for @moId is not yet implemented");
        }
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName((String)string);
        if ("@instanceUuid".equals(qualifiedProperty.getSimpleProperty())) {
            return PROPERTY_SERVER_GUID;
        }
        String string2 = qualifiedProperty.getResourceModel();
        String string3 = qualifiedProperty.getSimpleProperty();
        String string4 = null;
        if (string3.endsWith(CORE_API_PROPERTY_LENGTH_SUFFIX)) {
            string3 = StringUtils.removeEnd((String)string3, (String)CORE_API_PROPERTY_LENGTH_SUFFIX);
            string4 = ContentLibraryQualifier.isClModel((String)string2) ? CORE_API_PROPERTY_LENGTH_SUFFIX_VAPI_REPLACEMENT : CORE_API_PROPERTY_LENGTH_SUFFIX_VMODL_REPLACEMENT;
        } else if (RiseToViseProperty.isFormattedProperty(string3)) {
            string3 = StringUtils.removeEnd((String)string3, (String)CORE_API_PROPERTY_FORMATTED_SUFFIX);
            string4 = CORE_API_PROPERTY_FORMATTED_SUFFIX_REPLACEMENT;
        }
        String string5 = RiseToViseProperty.toViseProperty(string2, string3);
        return string4 == null ? string5 : string5 + string4;
    }

    private static String toViseProperty(String string, String string2) {
        if (ContentLibraryQualifier.isClModel((String)string)) {
            return ContentLibraryQualifier.isClType((String)string) ? string2 : QualifiedProperty.forModelAndSimpleProperty((String)string, (String)string2).toString();
        }
        string2 = string2.replace('/', '.');
        return RiseToViseProperty.typifyVmodl1Property(string2);
    }

    public String toViseRelation(String string) {
        assert (string != null);
        String string2 = string;
        if (RiseToViseProperty.isInverseRelation(string2)) {
            string2 = StringUtils.removeEnd((String)string2, (String)INVERSE_SUFFIX);
        }
        return this.toViseProperty(string2);
    }

    public static boolean isInverseRelation(String string) {
        assert (string != null);
        return string.endsWith(INVERSE_SUFFIX);
    }

    public static boolean isFormattedProperty(String string) {
        assert (string != null);
        return string.endsWith(CORE_API_PROPERTY_FORMATTED_SUFFIX);
    }

    private static String typifyVmodl1Property(String string) {
        String string2 = _typeHintedByRegularProperty.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    private static Map<String, String> getTypeHintedByRegularProperty() {
        return ImmutableMap.builder().put((Object)"capability.featuresSupported.healthCheckCapability.teamingSupported", (Object)"capability.featuresSupported.healthCheckCapability[@type='VMwareDVSHealthCheckCapability'].teamingSupported").put((Object)"capability.featuresSupported.healthCheckCapability.vlanMtuSupported", (Object)"capability.featuresSupported.healthCheckCapability[@type='VMwareDVSHealthCheckCapability'].vlanMtuSupported").put((Object)"capability.featuresSupported.ipfixCapability", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].ipfixCapability").put((Object)"capability.featuresSupported.ipfixSupported", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].ipfixSupported").put((Object)"capability.featuresSupported.lacpCapability", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].lacpCapability").put((Object)"capability.featuresSupported.lacpCapability.lacpSupported", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].lacpCapability.lacpSupported").put((Object)"capability.featuresSupported.lacpCapability.multiLacpGroupSupported", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].lacpCapability.multiLacpGroupSupported").put((Object)"capability.featuresSupported.lldpSupported", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].lldpSupported").put((Object)"capability.featuresSupported.multicastSnoopingSupported", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].multicastSnoopingSupported").put((Object)"capability.featuresSupported.vspanCapability", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].vspanCapability").put((Object)"capability.featuresSupported.vspanSupported", (Object)"capability.featuresSupported[@type='VMwareDVSFeatureCapability'].vspanSupported").put((Object)"capability.networkReservationSupported", (Object)"capability[@type='OpaqueNetworkCapability'].networkReservationSupported").put((Object)"config.defaultPortConfig.lacpPolicy.enable.value", (Object)"config.defaultPortConfig[@type='VMwareDVSPortSetting'].lacpPolicy.enable.value").put((Object)"config.defaultPortConfig.lacpPolicy.mode.value", (Object)"config.defaultPortConfig[@type='VMwareDVSPortSetting'].lacpPolicy.mode.value").put((Object)"config.defaultPortConfig.uplinkTeamingPolicy", (Object)"config.defaultPortConfig[@type='VMwareDVSPortSetting'].uplinkTeamingPolicy").put((Object)"config.defaultPortConfig.uplinkTeamingPolicy.uplinkPortOrder", (Object)"config.defaultPortConfig[@type='VMwareDVSPortSetting'].uplinkTeamingPolicy.uplinkPortOrder").put((Object)"config.defaultPortConfig.vlan", (Object)"config.defaultPortConfig[@type='VMwareDVSPortSetting'].vlan").put((Object)"config.ftInfo.secondaries", (Object)"config.ftInfo[@type='FaultTolerancePrimaryConfigInfo'].secondaries").put((Object)"config.ftInfo.primaryVM", (Object)"config.ftInfo[@type='FaultToleranceSecondaryConfigInfo'].primaryVM").put((Object)"config.policy.uplinkTeamingOverrideAllowed", (Object)"config.policy[@type='VMwareDVSPortgroupPolicy'].uplinkTeamingOverrideAllowed").put((Object)"config.applyProfile.profileVersion", (Object)"config[@type='HostProfileConfigInfo'].applyProfile.profileVersion").put((Object)"config.defaultProxySwitchMaxNumPorts", (Object)"config[@type='VMwareDVSConfigInfo'].defaultProxySwitchMaxNumPorts").put((Object)"config.lacpApiVersion", (Object)"config[@type='VMwareDVSConfigInfo'].lacpApiVersion").put((Object)"config.lacpGroupConfig", (Object)"config[@type='VMwareDVSConfigInfo'].lacpGroupConfig").put((Object)"config.linkDiscoveryProtocolConfig", (Object)"config[@type='VMwareDVSConfigInfo'].linkDiscoveryProtocolConfig").put((Object)"config.maxMtu", (Object)"config[@type='VMwareDVSConfigInfo'].maxMtu").put((Object)"config.multicastFilteringMode", (Object)"config[@type='VMwareDVSConfigInfo'].multicastFilteringMode").put((Object)"config.pvlanConfig", (Object)"config[@type='VMwareDVSConfigInfo'].pvlanConfig").put((Object)"config.vspanSession", (Object)"config[@type='VMwareDVSConfigInfo'].vspanSession").put((Object)"config.ipfixConfig", (Object)"config[@type='VMwareDVSConfigSpec'].ipfixConfig").put((Object)"config.uplinkPortPolicy.uplinkPortName", (Object)"config.uplinkPortPolicy[@type='DVSNameArrayUplinkPortPolicy'].uplinkPortName").put((Object)"configurationEx.dasConfig.admissionControlEnabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlEnabled").put((Object)"configurationEx.dasConfig.admissionControlPolicy", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy").put((Object)"configurationEx.dasConfig.admissionControlPolicy.autoComputePercentages", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy.autoComputePercentages").put((Object)"configurationEx.dasConfig.admissionControlPolicy.resourceReductionToToleratePercent", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy.resourceReductionToToleratePercent").put((Object)"configurationEx.dasConfig.admissionControlPolicy.failoverHosts", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy[@type='ClusterFailoverHostAdmissionControlPolicy'].failoverHosts").put((Object)"configurationEx.dasConfig.admissionControlPolicy.failoverLevel", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy[@type='ClusterFailoverLevelAdmissionControlPolicy'].failoverLevel").put((Object)"configurationEx.dasConfig.admissionControlPolicy.slotPolicy", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy[@type='ClusterFailoverLevelAdmissionControlPolicy'].slotPolicy").put((Object)"configurationEx.dasConfig.admissionControlPolicy.slotPolicy.cpu", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy[@type='ClusterFailoverLevelAdmissionControlPolicy'].slotPolicy[@type='ClusterFixedSizeSlotPolicy'].cpu").put((Object)"configurationEx.dasConfig.admissionControlPolicy.slotPolicy.memory", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy[@type='ClusterFailoverLevelAdmissionControlPolicy'].slotPolicy[@type='ClusterFixedSizeSlotPolicy'].memory").put((Object)"configurationEx.dasConfig.admissionControlPolicy.cpuFailoverResourcesPercent", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy[@type='ClusterFailoverResourcesAdmissionControlPolicy'].cpuFailoverResourcesPercent").put((Object)"configurationEx.dasConfig.admissionControlPolicy.memoryFailoverResourcesPercent", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.admissionControlPolicy[@type='ClusterFailoverResourcesAdmissionControlPolicy'].memoryFailoverResourcesPercent").put((Object)"configurationEx.dasConfig.defaultVmSettings", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings").put((Object)"configurationEx.dasConfig.defaultVmSettings.isolationResponse", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.isolationResponse").put((Object)"configurationEx.dasConfig.defaultVmSettings.restartPriority", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.restartPriority").put((Object)"configurationEx.dasConfig.defaultVmSettings.restartPriorityTimeout", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.restartPriorityTimeout").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmReactionOnAPDCleared", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmReactionOnAPDCleared").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmStorageProtectionForAPD", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmStorageProtectionForAPD").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmStorageProtectionForPDL", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmStorageProtectionForPDL").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmTerminateDelayForAPDSec", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmComponentProtectionSettings.vmTerminateDelayForAPDSec").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmToolsMonitoringSettings.enabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmToolsMonitoringSettings.enabled").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmToolsMonitoringSettings.failureInterval", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmToolsMonitoringSettings.failureInterval").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmToolsMonitoringSettings.maxFailures", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmToolsMonitoringSettings.maxFailures").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmToolsMonitoringSettings.maxFailureWindow", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmToolsMonitoringSettings.maxFailureWindow").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmToolsMonitoringSettings.minUpTime", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmToolsMonitoringSettings.minUpTime").put((Object)"configurationEx.dasConfig.defaultVmSettings.vmToolsMonitoringSettings.vmMonitoring", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.defaultVmSettings.vmToolsMonitoringSettings.vmMonitoring").put((Object)"configurationEx.dasConfig.enabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.enabled").put((Object)"configurationEx.dasConfig.hBDatastoreCandidatePolicy", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.hBDatastoreCandidatePolicy").put((Object)"configurationEx.dasConfig.heartbeatDatastore", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.heartbeatDatastore").put((Object)"configurationEx.dasConfig.hostMonitoring", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.hostMonitoring").put((Object)"configurationEx.dasConfig.option", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.option").put((Object)"configurationEx.dasConfig.vmComponentProtecting", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.vmComponentProtecting").put((Object)"configurationEx.dasConfig.vmMonitoring", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasConfig.vmMonitoring").put((Object)"configurationEx.dasVmConfig", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasVmConfig").put((Object)"configurationEx.dasVmConfig.key", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dasVmConfig.key").put((Object)"configurationEx.dpmConfigInfo.defaultDpmBehavior", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dpmConfigInfo.defaultDpmBehavior").put((Object)"configurationEx.dpmConfigInfo.enabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dpmConfigInfo.enabled").put((Object)"configurationEx.dpmConfigInfo.hostPowerActionRate", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dpmConfigInfo.hostPowerActionRate").put((Object)"configurationEx.dpmHostConfig", (Object)"configurationEx[@type='ClusterConfigInfoEx'].dpmHostConfig").put((Object)"configurationEx.drsConfig.defaultVmBehavior", (Object)"configurationEx[@type='ClusterConfigInfoEx'].drsConfig.defaultVmBehavior").put((Object)"configurationEx.drsConfig.enabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].drsConfig.enabled").put((Object)"configurationEx.drsConfig.enableVmBehaviorOverrides", (Object)"configurationEx[@type='ClusterConfigInfoEx'].drsConfig.enableVmBehaviorOverrides").put((Object)"configurationEx.drsConfig.option", (Object)"configurationEx[@type='ClusterConfigInfoEx'].drsConfig.option").put((Object)"configurationEx.drsConfig.vmotionRate", (Object)"configurationEx[@type='ClusterConfigInfoEx'].drsConfig.vmotionRate").put((Object)"configurationEx.drsVmConfig", (Object)"configurationEx[@type='ClusterConfigInfoEx'].drsVmConfig").put((Object)"configurationEx.drsVmConfig.key", (Object)"configurationEx[@type='ClusterConfigInfoEx'].drsVmConfig.key").put((Object)"configurationEx.group", (Object)"configurationEx[@type='ClusterConfigInfoEx'].group").put((Object)"configurationEx.infraUpdateHaConfig.behavior", (Object)"configurationEx[@type='ClusterConfigInfoEx'].infraUpdateHaConfig.behavior").put((Object)"configurationEx.infraUpdateHaConfig.enabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].infraUpdateHaConfig.enabled").put((Object)"configurationEx.infraUpdateHaConfig.moderateRemediation", (Object)"configurationEx[@type='ClusterConfigInfoEx'].infraUpdateHaConfig.moderateRemediation").put((Object)"configurationEx.infraUpdateHaConfig.providers", (Object)"configurationEx[@type='ClusterConfigInfoEx'].infraUpdateHaConfig.providers").put((Object)"configurationEx.infraUpdateHaConfig.severeRemediation", (Object)"configurationEx[@type='ClusterConfigInfoEx'].infraUpdateHaConfig.severeRemediation").put((Object)"configurationEx.orchestration.defaultVmReadiness.postReadyDelay", (Object)"configurationEx[@type='ClusterConfigInfoEx'].orchestration.defaultVmReadiness.postReadyDelay").put((Object)"configurationEx.orchestration.defaultVmReadiness.readyCondition", (Object)"configurationEx[@type='ClusterConfigInfoEx'].orchestration.defaultVmReadiness.readyCondition").put((Object)"configurationEx.proactiveDrsConfig.enabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].proactiveDrsConfig.enabled").put((Object)"configurationEx.rule", (Object)"configurationEx[@type='ClusterConfigInfoEx'].rule").put((Object)"configurationEx.vmOrchestration", (Object)"configurationEx[@type='ClusterConfigInfoEx'].vmOrchestration").put((Object)"configurationEx.vmSwapPlacement", (Object)"configurationEx[@type='ClusterConfigInfoEx'].vmSwapPlacement").put((Object)"configurationEx.vsanConfigInfo.enabled", (Object)"configurationEx[@type='ClusterConfigInfoEx'].vsanConfigInfo.enabled").put((Object)"info.nas.remoteHost", (Object)"info[@type='NasDatastoreInfo'].nas.remoteHost").put((Object)"info.nas.remoteHostNames", (Object)"info[@type='NasDatastoreInfo'].nas.remoteHostNames").put((Object)"info.nas.remotePath", (Object)"info[@type='NasDatastoreInfo'].nas.remotePath").put((Object)"info.nas.type", (Object)"info[@type='NasDatastoreInfo'].nas.type").put((Object)"info.vmfs.uuid", (Object)"info[@type='VmfsDatastoreInfo'].vmfs.uuid").put((Object)"info.vvolDS", (Object)"info[@type='VvolDatastoreInfo'].vvolDS").put((Object)"summary.admissionControlInfo.currentCpuFailoverResourcesPercent", (Object)"summary.admissionControlInfo[@type='ClusterFailoverResourcesAdmissionControlInfo'].currentCpuFailoverResourcesPercent").put((Object)"summary.admissionControlInfo.currentMemoryFailoverResourcesPercent", (Object)"summary.admissionControlInfo[@type='ClusterFailoverResourcesAdmissionControlInfo'].currentMemoryFailoverResourcesPercent").put((Object)"summary.admissionControlInfo.currentFailoverLevel", (Object)"summary[@type='ClusterComputeResourceSummary'].admissionControlInfo[@type='ClusterFailoverLevelAdmissionControlInfo'].currentFailoverLevel").put((Object)"summary.currentEVCModeKey", (Object)"summary[@type='ClusterComputeResourceSummary'].currentEVCModeKey").put((Object)"summary.numEffectiveHosts", (Object)"summary[@type='ClusterComputeResourceSummary'].numEffectiveHosts").put((Object)"summary.numVmotions", (Object)"summary[@type='ClusterComputeResourceSummary'].numVmotions").put((Object)"summary.usageSummary.totalCpuCapacityMhz", (Object)"summary[@type='ClusterComputeResourceSummary'].usageSummary.totalCpuCapacityMhz").put((Object)"summary.usageSummary.totalMemCapacityMB", (Object)"summary[@type='ClusterComputeResourceSummary'].usageSummary.totalMemCapacityMB").put((Object)"summary.currentBalance", (Object)"summary[@type='ClusterComputeResourceSummary'].currentBalance").put((Object)"summary.targetBalance", (Object)"summary[@type='ClusterComputeResourceSummary'].targetBalance").put((Object)"summary.opaqueNetworkId", (Object)"summary[@type='OpaqueNetworkSummary'].opaqueNetworkId").put((Object)"summary.opaqueNetworkType", (Object)"summary[@type='OpaqueNetworkSummary'].opaqueNetworkType").build();
    }
}

