/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.adapters.risetovise.RiseToViseProperty;
import java.util.ArrayList;
import java.util.List;

final class RiseToViseSelectClause {
    private static final String ANY_NETWORK = "AnyNetwork";
    private static final String[] ANY_NETWORK_CHILD_MODELS = new String[]{"Network", "OpaqueNetwork", "DistributedVirtualPortgroup"};
    private static final String HOST_NETWORK = "HostNetwork";
    private static final String[] HOST_NETWORK_CHILD_MODELS = new String[]{"Network", "OpaqueNetwork"};
    private static final PropertySpec[] EMPTY_PROPERTY_SPEC = new PropertySpec[0];
    private final RiseToViseProperty _propertyConverter;

    public RiseToViseSelectClause(RiseToViseProperty riseToViseProperty) {
        assert (riseToViseProperty != null);
        this._propertyConverter = riseToViseProperty;
    }

    public PropertySpec[] toPropertySpecs(List<String> list, String string, ParameterSpec[] parameterSpecArray) {
        assert (list != null);
        if (list.isEmpty()) {
            return EMPTY_PROPERTY_SPEC;
        }
        if (ANY_NETWORK.equals(string)) {
            return this.aggregatedNetworkSpec(list, string, parameterSpecArray, ANY_NETWORK_CHILD_MODELS);
        }
        if (HOST_NETWORK.equals(string)) {
            return this.aggregatedNetworkSpec(list, string, parameterSpecArray, HOST_NETWORK_CHILD_MODELS);
        }
        return this.genericSpec(list, string, parameterSpecArray);
    }

    private PropertySpec[] aggregatedNetworkSpec(List<String> list, String string, ParameterSpec[] parameterSpecArray, String[] stringArray) {
        assert (list != null);
        assert (string != null);
        assert (stringArray != null);
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>(stringArray.length);
        for (String string2 : stringArray) {
            List<String> list2 = RiseToViseSelectClause.replaceModel(list, string, string2);
            List<String> list3 = this.toViseProperties(list2);
            if (list3.isEmpty()) continue;
            PropertySpec propertySpec = RiseToViseSelectClause.newPropertySpec(string2, parameterSpecArray, list3);
            arrayList.add(propertySpec);
        }
        if (arrayList.isEmpty()) {
            return EMPTY_PROPERTY_SPEC;
        }
        return arrayList.toArray(new PropertySpec[arrayList.size()]);
    }

    private PropertySpec[] genericSpec(List<String> list, String string, ParameterSpec[] parameterSpecArray) {
        List<String> list2 = this.toViseProperties(list);
        if (list2.isEmpty()) {
            return EMPTY_PROPERTY_SPEC;
        }
        PropertySpec propertySpec = RiseToViseSelectClause.newPropertySpec(string, parameterSpecArray, list2);
        return new PropertySpec[]{propertySpec};
    }

    private static PropertySpec newPropertySpec(String string, ParameterSpec[] parameterSpecArray, List<String> list) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.type = string;
        propertySpec.propertyNames = list.toArray(new String[list.size()]);
        propertySpec.parameters = parameterSpecArray;
        return propertySpec;
    }

    private List<String> toViseProperties(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            if ("@modelKey".equals(string) || "@type".equals(string)) continue;
            String string2 = this.toViseProperty(string);
            arrayList.add(string2);
        }
        return arrayList;
    }

    private static List<String> replaceModel(List<String> list, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string3 : list) {
            arrayList.add(string3.replace(string, string2));
        }
        return arrayList;
    }

    private String toViseProperty(String string) {
        return this._propertyConverter.toViseProperty(string);
    }
}

