/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.adapters.risetovise;

import com.google.common.collect.ImmutableMap;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.util.QueryMarker;
import com.vmware.cis.data.provider.DataProvider;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.adapters.core.translator.StaticResourceModelResolver;
import com.vmware.vise.data.adapters.risetovise.RiseToViseFromClause;
import com.vmware.vise.data.adapters.risetovise.RiseToViseOrderByClause;
import com.vmware.vise.data.adapters.risetovise.RiseToViseParameters;
import com.vmware.vise.data.adapters.risetovise.RiseToViseProperty;
import com.vmware.vise.data.adapters.risetovise.RiseToViseResult;
import com.vmware.vise.data.adapters.risetovise.RiseToViseSelectClause;
import com.vmware.vise.data.adapters.risetovise.RiseToViseWhereClause;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QueryOption;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

public final class ViseDsBasedDataProvider
implements DataProvider {
    private static final Map<String, Object> QUERY_OPTIONS = new ImmutableMap.Builder().put((Object)QueryOption.VISE_TO_RISE_TRANSLATOR_STRICT_MODE.name(), (Object)true).build();
    private final DataService _viseDataService;
    private final RiseToViseProperty _propertyConverter;
    private final RiseToViseSelectClause _selectClause;
    private final RiseToViseFromClause _fromClause;
    private final RiseToViseWhereClause _whereClause;
    private final RiseToViseOrderByClause _orderByClause;
    private final RiseToViseResult _resultConverter;

    public ViseDsBasedDataProvider(DataService dataService, ObjectReferenceService objectReferenceService) {
        Validate.notNull((Object)dataService);
        Validate.notNull((Object)objectReferenceService);
        this._viseDataService = dataService;
        this._propertyConverter = new RiseToViseProperty();
        this._selectClause = new RiseToViseSelectClause(this._propertyConverter);
        this._fromClause = new RiseToViseFromClause(new StaticResourceModelResolver());
        this._whereClause = new RiseToViseWhereClause(objectReferenceService, this._propertyConverter);
        this._orderByClause = new RiseToViseOrderByClause(this._propertyConverter);
        this._resultConverter = new RiseToViseResult(objectReferenceService, this._propertyConverter);
    }

    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query, (String)"Query is required");
        String string = this._fromClause.getResourceType(query);
        QuerySpec querySpec = this.toViseQuery(query, string);
        com.vmware.vise.data.query.ResultSet resultSet = this.getData(querySpec);
        return this._resultConverter.fromViseResult(resultSet, query);
    }

    public QuerySchema getSchema() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private QuerySpec toViseQuery(Query query, String string) {
        assert (query != null);
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = this.toResourceSpec(query, string);
        querySpec.resultSpec = this._orderByClause.toResultSpec(query, string);
        querySpec.options = QUERY_OPTIONS;
        querySpec.name = QueryMarker.getQueryId();
        return querySpec;
    }

    private ResourceSpec toResourceSpec(Query query, String string) {
        assert (query != null);
        RiseToViseParameters riseToViseParameters = RiseToViseParameters.forQuery(query, this._propertyConverter);
        Query query2 = riseToViseParameters.getQueryWithoutParameters();
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = this._whereClause.toConstraint(query2, string);
        resourceSpec.propertySpecs = this._selectClause.toPropertySpecs(query2.getProperties(), string, riseToViseParameters.getParameters());
        return resourceSpec;
    }

    private com.vmware.vise.data.query.ResultSet getData(QuerySpec querySpec) {
        Response response;
        assert (querySpec != null);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        try {
            response = this._viseDataService.getData(requestSpec);
        }
        catch (Exception exception) {
            throw ViseDsBasedDataProvider.toRuntimeException(exception);
        }
        if (ArrayUtils.isEmpty((Object[])response.resultSet)) {
            return null;
        }
        assert (response.resultSet.length == 1);
        return response.resultSet[0];
    }

    private static RuntimeException toRuntimeException(Exception exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }
}

