/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.common;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.traverser.ConstraintNoResultTraverser;
import com.vmware.vise.search.model.ModelUtils;
import java.util.HashSet;
import java.util.Set;

public class ResourceAndModelNameResolver
extends ConstraintNoResultTraverser {
    private Set<String> _names;
    private ObjectReferenceService _objectReferenceService;

    public ResourceAndModelNameResolver(ObjectReferenceService objectReferenceService) {
        this._objectReferenceService = objectReferenceService;
    }

    public Set<String> resolve(Constraint constraint) {
        this._names = new HashSet<String>();
        this.traverseConstraint(constraint);
        return this._names;
    }

    protected void traverseObjectIdentityConstraint(ObjectIdentityConstraint objectIdentityConstraint) {
        String string = this._objectReferenceService.getResourceObjectType(objectIdentityConstraint.target);
        if (string != null) {
            this._names.add(string);
        }
    }

    protected void traversePropertyConstraint(PropertyConstraint propertyConstraint) {
        if (propertyConstraint.targetType != null) {
            this._names.add(propertyConstraint.targetType);
        }
        if (propertyConstraint.propertyName != null && ModelUtils.isQualifiedWithResourceModel((String)propertyConstraint.propertyName)) {
            this._names.add(ModelUtils.getResourceModel((String)propertyConstraint.propertyName));
        }
    }

    protected void traverseRelationalConstraint(RelationalConstraint relationalConstraint) {
        if (relationalConstraint.targetType != null) {
            this._names.add(relationalConstraint.targetType);
        }
        if (relationalConstraint.relation != null && ModelUtils.isQualifiedWithResourceModel((String)relationalConstraint.relation)) {
            this._names.add(ModelUtils.getResourceModel((String)relationalConstraint.relation));
        }
        super.traverseRelationalConstraint(relationalConstraint);
    }

    protected void traverseCompositeConstraint(CompositeConstraint compositeConstraint) {
        if (compositeConstraint.targetType != null) {
            this._names.add(compositeConstraint.targetType);
        }
        super.traverseCompositeConstraint(compositeConstraint);
    }
}

