/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.impl.DataServiceExtensionRegistryInternal;
import com.vmware.vise.data.query.impl.ObjectReferenceServiceImpl;
import com.vmware.vise.data.query.internal.DataServiceExtensionRegistryFactory;
import com.vmware.vise.data.uri.DefaultUriSchemeResolver;
import com.vmware.vise.data.uri.InventoryServiceResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.data.uri.UriRefTypeAdapter;
import com.vmware.vise.search.SearchService;
import com.vmware.vise.search.transport.QueryServiceIndex;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.vim.data.adapters.search.QueryRequest;
import com.vmware.vise.vim.data.adapters.search.QueryResult;
import com.vmware.vise.vim.data.adapters.search.impl.MorRefTypeAdapter;
import com.vmware.vise.vim.data.adapters.search.impl.QueryExecutor;
import com.vmware.vise.vim.data.adapters.search.impl.QueryRequestTransformer;
import com.vmware.vise.vim.data.adapters.search.impl.QueryResultTransformer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class VimSearchService {
    private final SearchService _searchService;
    private final QueryRequestTransformer _queryRequestTransformer;
    private final QueryResultTransformer _queryResultTransformer;
    private final ExecutorService _serenityThreadPool;
    private final QueryExecutor _queryExecutor;

    public VimSearchService(SearchService searchService, QueryServiceIndex queryServiceIndex) {
        DataServiceExtensionRegistryInternal dataServiceExtensionRegistryInternal = (DataServiceExtensionRegistryInternal)DataServiceExtensionRegistryFactory.createDataServiceExtensionRegistry((boolean)true);
        UriRefTypeAdapter uriRefTypeAdapter = UriRefTypeAdapter.getUriRefTypeAdapter((DataServiceExtensionRegistry)dataServiceExtensionRegistryInternal);
        this.setUpDataServiceRegistry((DataServiceExtensionRegistry)dataServiceExtensionRegistryInternal, uriRefTypeAdapter);
        this._searchService = searchService;
        ObjectReferenceServiceImpl objectReferenceServiceImpl = new ObjectReferenceServiceImpl(dataServiceExtensionRegistryInternal);
        this._queryRequestTransformer = new QueryRequestTransformer(this._searchService, (ObjectReferenceService)objectReferenceServiceImpl);
        this._queryResultTransformer = new QueryResultTransformer();
        this._serenityThreadPool = Executors.newCachedThreadPool((ThreadFactory)new WorkerThreadFactory("vim-search-pool"));
        this._queryExecutor = new QueryExecutor(this._searchService, this._serenityThreadPool, queryServiceIndex);
    }

    public ResultSet[] getData(QuerySpec[] querySpecArray) {
        QueryRequest[] queryRequestArray = this.toQueryBatch(querySpecArray);
        if (queryRequestArray.length == 0) {
            return null;
        }
        QueryResult[] queryResultArray = this._queryExecutor.execute(queryRequestArray);
        ResultSet[] resultSetArray = this.toResultSet(queryResultArray);
        return resultSetArray;
    }

    public SearchService getSearchService() {
        return this._searchService;
    }

    public QueryExecutor getQueryExecutor() {
        return this._queryExecutor;
    }

    private ResultSet[] toResultSet(QueryResult[] queryResultArray) {
        ResultSet[] resultSetArray = new ResultSet[queryResultArray.length];
        int n = 0;
        for (QueryResult queryResult : queryResultArray) {
            DynamicProviderResultSet dynamicProviderResultSet = this._queryResultTransformer.toResultSet(queryResult);
            resultSetArray[n++] = dynamicProviderResultSet;
        }
        return resultSetArray;
    }

    private QueryRequest[] toQueryBatch(QuerySpec[] querySpecArray) {
        QueryRequest[] queryRequestArray = new QueryRequest[querySpecArray.length];
        int n = 0;
        for (QuerySpec querySpec : querySpecArray) {
            QueryRequest queryRequest = this._queryRequestTransformer.toQueryRequest(querySpec);
            queryRequestArray[n++] = queryRequest;
        }
        return queryRequestArray;
    }

    private void setUpDataServiceRegistry(DataServiceExtensionRegistry dataServiceExtensionRegistry, UriRefTypeAdapter uriRefTypeAdapter) {
        assert (dataServiceExtensionRegistry != null);
        assert (uriRefTypeAdapter != null);
        DefaultUriSchemeResolver defaultUriSchemeResolver = DefaultUriSchemeResolver.getDefaultUriSchemeResolver((ResourceTypeResolverRegistry)uriRefTypeAdapter);
        InventoryServiceResourceTypeResolver inventoryServiceResourceTypeResolver = InventoryServiceResourceTypeResolver.getResolver((ResourceTypeResolverRegistry)uriRefTypeAdapter);
        dataServiceExtensionRegistry.registerObjectRefTypeAdapter((ResourceObjectReferenceAdapter)new MorRefTypeAdapter(), ManagedObjectReference.class, "urn:vmomi");
    }
}

