/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.search.transport.QueryService;
import com.vmware.vise.search.transport.QueryServiceFactory;
import com.vmware.vise.search.transport.QueryServiceIndex;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceDirectory;
import com.vmware.vise.vim.commons.vcservice.impl.LinkedVcGroupImpl;
import com.vmware.vise.vim.commons.vmomi.vc.VcAwareSharedHttpConfigPool;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class LinkedVcQueryServiceIndexImpl
implements QueryServiceIndex,
VcServiceDirectory {
    private final LoginSpec _loginSpec;
    private final LinkedVcGroup _linkedVcGroup;
    private final List<QueryService> _queryServices;

    public LinkedVcQueryServiceIndexImpl(VcAwareSharedHttpConfigPool vcAwareSharedHttpConfigPool, LoginSpec loginSpec) throws Exception {
        this._loginSpec = loginSpec;
        this._linkedVcGroup = LinkedVcQueryServiceIndexImpl.createLinkedVcGroup(this._loginSpec);
        QueryService queryService = new QueryServiceFactory().newQueryService(this._linkedVcGroup, vcAwareSharedHttpConfigPool, null);
        this._queryServices = Collections.singletonList(queryService);
    }

    public List<QueryService> getDefaultQueryServices() {
        return this._queryServices;
    }

    public List<QueryService> getQueryServices(String string) {
        return this._queryServices;
    }

    private static LinkedVcGroup createLinkedVcGroup(LoginSpec loginSpec) throws Exception {
        if (StringUtil.isNullOrEmpty((String)loginSpec.thumbprint)) {
            loginSpec.ignoreSslThumbprint = true;
        }
        LinkedVcGroupImpl linkedVcGroupImpl = new LinkedVcGroupImpl(loginSpec);
        linkedVcGroupImpl.login();
        return linkedVcGroupImpl;
    }

    public void registerExtension(String string, String string2) {
    }

    public void unregisterExtension(String string, String string2) {
    }

    public void unregisterExtension(String string) {
    }

    public Set<String> findVcGuidsByServiceGuid(String string) {
        VcService vcService = this._linkedVcGroup.getVcService(string);
        if (vcService != null) {
            String string2 = vcService.getServiceGuid();
            return Collections.singleton(string2);
        }
        return Collections.emptySet();
    }
}

