/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.cis.data.internal.adapters.federation.VersionAnalyzer;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vim.fault.NotAuthenticated;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.binding.vmodl.query.InvalidProperty;
import com.vmware.vim.binding.vmodl.query.PropertyCollector;
import com.vmware.vim.vmomi.core.types.DataObjectType;
import com.vmware.vim.vmomi.core.types.ManagedObjectType;
import com.vmware.vim.vmomi.core.types.VmodlField;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResourceObjectReferenceAdapter;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.search.SearchServiceExtensionRegistry;
import com.vmware.vise.search.metadata.DescriptorSource;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.profiling.ExecutionProfiler;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.security.NotAuthenticatedError;
import com.vmware.vise.vim.commons.vcservice.PeerVcConnectionError;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.impl.VcServiceImpl;
import com.vmware.vise.vim.data.adapters.search.impl.MorRefTypeAdapter;
import com.vmware.vise.vim.data.adapters.search.impl.Utils;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PropertyCollectorDataAdapter
implements DataProviderAdapter,
PropertyProviderAdapter {
    private static final Logger _logger = LoggerFactory.getLogger(PropertyCollectorDataAdapter.class);
    private static final int BATCH_SIZE = 250;
    private static final PropertyCollector.RetrieveOptions RETRIEVE_OPTIONS = new PropertyCollector.RetrieveOptions();
    private static final String PROPERTY_PATH_TYPE = "[@type='";
    private static final String NAME_PROPERTY = "name";
    private static final String CONFIG_NAME_PROPERTY = "config.name";
    public static final String STATUS_UNSUPPORTED = "unsupported";
    public static final String TAG_UNSUPPORTED_VERSION = "unsupportedVersion";
    private final DataServiceExtensionRegistry _extensionRegistry;
    private final List<TypeInfo> _adapterTypes;
    private final List<TypeInfo> _providerProperties;
    private final Map<String, TypeInfo> _typeByTypeName;

    public PropertyCollectorDataAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, SearchServiceExtensionRegistry searchServiceExtensionRegistry, String string) {
        InputStream inputStream;
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataServiceExtensionRegistry, searchServiceExtensionRegistry, string});
        this._extensionRegistry = dataServiceExtensionRegistry;
        ClassLoader classLoader = PropertyCollectorDataAdapter.class.getClassLoader();
        Document document = null;
        try {
            inputStream = classLoader.getResourceAsStream(string);
            document = XMLUtil.loadXmlFile((InputStream)inputStream);
        }
        catch (Exception exception) {
            _logger.error("Error loading search-metadata.xml file, location: {}", (Object)string, (Object)exception);
            throw new IllegalStateException("Could not load search-metadata.xml file.");
        }
        inputStream = null;
        DescriptorSource descriptorSource = MetadataUtil.getDescriptorSource((String)((Object)inputStream), (Document)document, (ClassLoader)classLoader);
        List<TypeInfo> list = Utils.getAdapterTypes(descriptorSource.getTypes());
        this._adapterTypes = Collections.unmodifiableList(list);
        List<TypeInfo> list2 = Utils.getProviderTypes(descriptorSource.getProperties());
        this._providerProperties = Collections.unmodifiableList(list2);
        Map<String, TypeInfo> map = PropertyCollectorDataAdapter.initializeTypes(list, list2);
        this._typeByTypeName = Collections.unmodifiableMap(map);
    }

    public void initialize() {
        ValidationUtil.paramsNotNull((Object[])new Object[0]);
        this._extensionRegistry.registerObjectRefTypeAdapter((ResourceObjectReferenceAdapter)new MorRefTypeAdapter(), ManagedObjectReference.class, "urn:vmomi");
        ArrayList<String> arrayList = new ArrayList<String>(this._typeByTypeName.size());
        for (TypeInfo typeInfo : this._adapterTypes) {
            arrayList.add(typeInfo.type);
        }
        this._extensionRegistry.registerDataAdapter((DataProviderAdapter)this, arrayList.toArray(new String[0]));
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this._providerProperties.toArray(new TypeInfo[0]));
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.processQuery(querySpecArray[i]);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        ResultSet resultSet = null;
        try {
            resultSet = this.getResultSet(objectArray, propertySpecArray, null, true);
            if (resultSet != null) {
                resultSet.totalMatchedObjectCount = 0;
            }
        }
        catch (Exception exception) {
            _logger.error("Error getting propertySet from PropertyCollector", (Throwable)exception);
            resultSet = new ResultSet();
            resultSet.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return resultSet;
    }

    private static Map<String, TypeInfo> initializeTypes(List<TypeInfo> list, List<TypeInfo> list2) {
        TypeInfo typeInfo;
        assert (list != null);
        assert (list2 != null);
        HashMap<String, TypeInfo> hashMap = new HashMap<String, TypeInfo>();
        for (TypeInfo typeInfo2 : list) {
            typeInfo = hashMap.put(typeInfo2.type, typeInfo2);
            if (typeInfo == null) continue;
            _logger.warn("Overriding type definition for " + typeInfo2.type);
        }
        for (TypeInfo typeInfo2 : list2) {
            typeInfo = hashMap.put(typeInfo2.type, typeInfo2);
            if (typeInfo == null) continue;
            _logger.warn("Overriding type definition for " + typeInfo2.type);
        }
        return hashMap;
    }

    private VmodlVersion getVmodlVersion(VcService vcService) {
        if (!(vcService instanceof VcServiceImpl)) {
            return null;
        }
        VcServiceImpl vcServiceImpl = (VcServiceImpl)vcService;
        VmodlVersionMap vmodlVersionMap = VmodlVersionMap.Factory.getVmodlVersionMap();
        Class clazz = vcServiceImpl.getVmodlVersion();
        if (clazz == null) {
            return null;
        }
        return vmodlVersionMap.getVersion(clazz);
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        ResultSet resultSet;
        PropertySpec[] propertySpecArray;
        ResourceSpec resourceSpec = querySpec.resourceSpec;
        if (resourceSpec == null) {
            return null;
        }
        Constraint constraint = resourceSpec.constraint;
        if (!(constraint instanceof RelationalConstraint || constraint instanceof ObjectIdentityConstraint || constraint instanceof CompositeConstraint)) {
            return null;
        }
        Object[] objectArray = null;
        RelationInfo[] relationInfoArray = null;
        RelationInfo relationInfo = null;
        if (constraint instanceof RelationalConstraint) {
            propertySpecArray = (PropertySpec[])constraint;
            relationInfo = this.constructRelationInfo((RelationalConstraint)propertySpecArray);
            _logger.debug("Processing RelationalConstraint, relation is " + relationInfo.relations + " and target type is " + relationInfo.targetType);
            relationInfoArray = new RelationInfo[]{relationInfo};
            objectArray = com.vmware.vise.data.query.impl.Utils.getEnumeratedObjects((RelationalConstraint)propertySpecArray);
        } else if (this.isCompatibleCompositeConstraint(constraint)) {
            propertySpecArray = (CompositeConstraint)constraint;
            relationInfoArray = new RelationInfo[propertySpecArray.nestedConstraints.length];
            resultSet = new HashSet();
            for (int i = 0; i < propertySpecArray.nestedConstraints.length; ++i) {
                RelationalConstraint relationalConstraint = (RelationalConstraint)propertySpecArray.nestedConstraints[i];
                relationInfo = this.constructRelationInfo(relationalConstraint);
                _logger.debug("Processing RelationalConstraint, relation is " + relationInfo.relations + " and target type is " + relationInfo.targetType);
                relationInfoArray[i] = relationInfo;
                Object[] objectArray2 = com.vmware.vise.data.query.impl.Utils.getEnumeratedObjects((RelationalConstraint)relationalConstraint);
                Collections.addAll(resultSet, objectArray2);
            }
            if (!resultSet.isEmpty()) {
                objectArray = resultSet.toArray();
            }
        } else {
            objectArray = com.vmware.vise.data.query.impl.Utils.getEnumeratedObjects((QuerySpec)querySpec);
        }
        propertySpecArray = null;
        if (resourceSpec.propertySpecs != null) {
            propertySpecArray = resourceSpec.propertySpecs;
        }
        resultSet = null;
        try {
            resultSet = this.getResultSet(objectArray, propertySpecArray, relationInfoArray, false);
        }
        catch (Exception exception) {
            _logger.error("Error getting data from PropertyCollector for QS: " + querySpec.name, (Throwable)exception);
            resultSet = new ResultSet();
            resultSet.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        if (resultSet != null) {
            resultSet.queryName = querySpec.name;
        }
        ResultUtil.sortResult((ResultSet)resultSet, (ResultSpec)querySpec.resultSpec);
        ResultUtil.pageResult((ResultSet)resultSet, (ResultSpec)querySpec.resultSpec);
        _logger.debug("Processed query spec " + querySpec.name);
        return resultSet;
    }

    private boolean isCompatibleCompositeConstraint(Constraint constraint) {
        if (!(constraint instanceof CompositeConstraint)) {
            return false;
        }
        CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
        if (!this.isCompositeRelationalConstraint(compositeConstraint)) {
            _logger.debug("PropertyCollectorDataAdapter was supplied with a composite constraint it could not handle");
            return false;
        }
        if (!compositeConstraint.conjoiner.equals((Object)Conjoiner.OR)) {
            _logger.debug("PropertyCollectorDataAdapter was supplied with a composite constraint with a conjoiner it could not handle");
            return false;
        }
        return true;
    }

    private ResultSet getResultSet(Object[] objectArray, PropertySpec[] propertySpecArray, RelationInfo[] filterSpec, boolean bl) throws Exception {
        MixedUtil.throwIfSessionNotAuthenticated();
        if (objectArray == null || objectArray.length == 0 || propertySpecArray == null || propertySpecArray.length == 0) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<PropertyCollector.FilterSpec> arrayList = new ArrayList<PropertyCollector.FilterSpec>();
        ArrayList<Exception> arrayList2 = new ArrayList<Exception>();
        HashMap<String, ArrayList<ManagedObjectReference>> hashMap = this.createObjectMapByServerGuid(objectArray);
        for (String string : hashMap.keySet()) {
            String string2;
            String string3;
            try {
                PropertyCollector.FilterSpec filterSpec2;
                VcService vcService = PropertyCollectorDataAdapter.getVcService(string);
                string3 = vcService.getServiceVersion();
                if (bl && !VersionAnalyzer.isVersionBeforeRise((String)string3)) {
                    PropertyCollectorDataAdapter.logSkippedPropertiesInDebug(propertySpecArray, vcService);
                    continue;
                }
                string2 = this.createPropertyCollectorStub(vcService);
                ArrayList<ManagedObjectReference> arrayList3 = hashMap.get(string);
                ArrayList<PropertyCollector.FilterSpec> arrayList4 = new ArrayList<PropertyCollector.FilterSpec>();
                for (ManagedObjectReference managedObjectReference : arrayList3) {
                    if (filterSpec != null) {
                        for (PropertyCollector.FilterSpec filterSpec3 : filterSpec) {
                            PropertyCollector.FilterSpec filterSpec4 = this.createFilterSpec(managedObjectReference, propertySpecArray, (RelationInfo)filterSpec3, filterSpec3.targetType);
                            if (filterSpec4 == null) continue;
                            arrayList4.add(filterSpec4);
                        }
                        continue;
                    }
                    filterSpec2 = this.createFilterSpec(managedObjectReference, propertySpecArray, null, null);
                    arrayList4.add(filterSpec2);
                }
                if (ArrayUtil.isNullOrEmpty(arrayList4)) continue;
                List<ResultItem> list = this.tryToRetrieveContentsAndReloginIfNotAuthenticated((PropertyCollector)string2, arrayList4.toArray(new PropertyCollector.FilterSpec[arrayList4.size()]), arrayList2, propertySpecArray, string);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    filterSpec2 = (ResultItem)iterator.next();
                    arrayList.add(filterSpec2);
                }
            }
            catch (InvalidProperty invalidProperty) {
                _logger.error("Invalid Property " + invalidProperty.getName(), (Throwable)invalidProperty);
                arrayList2.add((Exception)MixedUtil.getMethodFault((Throwable)invalidProperty));
            }
            catch (NotAuthenticatedError notAuthenticatedError) {
                _logger.info("Not authenticated to PC. Probably due to concurrent logout.");
                arrayList2.add((Exception)MixedUtil.getMethodFault((Throwable)notAuthenticatedError));
            }
            catch (ManagedObjectNotFound managedObjectNotFound) {
                _logger.debug("Property collector unable to find object", (Throwable)managedObjectNotFound);
            }
            catch (Exception exception) {
                string3 = SessionUtil.getHashedClientId();
                string2 = SessionUtil.getHashedSessionId();
                _logger.error(String.format("Error when fetching data from PC for clientId %1s for session %2s", string3, string2), (Throwable)exception);
                arrayList2.add((Exception)MixedUtil.getMethodFault((Throwable)exception));
            }
        }
        if (arrayList2.size() > 0) {
            resultSet.error = new CompositeException(arrayList2);
        }
        resultSet.items = arrayList.toArray(new ResultItem[0]);
        resultSet.totalMatchedObjectCount = resultSet.items.length;
        return resultSet;
    }

    private static void logSkippedPropertiesInDebug(PropertySpec[] propertySpecArray, VcService vcService) {
        assert (propertySpecArray != null);
        assert (vcService != null);
        if (_logger.isDebugEnabled()) {
            _logger.debug("The properties '{}' should be already handled natively by the RISE Data Adapter for VcService [url='{}', guid='{}', version='{}']", new Object[]{Arrays.toString(propertySpecArray), vcService.getServiceUrl(), vcService.getServiceGuid(), vcService.getServiceVersion()});
        }
    }

    private HashMap<String, ArrayList<ManagedObjectReference>> createObjectMapByServerGuid(Object[] objectArray) {
        HashMap<String, ArrayList<ManagedObjectReference>> hashMap = new HashMap<String, ArrayList<ManagedObjectReference>>();
        String string = null;
        for (Object object : objectArray) {
            if (!this.isObjectSupported(object).booleanValue()) continue;
            string = ((ManagedObjectReference)object).getServerGuid();
            ArrayList<Object> arrayList = hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                hashMap.put(string, arrayList);
            }
            arrayList.add((ManagedObjectReference)object);
        }
        return hashMap;
    }

    private static VcService getVcService(String string) {
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            String string2 = string;
            ServiceDirectory.ServiceEndpoint serviceEndpoint = VcServiceUtil.getServiceEndpoint((String)string);
            if (serviceEndpoint != null) {
                string2 = serviceEndpoint.getUrl();
            } else {
                _logger.warn("Service endpoint is null for: " + string);
            }
            throw new PeerVcConnectionError(string2, null);
        }
        return vcService;
    }

    private PropertyCollector createPropertyCollectorStub(VcService vcService) throws Exception {
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        final PropertyCollector propertyCollector = (PropertyCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.propertyCollector);
        assert (propertyCollector != null);
        PropertyCollector propertyCollector2 = (PropertyCollector)Proxy.newProxyInstance(PropertyCollector.class.getClassLoader(), new Class[]{PropertyCollector.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                if (Thread.currentThread().isInterrupted()) {
                    throw new CancellationException(String.format("Call to %s was cancelled.", PropertyCollectorDataAdapter.class.getSimpleName()));
                }
                try {
                    return method.invoke((Object)propertyCollector, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getCause();
                }
            }
        });
        _logger.debug("PropertyCollector stub created.");
        return propertyCollector2;
    }

    private PropertyCollector.FilterSpec createFilterSpec(ManagedObjectReference managedObjectReference, PropertySpec[] propertySpecArray, RelationInfo relationInfo, String string) {
        PropertyCollector.FilterSpec filterSpec = new PropertyCollector.FilterSpec();
        _logger.debug("Creating filter spec for object " + ManagedObjectUtil.morefToString((ManagedObjectReference)managedObjectReference));
        PropertyCollector.ObjectSpec[] objectSpecArray = this.createObjectSpec(managedObjectReference, relationInfo);
        if (objectSpecArray == null) {
            return null;
        }
        filterSpec.objectSet = objectSpecArray;
        String string2 = relationInfo != null ? relationInfo.relations[0] : null;
        PropertyCollector.PropertySpec propertySpec = this.createPropertySpec(managedObjectReference, propertySpecArray, string2, string);
        filterSpec.propSet = new PropertyCollector.PropertySpec[]{propertySpec};
        filterSpec.setReportMissingObjectsInResults(Boolean.valueOf(true));
        return filterSpec;
    }

    private PropertyCollector.ObjectSpec[] createObjectSpec(ManagedObjectReference managedObjectReference, RelationInfo relationInfo) {
        String string;
        int n;
        PropertyCollector.ObjectSpec objectSpec = new PropertyCollector.ObjectSpec();
        objectSpec.obj = managedObjectReference;
        if (relationInfo == null || StringUtil.isNullOrEmpty((String)relationInfo.relations[0])) {
            return new PropertyCollector.ObjectSpec[]{objectSpec};
        }
        PropertyCollector.TraversalSpec[] traversalSpecArray = new PropertyCollector.TraversalSpec[relationInfo.relations.length];
        for (n = 0; n < relationInfo.relations.length; ++n) {
            PropertyCollector.TraversalSpec traversalSpec;
            string = relationInfo.relations[n];
            String string2 = relationInfo.relationOwnerType[n];
            if (string2 == null) {
                string2 = managedObjectReference.getType();
            }
            if (relationInfo.relationOwnerType[n] == null) {
                relationInfo.relationOwnerType[n] = managedObjectReference.getType();
            }
            traversalSpecArray[n] = traversalSpec = this.buildTraversalSpec(relationInfo.relationOwnerType[n], string);
        }
        for (n = 0; n < relationInfo.relations.length; ++n) {
            string = traversalSpecArray[n];
            if (n == 0) {
                objectSpec.selectSet = new PropertyCollector.SelectionSpec[]{string};
                continue;
            }
            traversalSpecArray[n - 1].selectSet = new PropertyCollector.SelectionSpec[]{string};
        }
        return new PropertyCollector.ObjectSpec[]{objectSpec};
    }

    private PropertyCollector.TraversalSpec buildTraversalSpec(String string, String string2) {
        PropertyCollector.TraversalSpec traversalSpec = new PropertyCollector.TraversalSpec();
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(string);
        traversalSpec.type = new TypeNameImpl(vmodlType);
        traversalSpec.path = string2;
        return traversalSpec;
    }

    private PropertyCollector.PropertySpec createPropertySpec(ManagedObjectReference managedObjectReference, PropertySpec[] propertySpecArray, String string, String string2) {
        PropertyCollector.PropertySpec propertySpec = new PropertyCollector.PropertySpec();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = managedObjectReference.getType();
        if (!StringUtil.isNullOrEmpty((String)string) && !StringUtil.isNullOrEmpty((String)string2)) {
            string3 = string2;
        }
        VmodlType vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(string3);
        propertySpec.type = new TypeNameImpl(vmodlType);
        String string4 = managedObjectReference.getServerGuid();
        if (string4 == null) {
            throw new IllegalStateException("moRef without a guid: " + managedObjectReference);
        }
        VcService vcService = VimSessionUtil.getService((String)string4);
        if (vcService == null) {
            throw new IllegalStateException("Can't find service for guid " + string4);
        }
        String string5 = vcService.getServiceVersion();
        VmodlVersion vmodlVersion = this.getVmodlVersion(vcService);
        for (PropertySpec propertySpec2 : propertySpecArray) {
            String[] stringArray;
            for (String string6 : stringArray = this.computePropertiesToRetrieve(string5, vmodlVersion, string3, vmodlType, propertySpec2)) {
                string6 = PropertyCollectorDataAdapter.replaceSuffixIfAny(string6, "._length", ".length");
                string6 = PropertyCollectorDataAdapter.replaceSuffixIfAny(string6, "@reference", "");
                arrayList.add(string6);
            }
        }
        _logger.debug("The following properties are requested for object " + ManagedObjectUtil.morefToString((ManagedObjectReference)managedObjectReference) + ": " + arrayList.toString());
        propertySpec.setPathSet(arrayList.toArray(new String[0]));
        return propertySpec;
    }

    private static String replaceSuffixIfAny(String string, String string2, String string3) {
        if (string.endsWith(string2)) {
            return string.replace(string2, string3);
        }
        return string;
    }

    private Boolean isObjectSupported(Object object) {
        String string = QueryUtil.getReferenceType((Object)object);
        TypeInfo typeInfo = this._typeByTypeName.get(string);
        return typeInfo != null;
    }

    private String[] computePropertiesToRetrieve(String string, VmodlVersion vmodlVersion, String string2, VmodlType vmodlType, PropertySpec propertySpec) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeInfo typeInfo = this._typeByTypeName.get(string2);
        if (typeInfo == null) {
            return new String[0];
        }
        if (propertySpec.type != null && !propertySpec.type.equals("*") && !propertySpec.type.equals(string2)) {
            _logger.debug("pSpec is of type " + propertySpec.type + " and type is " + string2);
            return new String[0];
        }
        for (String string3 : propertySpec.propertyNames) {
            if (!this.isPropertySuppported(string, vmodlVersion, string3, vmodlType).booleanValue()) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[0]);
    }

    private VmodlField getProperty(VmodlType vmodlType, String string) {
        if (vmodlType instanceof ManagedObjectType) {
            ManagedObjectType managedObjectType = (ManagedObjectType)vmodlType;
            return managedObjectType.getManagedProperty(string);
        }
        if (vmodlType instanceof DataObjectType) {
            DataObjectType dataObjectType = (DataObjectType)vmodlType;
            return dataObjectType.getProperty(string);
        }
        return null;
    }

    private Boolean isPropertySuppported(String string, VmodlVersion vmodlVersion, String string2, VmodlType vmodlType) {
        if (string2.contains(PROPERTY_PATH_TYPE)) {
            return false;
        }
        if ("_length".equals(string2)) {
            return true;
        }
        if ("@reference".equals(string2)) {
            return true;
        }
        PropertyPathInfo propertyPathInfo = new PropertyPathInfo();
        propertyPathInfo.parsePath(string2);
        VmodlField vmodlField = this.getProperty(vmodlType, propertyPathInfo.getPropertyName());
        if (vmodlField == null) {
            return false;
        }
        if (vmodlVersion == null) {
            return true;
        }
        if (!vmodlVersion.isCompatible(vmodlField.getVersion())) {
            return false;
        }
        if (propertyPathInfo.getChildPath() != null) {
            VmodlType vmodlType2 = propertyPathInfo.getExplicitChildVmodlType();
            if (vmodlType2 == null) {
                VmodlType vmodlType3 = vmodlType2 = vmodlField.isLink() ? vmodlField.getLinkType() : vmodlField.getType();
            }
            if (vmodlType2 != null) {
                return this.isPropertySuppported(string, vmodlVersion, propertyPathInfo.getChildPath(), vmodlType2);
            }
        }
        return true;
    }

    private List<ResultItem> tryToRetrieveContentsAndReloginIfNotAuthenticated(PropertyCollector propertyCollector, PropertyCollector.FilterSpec[] filterSpecArray, List<Exception> list, PropertySpec[] propertySpecArray, String string) throws Exception {
        assert (list != null);
        LinkedList<Exception> linkedList = new LinkedList<Exception>();
        List<ResultItem> list2 = this.retrieveContents(propertyCollector, filterSpecArray, linkedList, propertySpecArray);
        Exception exception = null;
        for (Exception exception2 : linkedList) {
            if (!(exception2 instanceof NotAuthenticated)) continue;
            exception = exception2;
            break;
        }
        if (exception == null) {
            list.addAll(linkedList);
            return list2;
        }
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            throw new IllegalStateException("Can't find service for guid " + string);
        }
        _logger.warn("A PropertyCollector call for VcService " + vcService.getServiceUrl() + " failed", (Throwable)exception);
        try {
            _logger.info("Will try to relogin");
            propertyCollector.getFilter();
            _logger.info("Relogin successful");
        }
        catch (Exception exception3) {
            _logger.error("Error occurred while trying to relogin", (Throwable)exception3);
            list.addAll(linkedList);
            return list2;
        }
        if (Boolean.TRUE.equals(vcService.getConnectionInfo().getConnectionState())) {
            _logger.info("Relogin successful");
            list2 = this.retrieveContents(propertyCollector, filterSpecArray, list, propertySpecArray);
        } else {
            _logger.error("Failed to relogin");
            list.addAll(linkedList);
        }
        return list2;
    }

    private List<ResultItem> retrieveContents(PropertyCollector propertyCollector, PropertyCollector.FilterSpec[] filterSpecArray, List<Exception> list, PropertySpec[] propertySpecArray) throws Exception {
        PropertyCollector.RetrieveResult retrieveResult;
        _logger.debug("retrieveContents start.");
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        ExecutionProfiler executionProfiler = SessionUtil.getExecutionProfiler();
        String string = "PropertyCollector " + propertyCollector.toString();
        Object object = executionProfiler.startTimer(string);
        try {
            retrieveResult = propertyCollector.retrievePropertiesEx(filterSpecArray, RETRIEVE_OPTIONS);
        }
        catch (Exception exception) {
            String string2 = this.filterSpecsToString(filterSpecArray);
            _logger.error(PropertyCollector.class.getSimpleName() + " invocation failed: " + exception.getMessage() + "\nFilterSpec:\n" + string2);
            throw exception;
        }
        finally {
            executionProfiler.stopTimer(object);
        }
        if (retrieveResult == null) {
            _logger.debug("No matching objects found");
            return arrayList;
        }
        List<ResultItem> list2 = this.toResultItems(retrieveResult, list, propertySpecArray);
        arrayList.addAll(list2);
        while (retrieveResult.token != null) {
            retrieveResult = propertyCollector.continueRetrievePropertiesEx(retrieveResult.token);
            if (retrieveResult == null) {
                return arrayList;
            }
            list2 = this.toResultItems(retrieveResult, list, propertySpecArray);
            arrayList.addAll(list2);
        }
        _logger.debug("retrieveContents completed successfully.");
        return arrayList;
    }

    private String filterSpecsToString(PropertyCollector.FilterSpec[] filterSpecArray) {
        if (filterSpecArray == null) {
            return null;
        }
        if (filterSpecArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        try {
            int n = filterSpecArray.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append('[').append(i).append("]\n");
                PropertyCollector.FilterSpec filterSpec = filterSpecArray[i];
                stringBuilder.append(filterSpec.toString());
            }
        }
        catch (Exception exception) {
            _logger.error("Failed to generate a string representation of " + filterSpecArray.getClass().getName(), (Throwable)exception);
            return "???";
        }
        return stringBuilder.toString();
    }

    private List<ResultItem> toResultItems(PropertyCollector.RetrieveResult retrieveResult, List<Exception> list, PropertySpec[] propertySpecArray) {
        if (retrieveResult == null) {
            return new ArrayList<ResultItem>(0);
        }
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (PropertyCollector.ObjectContent objectContent : retrieveResult.objects) {
            ResultItem resultItem = this.createResultItem(objectContent, list, propertySpecArray);
            if (resultItem == null) continue;
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    private ResultItem createResultItem(PropertyCollector.ObjectContent objectContent, List<Exception> list, PropertySpec[] propertySpecArray) {
        Object object;
        Object object2;
        ManagedObjectReference managedObjectReference = objectContent.getObj();
        String string = ManagedObjectUtil.morefToString((ManagedObjectReference)managedObjectReference);
        if (objectContent.missingSet != null) {
            for (ResultItem resultItem : objectContent.missingSet) {
                object2 = "Property '" + resultItem.path + "' missing for object " + string;
                object = resultItem.fault;
                if (object == null) {
                    _logger.error((String)object2);
                    continue;
                }
                if (NoPermission.class.equals(object.getClass())) {
                    _logger.debug((String)object2, (Throwable)object);
                    continue;
                }
                _logger.error((String)object2, (Throwable)object);
                list.add((Exception)object);
            }
        }
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = managedObjectReference;
        DynamicProperty[] dynamicPropertyArray = objectContent.getPropSet();
        if (dynamicPropertyArray != null) {
            PropertyValue[] propertyValueArray = new PropertyValue[dynamicPropertyArray.length];
            for (int i = 0; i < dynamicPropertyArray.length; ++i) {
                object2 = dynamicPropertyArray[i];
                object = new PropertyValue();
                ((PropertyValue)object).resourceObject = managedObjectReference;
                ((PropertyValue)object).propertyName = object2.getName();
                ((PropertyValue)object).propertyName = PropertyCollectorDataAdapter.replaceSuffixIfAny(((PropertyValue)object).propertyName, ".length", "._length");
                ((PropertyValue)object).propertyName = PropertyCollectorDataAdapter.replaceSuffixIfAny(((PropertyValue)object).propertyName, "@reference", "@reference");
                ((PropertyValue)object).value = PropertyCollectorDataAdapter.unescapeValueForPropName(((PropertyValue)object).propertyName, object2.getVal(), managedObjectReference);
                propertyValueArray[i] = object;
            }
            resultItem.properties = propertyValueArray;
        }
        return resultItem;
    }

    private RelationInfo constructRelationInfo(RelationalConstraint relationalConstraint) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        this.constructRelationInfoRec((Constraint)relationalConstraint, arrayList, arrayList2);
        RelationInfo relationInfo = new RelationInfo();
        relationInfo.relations = arrayList.toArray(new String[0]);
        relationInfo.relationOwnerType = arrayList2.toArray(new String[0]);
        relationInfo.targetType = relationalConstraint.targetType;
        return relationInfo;
    }

    private void constructRelationInfoRec(Constraint constraint, List<String> list, List<String> list2) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof ObjectIdentityConstraint) {
            list2.add(constraint.targetType);
            return;
        }
        if (constraint instanceof RelationalConstraint) {
            RelationalConstraint relationalConstraint = (RelationalConstraint)constraint;
            this.constructRelationInfoRec(relationalConstraint.constraintOnRelatedObject, list, list2);
            list.add(relationalConstraint.relation);
            list2.add(constraint.targetType);
            return;
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (compositeConstraint.nestedConstraints != null && compositeConstraint.nestedConstraints.length == 1 && compositeConstraint.nestedConstraints[0] instanceof ObjectIdentityConstraint) {
                list2.add(compositeConstraint.nestedConstraints[0].targetType);
                return;
            }
        }
        _logger.info("Contraint apart from ObjectIdentityConstraint, RelationalConstraintand Composite contraint with just one ObjectIdentityConstraint encountered while handling nested relational contraints");
    }

    private boolean isCompositeRelationalConstraint(CompositeConstraint compositeConstraint) {
        if (compositeConstraint == null || compositeConstraint.nestedConstraints == null || compositeConstraint.nestedConstraints.length == 0) {
            return false;
        }
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            if (constraint instanceof RelationalConstraint) continue;
            return false;
        }
        return true;
    }

    private static Object unescapeValueForPropName(String string, Object object, ManagedObjectReference managedObjectReference) {
        Object object2 = object;
        Class clazz = ManagedObjectUtil.getType((ManagedObjectReference)managedObjectReference);
        if (!ManagedEntity.class.isAssignableFrom(clazz) || !(object instanceof String)) {
            return object2;
        }
        if (NAME_PROPERTY.equals(string) || CONFIG_NAME_PROPERTY.equals(string)) {
            object2 = MixedUtil.unescapeVimEntityNameSpecialChars((String)((String)object));
        }
        return object2;
    }

    static {
        PropertyCollectorDataAdapter.RETRIEVE_OPTIONS.maxObjects = 250;
    }

    static class RelationInfo {
        String[] relations;
        String[] relationOwnerType;
        String targetType;

        RelationInfo() {
        }
    }

    class PropertyPathInfo {
        private String _propName;
        private String _childPath;
        private String _childType;

        PropertyPathInfo() {
        }

        void parsePath(String string) {
            int n = string.indexOf(46);
            this._propName = string;
            if (n >= 0) {
                this._propName = string.substring(0, n);
                this._childPath = string.substring(n + 1);
            }
            if ((n = this._propName.indexOf("[")) >= 0) {
                String string2 = this._propName;
                this._propName = string2.substring(0, n);
                n = string2.indexOf(PropertyCollectorDataAdapter.PROPERTY_PATH_TYPE);
                if (n >= 0) {
                    int n2 = string2.indexOf("']", n);
                    this._childType = string2.substring(n + PropertyCollectorDataAdapter.PROPERTY_PATH_TYPE.length(), n2);
                }
            }
        }

        String getPropertyName() {
            return this._propName;
        }

        String getChildPath() {
            return this._childPath;
        }

        VmodlType getExplicitChildVmodlType() {
            VmodlType vmodlType = null;
            if (this._childType != null) {
                vmodlType = VmodlTypeMap.Factory.getTypeMap().getVmodlType(this._childType);
            }
            return vmodlType;
        }
    }
}

