/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.search.FacetSpec;
import com.vmware.vise.search.OrderingCriteria;
import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;

public class ResultSpecTransformer {
    public ResponseSpec toResponseSpec(String string, com.vmware.vise.data.PropertySpec[] propertySpecArray, ResultSpec resultSpec) {
        PropertySpec propertySpec;
        int n;
        if (resultSpec == null) {
            resultSpec = new ResultSpec();
        }
        ResponseSpec responseSpec = new ResponseSpec();
        responseSpec.propertiesToRetrieve = new PropertySpec[propertySpecArray.length];
        for (n = 0; n < propertySpecArray.length; ++n) {
            com.vmware.vise.data.PropertySpec propertySpec2 = propertySpecArray[n];
            responseSpec.propertiesToRetrieve[n] = propertySpec = this.toPropertySpec(propertySpec2, string);
        }
        responseSpec.maxResultsCount = n = resultSpec.maxResultCount != null ? resultSpec.maxResultCount : -1;
        int n2 = resultSpec.offset != null ? resultSpec.offset : 0;
        responseSpec.offset = n2 + 1;
        if (resultSpec.order != null && !ArrayUtil.isNullOrEmpty((Object[])resultSpec.order.orderingProperties)) {
            propertySpec = new OrderingCriteria();
            propertySpec.applicableProperties = new com.vmware.vise.search.OrderingPropertySpec[resultSpec.order.orderingProperties.length];
            for (int i = 0; i < resultSpec.order.orderingProperties.length; ++i) {
                OrderingPropertySpec orderingPropertySpec = resultSpec.order.orderingProperties[i];
                com.vmware.vise.search.OrderingPropertySpec orderingPropertySpec2 = new com.vmware.vise.search.OrderingPropertySpec();
                orderingPropertySpec2.providerType = orderingPropertySpec.type;
                orderingPropertySpec2.properties = orderingPropertySpec.propertyNames;
                orderingPropertySpec2.relationship = orderingPropertySpec.relation;
                orderingPropertySpec2.sortType = ResultSpecTransformer.getSortType(orderingPropertySpec.orderingType);
                propertySpec.applicableProperties[i] = orderingPropertySpec2;
            }
            responseSpec.orderingCriteria = propertySpec;
        }
        responseSpec.facets = this.transformFacets(resultSpec.facets);
        return responseSpec;
    }

    private FacetSpec[] transformFacets(com.vmware.vise.data.query.FacetSpec[] facetSpecArray) {
        if (facetSpecArray == null || facetSpecArray.length == 0) {
            return new FacetSpec[0];
        }
        ArrayList<FacetSpec> arrayList = new ArrayList<FacetSpec>(facetSpecArray.length);
        for (com.vmware.vise.data.query.FacetSpec facetSpec : facetSpecArray) {
            arrayList.add(this.transformFacet(facetSpec));
        }
        return arrayList.toArray(new FacetSpec[0]);
    }

    private FacetSpec transformFacet(com.vmware.vise.data.query.FacetSpec facetSpec) {
        FacetSpec facetSpec2 = new FacetSpec();
        facetSpec2.propSpec = this.toPropertySpec(facetSpec.propSpec, null);
        return facetSpec2;
    }

    private static SortType getSortType(SortType sortType) {
        SortType sortType2 = SortType.ASCENDING;
        if (sortType == SortType.DESCENDING) {
            sortType2 = SortType.DESCENDING;
        }
        return sortType2;
    }

    private PropertySpec toPropertySpec(com.vmware.vise.data.PropertySpec propertySpec, String string) {
        PropertySpec propertySpec2 = new PropertySpec();
        String string2 = propertySpec.type;
        if (string2 == null) {
            string2 = string;
        }
        propertySpec2.providerType = string2;
        propertySpec2.relationship = propertySpec.relation;
        propertySpec2.properties = new String[propertySpec.propertyNames.length];
        for (int i = 0; i < propertySpec.propertyNames.length; ++i) {
            String string3;
            propertySpec2.properties[i] = string3 = propertySpec.propertyNames[i];
        }
        return propertySpec2;
    }
}

