/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.data.adapters.search.impl;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DynamicProviderAdapter;
import com.vmware.vise.data.query.DynamicProviderResultSet;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.metadata.MetadataServiceRegistry;
import com.vmware.vise.metadata.RelationshipDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.search.SearchService;
import com.vmware.vise.search.metadata.DescriptorSource;
import com.vmware.vise.search.metadata.MetadataEvent;
import com.vmware.vise.search.metadata.MetadataListener;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.metadata.SearchServiceMessageLocalizer;
import com.vmware.vise.search.transport.QueryServiceIndex;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.MessageLocalizer;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.data.adapters.common.SearchMetadataQueryCriteria;
import com.vmware.vise.vim.data.adapters.search.QueryRequest;
import com.vmware.vise.vim.data.adapters.search.QueryResult;
import com.vmware.vise.vim.data.adapters.search.impl.AtTypePropertyResultTransformerUtil;
import com.vmware.vise.vim.data.adapters.search.impl.DescriptorTransformer;
import com.vmware.vise.vim.data.adapters.search.impl.QueryExecutor;
import com.vmware.vise.vim.data.adapters.search.impl.QueryRequestTransformer;
import com.vmware.vise.vim.data.adapters.search.impl.QueryResultTransformer;
import com.vmware.vise.vim.data.adapters.search.impl.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SearchBasedAdapterImpl
implements DynamicProviderAdapter {
    private static final Log _logger = LogFactory.getLog(SearchBasedAdapterImpl.class);
    private final QueryExecutor _queryExecutor;
    private final QueryRequestTransformer _queryRequestTransformer;
    private final QueryResultTransformer _queryResultTransformer;
    private final SearchService _searchService;
    private final MetadataServiceRegistry _metadataRegistry;
    private final SearchMetadataQueryCriteria _searchMetadataQueryCriteria;

    public SearchBasedAdapterImpl(MetadataServiceRegistry metadataServiceRegistry, SearchService searchService, QueryServiceIndex queryServiceIndex, ObjectReferenceService objectReferenceService, String string, ExecutorService executorService, boolean bl, SearchMetadataQueryCriteria searchMetadataQueryCriteria) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataServiceRegistry, searchService, queryServiceIndex, string, executorService, searchMetadataQueryCriteria});
        this._metadataRegistry = metadataServiceRegistry;
        this._searchService = searchService;
        this._queryExecutor = new QueryExecutor(this._searchService, executorService, queryServiceIndex);
        this._queryExecutor.setValidateLogin(bl);
        this._queryRequestTransformer = new QueryRequestTransformer(this._searchService, objectReferenceService);
        this._queryRequestTransformer.setDefaultProviderId(string);
        this._queryResultTransformer = new QueryResultTransformer();
        this._searchMetadataQueryCriteria = searchMetadataQueryCriteria;
        List list = searchService.getMetadataDirectory().getDescriptorSources();
        for (DescriptorSource descriptorSource : list) {
            this.registerMetadata(descriptorSource);
        }
        MetadataListener metadataListener = new MetadataListener(){

            public void handleEvent(MetadataEvent metadataEvent) {
                SearchBasedAdapterImpl.this.registerMetadata(metadataEvent.getDescriptorSource());
            }
        };
        this._searchService.getMetadataDirectory().addListener(metadataListener);
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        Response response = new Response();
        if (linkedVcGroupRegistry == null) {
            response.resultSet = new DynamicProviderResultSet[0];
            return response;
        }
        Object[] objectArray = requestSpec.querySpec;
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            // empty if block
        }
        QueryBatch queryBatch = this.toQueryBatch((QuerySpec[])objectArray);
        QueryResult[] queryResultArray = null;
        Collection<QueryRequest> collection = queryBatch.queries.values();
        if (collection.isEmpty()) {
            DynamicProviderResultSet[] dynamicProviderResultSetArray = this.createResult(queryResultArray, (QuerySpec[])objectArray, queryBatch);
            response.resultSet = dynamicProviderResultSetArray;
            return response;
        }
        Collection<QueryRequest> collection2 = this.removeUnsupportedQuerySpecs(collection);
        if (collection2.isEmpty()) {
            DynamicProviderResultSet[] dynamicProviderResultSetArray = this.createResult(queryResultArray, (QuerySpec[])objectArray, queryBatch);
            response.resultSet = dynamicProviderResultSetArray;
            return response;
        }
        QueryRequest[] queryRequestArray = collection2.toArray(new QueryRequest[collection2.size()]);
        queryResultArray = this._queryExecutor.execute(queryRequestArray);
        DynamicProviderResultSet[] dynamicProviderResultSetArray = this.createResult(queryResultArray, (QuerySpec[])objectArray, queryBatch);
        response.resultSet = dynamicProviderResultSetArray;
        return response;
    }

    private void registerMetadata(DescriptorSource descriptorSource) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{descriptorSource});
        ClassLoader classLoader = descriptorSource.getResourceClassLoader();
        SearchServiceMessageLocalizer searchServiceMessageLocalizer = new SearchServiceMessageLocalizer(classLoader, descriptorSource.getResourceBundleName());
        _logger.info((Object)"Registering types meta-data...");
        this.registerTypes(descriptorSource.getTypes(), (MessageLocalizer)searchServiceMessageLocalizer);
        _logger.info((Object)"Types meta-data have been registered.");
        _logger.info((Object)"Registering properties meta-data...");
        this.registerProperties(descriptorSource.getProperties(), (MessageLocalizer)searchServiceMessageLocalizer);
        _logger.info((Object)"Properties meta-data have been registered.");
        _logger.info((Object)"Registering relationships meta-data...");
        this.registerRelationships(descriptorSource.getTypeRelationships(), (MessageLocalizer)searchServiceMessageLocalizer);
        _logger.info((Object)"Relationships meta-data have been registered.");
    }

    private void registerTypes(List<com.vmware.vise.search.metadata.TypeDescriptor> list, MessageLocalizer messageLocalizer) {
        assert (list != null);
        assert (!list.contains(null));
        assert (messageLocalizer != null);
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[list.size()];
        int n = 0;
        for (com.vmware.vise.search.metadata.TypeDescriptor typeDescriptor : list) {
            TypeDescriptor typeDescriptor2 = DescriptorTransformer.getTypeDescriptor(typeDescriptor);
            typeDescriptorArray[n++] = typeDescriptor2;
        }
        this._metadataRegistry.registerTypeMetadata(typeDescriptorArray, messageLocalizer);
    }

    private void registerRelationships(List<RelationDescriptor> list, MessageLocalizer messageLocalizer) {
        assert (list != null);
        assert (!list.contains(null));
        RelationshipDescriptor[] relationshipDescriptorArray = new RelationshipDescriptor[list.size()];
        int n = 0;
        for (RelationDescriptor relationDescriptor : list) {
            RelationshipDescriptor relationshipDescriptor = DescriptorTransformer.getRelationshipDescriptor(relationDescriptor, this._searchService.getMetadataDirectory());
            relationshipDescriptorArray[n++] = relationshipDescriptor;
        }
        this._metadataRegistry.registerRelationshipMetadata(relationshipDescriptorArray, messageLocalizer);
    }

    private void registerProperties(List<PropertyDescriptor> list, MessageLocalizer messageLocalizer) {
        assert (list != null);
        assert (!list.contains(null));
        com.vmware.vise.metadata.PropertyDescriptor[] propertyDescriptorArray = new com.vmware.vise.metadata.PropertyDescriptor[list.size()];
        int n = 0;
        for (PropertyDescriptor propertyDescriptor : list) {
            com.vmware.vise.metadata.PropertyDescriptor propertyDescriptor2 = DescriptorTransformer.getPropertyDescriptor(propertyDescriptor);
            propertyDescriptorArray[n++] = propertyDescriptor2;
        }
        this._metadataRegistry.registerPropertyMetadata(propertyDescriptorArray, messageLocalizer);
    }

    private QueryBatch toQueryBatch(QuerySpec[] querySpecArray) {
        QueryBatch queryBatch = new QueryBatch();
        for (QuerySpec querySpec : querySpecArray) {
            try {
                QueryRequest queryRequest = this._queryRequestTransformer.toQueryRequest(querySpec);
                queryBatch.queries.put(querySpec, queryRequest);
            }
            catch (Exception exception) {
                queryBatch.errorsByInvalidQuery.put(querySpec, exception);
            }
        }
        return queryBatch;
    }

    private DynamicProviderResultSet[] createResult(QueryResult[] queryResultArray, QuerySpec[] querySpecArray, QueryBatch queryBatch) {
        IdentityHashMap<QuerySpec, DynamicProviderResultSet> identityHashMap = new IdentityHashMap<QuerySpec, DynamicProviderResultSet>(querySpecArray.length);
        if (!ArrayUtil.isNullOrEmpty((Object[])queryResultArray)) {
            for (QueryResult queryResult : queryResultArray) {
                QuerySpec querySpec = queryResult.request.getDsQuerySpec();
                DynamicProviderResultSet dynamicProviderResultSet = this._queryResultTransformer.toResultSet(queryResult);
                AtTypePropertyResultTransformerUtil.transform(querySpec, (ResultSet)dynamicProviderResultSet);
                if (this.hasUntypedPropertySpecs(querySpec)) {
                    String string = com.vmware.vise.data.query.impl.Utils.renderQuerySpec((QuerySpec)querySpec);
                    _logger.debug((Object)("The properties requested with this query are not indicated by type and its absence can lead to serious performance issues. To avoid this message, please typify the query.\n" + string));
                    dynamicProviderResultSet.allowFallbackRequest = true;
                }
                identityHashMap.put(querySpec, dynamicProviderResultSet);
            }
        }
        SearchBasedAdapterImpl.addErrorResults(identityHashMap, queryBatch);
        QueryResult[] queryResultArray2 = SearchBasedAdapterImpl.orderResultsPerRequest(identityHashMap, querySpecArray);
        return queryResultArray2;
    }

    private boolean hasUntypedPropertySpecs(QuerySpec querySpec) {
        Constraint constraint = querySpec.resourceSpec.constraint;
        String string = null;
        if (constraint != null) {
            string = constraint.targetType;
        }
        if (StringUtils.isEmpty(string)) {
            Object[] objectArray = querySpec.resourceSpec.propertySpecs;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                return false;
            }
            boolean bl = false;
            for (Object object : objectArray) {
                if (object == null || !StringUtils.isEmpty((String)((PropertySpec)object).type)) continue;
                bl = true;
                break;
            }
            return bl;
        }
        return false;
    }

    private static void addErrorResults(Map<QuerySpec, DynamicProviderResultSet> map, QueryBatch queryBatch) {
        for (QuerySpec querySpec : queryBatch.errorsByInvalidQuery.keySet()) {
            Exception exception = queryBatch.errorsByInvalidQuery.get(querySpec);
            DynamicProviderResultSet dynamicProviderResultSet = Utils.newDynamicProviderResultSet(querySpec.name, exception);
            map.put(querySpec, dynamicProviderResultSet);
        }
    }

    private static DynamicProviderResultSet[] orderResultsPerRequest(Map<QuerySpec, DynamicProviderResultSet> map, QuerySpec[] querySpecArray) {
        DynamicProviderResultSet[] dynamicProviderResultSetArray = new DynamicProviderResultSet[querySpecArray.length];
        int n = 0;
        for (QuerySpec querySpec : querySpecArray) {
            DynamicProviderResultSet dynamicProviderResultSet = map.get(querySpec);
            if (dynamicProviderResultSet == null) {
                dynamicProviderResultSet = Utils.newDynamicProviderResultSet(querySpec.name, null);
            }
            dynamicProviderResultSetArray[n++] = dynamicProviderResultSet;
        }
        return dynamicProviderResultSetArray;
    }

    private Collection<QueryRequest> removeUnsupportedQuerySpecs(Collection<QueryRequest> collection) {
        ArrayList<QueryRequest> arrayList = new ArrayList<QueryRequest>(collection.size());
        for (QueryRequest queryRequest : collection) {
            QuerySpec querySpec = queryRequest.getDsQuerySpec();
            if (this._searchMetadataQueryCriteria.consistsOnlyOfUnsupportedTypes(querySpec)) continue;
            arrayList.add(queryRequest);
        }
        return arrayList;
    }

    private class QueryBatch {
        public final Map<QuerySpec, Exception> errorsByInvalidQuery = new IdentityHashMap<QuerySpec, Exception>();
        public final Map<QuerySpec, QueryRequest> queries = new IdentityHashMap<QuerySpec, QueryRequest>();

        private QueryBatch() {
        }
    }
}

