/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.serialization.impl;

import com.vmware.cis.license.common.serialization.DeserializeException;
import com.vmware.cis.license.common.serialization.Deserializer;
import com.vmware.cis.license.common.serialization.impl.BaseDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZipDeserializerWrapperImpl<T>
extends BaseDeserializer<T>
implements Deserializer<T> {
    private final BaseDeserializer<T> _deserializer;

    public GZipDeserializerWrapperImpl(BaseDeserializer<T> deserializer) {
        this._deserializer = deserializer;
    }

    @Override
    public T deserializeData(InputStream inputStream) throws DeserializeException, IOException {
        try {
            GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
            return this._deserializer.deserializeData(gzipInputStream);
        }
        catch (IOException e) {
            throw new DeserializeException.CorruptedDataException("Failed to decompress data", e);
        }
    }
}

