/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.vmodl;

import com.vmware.cis.license.common.misc.DateUtil;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmodlObjectDump {
    private static final Log _log = LogFactory.getLog((String)VmodlObjectDump.class.getName());
    protected static final String NEW_LINE = "\n";
    protected static final String NULL_STRING = "null";
    protected static final String REC_STRING = "<recursion>";
    protected static final String OFFSET = "    ";
    protected static final int ARRAY_ITEM_LEN_THRESHOLD = 20;
    protected static final int ARRAY_ITEMS_PER_LINE = 4;
    protected static final int ARRAY_LEN_THRESHOLD = 50;
    protected final boolean dumpShort;
    protected static final Set<Class<?>> WRAPPER_TYPES = VmodlObjectDump.getWrapperTypes();
    protected static final Set<Class<?>> WRAPPER_OBJECT_TYPES = VmodlObjectDump.getWrapperObjectTypes();

    public VmodlObjectDump(boolean dumpShort) {
        this.dumpShort = dumpShort;
    }

    public String dumpObject(Object obj) {
        return this.dumpObject("", obj);
    }

    public String dumpObject(String name, Object obj) {
        try {
            HashSet<Object> dumpStack = new HashSet<Object>();
            return this.dumpObjectRec(name, obj, dumpStack);
        }
        catch (Exception e) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"Failed to dump obj", (Throwable)e);
            }
            return e.getMessage();
        }
    }

    protected String dumpValueArray(String name, Object value, Set<Object> dumpStack) {
        String valueStr;
        Class<?> valueComponentType = value.getClass().getComponentType();
        if (VmodlObjectDump.isWrapperType(valueComponentType) && !VmodlObjectDump.isWrapperObjectType(valueComponentType)) {
            boolean[] arr_boolean;
            char[] arr_char;
            byte[] arr_byte;
            short[] arr_short;
            double[] arr_double;
            float[] arr_float;
            long[] arr_long;
            int[] arr_int;
            valueStr = valueComponentType == Integer.TYPE ? ((arr_int = (int[])value).length <= 50 ? Arrays.toString(arr_int) : String.format("int[%d]", arr_int.length)) : (valueComponentType == Long.TYPE ? ((arr_long = (long[])value).length <= 50 ? Arrays.toString(arr_long) : String.format("long[%d]", arr_long.length)) : (valueComponentType == Float.TYPE ? ((arr_float = (float[])value).length <= 50 ? Arrays.toString(arr_float) : String.format("float[%d]", arr_float.length)) : (valueComponentType == Double.TYPE ? ((arr_double = (double[])value).length <= 50 ? Arrays.toString(arr_double) : String.format("double[%d]", arr_double.length)) : (valueComponentType == Short.TYPE ? ((arr_short = (short[])value).length <= 50 ? Arrays.toString(arr_short) : String.format("short[%d]", arr_short.length)) : (valueComponentType == Byte.TYPE ? ((arr_byte = (byte[])value).length <= 50 ? Arrays.toString(arr_byte) : String.format("byte[%d]", arr_byte.length)) : (valueComponentType == Character.TYPE ? ((arr_char = (char[])value).length <= 50 ? Arrays.toString(arr_char) : String.format("char[%d]", arr_char.length)) : (valueComponentType == Boolean.TYPE ? ((arr_boolean = (boolean[])value).length <= 50 ? Arrays.toString(arr_boolean) : String.format("boolean[%d]", arr_boolean.length)) : value.toString())))))));
        } else {
            Object[] values = (Object[])value;
            valueStr = this.dumpObjectArray(name, values, dumpStack);
        }
        return valueStr;
    }

    protected String dumpCustomTypes(String name, Object value) {
        String valueStr = null;
        if (value instanceof Calendar) {
            valueStr = this.dumpCalendar((Calendar)value);
        } else if (value instanceof KeyAnyValue) {
            valueStr = this.dumpKeyAnyValue((KeyAnyValue)value);
        }
        return valueStr;
    }

    protected String dumpObjectRec(String objName, Object obj, Set<Object> dumpStack) {
        Method[] methods;
        if (obj == null) {
            return NULL_STRING;
        }
        if (dumpStack.contains(obj)) {
            return REC_STRING;
        }
        String objStr = this.dumpCustomTypes(objName, obj);
        if (objStr != null) {
            return objStr;
        }
        if (VmodlObjectDump.isWrapperType(obj.getClass())) {
            return obj.toString();
        }
        dumpStack.add(obj);
        if (obj.getClass().isArray()) {
            objStr = this.dumpValueArray(objName, obj, dumpStack);
            dumpStack.remove(obj);
            return objStr;
        }
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = obj.getClass();
        sb.append(NEW_LINE);
        sb.append(clazz.getSimpleName());
        for (Method method : methods = obj.getClass().getMethods()) {
            String name;
            if (method.getName().startsWith("get")) {
                name = method.getName().substring(3);
            } else {
                if (!method.getName().startsWith("is")) continue;
                name = method.getName().substring(2);
            }
            if (method.getParameterTypes().length != 0 || method.isVarArgs() || method.getReturnType() == Void.class || name.equals("Class")) continue;
            name = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
            Object value = null;
            try {
                value = method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
            if (value == null) continue;
            VmodlObjectDump.sb_append(sb, " " + name + ": ", this.dumpObjectRec(name, value, dumpStack));
        }
        dumpStack.remove(obj);
        return sb.toString();
    }

    protected String dumpObjectArray(String name, Object[] values, Set<Object> dumpStack) {
        if (values == null) {
            return NULL_STRING;
        }
        if (values.length == 0) {
            return "[]";
        }
        int len = values.length;
        if (len > 50) {
            len = 50;
        }
        String[] strings = new String[len];
        boolean doItemsPerLine = true;
        for (int i = 0; i < len; ++i) {
            String valueStr;
            strings[i] = valueStr = this.dumpObjectRec(name, values[i], dumpStack);
            if (valueStr == null || !valueStr.contains(NEW_LINE) && valueStr.length() <= 20) continue;
            doItemsPerLine = false;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (strings.length == 1) {
            sb.append(strings[0]);
            if (strings[0].startsWith(NEW_LINE)) {
                sb.append(NEW_LINE);
            }
        } else {
            int itemsPerLine = 0;
            for (int i = 0; i < strings.length; ++i) {
                boolean addNewLine = false;
                if (doItemsPerLine) {
                    if (itemsPerLine >= 4) {
                        itemsPerLine = 0;
                    }
                    if (itemsPerLine == 0) {
                        addNewLine = true;
                    }
                    ++itemsPerLine;
                } else {
                    addNewLine = true;
                }
                if (addNewLine && strings[i] != null && !strings[i].startsWith(NEW_LINE)) {
                    sb.append(NEW_LINE);
                }
                sb.append(strings[i]);
                if (i + 1 >= strings.length) continue;
                sb.append(", ");
            }
            sb.append(NEW_LINE);
        }
        if (len < values.length) {
            sb.append("...");
        }
        sb.append("]");
        if (len < values.length) {
            sb.append(values[len].getClass().getSimpleName()).append("[");
            sb.append(values.length).append("]");
        }
        return sb.toString();
    }

    protected String dumpCalendar(Calendar value) {
        if (value == null) {
            return NULL_STRING;
        }
        return DateUtil.formatISODateZulu(value.getTime());
    }

    protected String dumpKeyAnyValue(KeyAnyValue keyAnyValue) {
        String name = keyAnyValue.getKey();
        String value = this.dumpObject(name, keyAnyValue.getValue());
        return String.format("%s=%s", name, this.addQuotesIfNeeded(value));
    }

    protected static void sb_append(StringBuilder sb, String label) {
        sb.append(NEW_LINE).append(label);
    }

    protected static void sb_append(StringBuilder sb, String label, Object value) {
        VmodlObjectDump.sb_append(sb, label);
        String valueStr = value != null ? value.toString() : NULL_STRING;
        boolean appendQuotes = valueStr.contains(" ");
        if (valueStr.startsWith(NEW_LINE) || valueStr.startsWith("[\n")) {
            valueStr = valueStr.replace(NEW_LINE, "\n    ");
            appendQuotes = false;
        } else if (valueStr.startsWith("{") && valueStr.endsWith("}") || valueStr.startsWith("[") && valueStr.endsWith("]")) {
            appendQuotes = false;
        }
        if (appendQuotes) {
            sb.append('\'');
        }
        sb.append(valueStr);
        if (appendQuotes) {
            sb.append('\'');
        }
    }

    protected String addQuotesIfNeeded(String value) {
        if (value.contains(" ")) {
            return String.format("'%s'", value);
        }
        return value;
    }

    protected static boolean isWrapperType(Class<?> clazz) {
        return WRAPPER_TYPES.contains(clazz);
    }

    protected static Set<Class<?>> getWrapperTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(String.class);
        ret.add(URI.class);
        ret.add(Boolean.TYPE);
        ret.add(Character.TYPE);
        ret.add(Byte.TYPE);
        ret.add(Short.TYPE);
        ret.add(Integer.TYPE);
        ret.add(Long.TYPE);
        ret.add(Float.TYPE);
        ret.add(Double.TYPE);
        return ret;
    }

    protected static boolean isWrapperObjectType(Class<?> clazz) {
        return WRAPPER_OBJECT_TYPES.contains(clazz);
    }

    protected static Set<Class<?>> getWrapperObjectTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(String.class);
        ret.add(URI.class);
        return ret;
    }
}

