/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.PropertyFacade;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardSpec;
import com.vmware.vim.binding.vim.alarm.Alarm;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class AlarmsPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final String ALARM_DEFINITIONS = "alarmDefinitions";
    private static final String ALARM_DETAILS = "alarmDetails";
    private static final String ALARM_MONITOR_TYPES = "alarmMonitorTypes";
    private static final String H5_ALARM_WIZARD_INFO = "h5AlarmWizardInfo";
    private final PropertyFacade _propertyFacade;

    public AlarmsPropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, PropertyFacade propertyFacade) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataServiceExtensionRegistry});
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._propertyFacade = propertyFacade;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = "*";
        typeInfo.properties = new String[]{ALARM_DEFINITIONS};
        TypeInfo typeInfo2 = new TypeInfo();
        typeInfo2.type = Alarm.class.getSimpleName();
        typeInfo2.properties = new String[]{ALARM_DETAILS};
        TypeInfo typeInfo3 = new TypeInfo();
        typeInfo3.type = "*";
        typeInfo3.properties = new String[]{ALARM_MONITOR_TYPES};
        TypeInfo typeInfo4 = new TypeInfo();
        typeInfo4.type = "*";
        typeInfo4.properties = new String[]{H5_ALARM_WIZARD_INFO};
        return new TypeInfo[]{typeInfo, typeInfo2, typeInfo3, typeInfo4};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
        Object[] objectArray = propertyRequestSpec.objects;
        PropertySpec[] propertySpecArray = propertyRequestSpec.properties;
        if (objectArray == null || objectArray.length == 0 || propertySpecArray == null || propertySpecArray.length == 0) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        ArrayList<MethodFault> arrayList2 = new ArrayList<MethodFault>();
        for (Object object : objectArray) {
            try {
                Object object2;
                Object object3;
                if (this.isPropertyRequested(ALARM_DEFINITIONS, propertySpecArray)) {
                    object3 = this._propertyFacade.createAlarmDefinitions(object);
                    object2 = this.createAlarmDefResult(object, (List<AlarmDefinition>)object3);
                    arrayList.add((ResultItem)object2);
                }
                if (this.isPropertyRequested(ALARM_DETAILS, propertySpecArray) && (object3 = this._propertyFacade.createAlarmDetails(object)).isPresent()) {
                    object2 = this.createAlarmDetailsResult(object, (AlarmDetails)object3.get());
                    arrayList.add((ResultItem)object2);
                }
                if (this.isPropertyRequested(ALARM_MONITOR_TYPES, propertySpecArray)) {
                    object3 = this._propertyFacade.createAlarmMonitorTypeInfo(object);
                    object2 = this.createAlarmMonitorTypesResult(object, (List<AlarmMonitorType>)object3);
                    arrayList.add((ResultItem)object2);
                }
                if (!this.isPropertyRequested(H5_ALARM_WIZARD_INFO, propertySpecArray)) continue;
                object3 = (AlarmDefWizardSpec)((Object)this.getParameters(H5_ALARM_WIZARD_INFO, propertySpecArray));
                Validate.notNull(object3);
                object2 = this._propertyFacade.createAlarmWizardInfo(object, (AlarmDefWizardSpec)((Object)object3));
                ResultItem resultItem = this.createAlarmWizardInfoResult(object, (AlarmDefWizardInfo)((Object)object2));
                arrayList.add(resultItem);
            }
            catch (Exception exception) {
                arrayList2.add(MixedUtil.getMethodFault((Throwable)exception));
            }
        }
        if (!arrayList2.isEmpty()) {
            resultSet.error = new CompositeException(arrayList2);
        }
        resultSet.items = arrayList.toArray(new ResultItem[0]);
        return resultSet;
    }

    private ResultItem createAlarmDetailsResult(Object object, AlarmDetails alarmDetails) {
        return this.createResultItem(object, alarmDetails, ALARM_DETAILS);
    }

    private ResultItem createAlarmDefResult(Object object, List<AlarmDefinition> list) {
        return this.createResultItem(object, list, ALARM_DEFINITIONS);
    }

    private ResultItem createAlarmMonitorTypesResult(Object object, List<AlarmMonitorType> list) {
        return this.createResultItem(object, list, ALARM_MONITOR_TYPES);
    }

    private ResultItem createAlarmWizardInfoResult(Object object, AlarmDefWizardInfo alarmDefWizardInfo) {
        return this.createResultItem(object, (Object)alarmDefWizardInfo, H5_ALARM_WIZARD_INFO);
    }

    private ResultItem createResultItem(Object object, Object object2, String string) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = object;
        propertyValue.propertyName = string;
        propertyValue.value = object2;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = object;
        resultItem.properties = new PropertyValue[]{propertyValue};
        return resultItem;
    }

    private boolean isPropertyRequested(String string, PropertySpec[] propertySpecArray) {
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string2 : propertySpec.propertyNames) {
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private <T> T getParameters(String string, PropertySpec[] propertySpecArray) {
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string2 : propertySpec.propertyNames) {
                if (!string.equals(string2)) continue;
                Validate.notEmpty((Object[])propertySpec.parameters);
                for (ParameterSpec parameterSpec : propertySpec.parameters) {
                    if (!parameterSpec.propertyName.equals(string) || parameterSpec.parameter == null) continue;
                    return (T)parameterSpec.parameter;
                }
            }
        }
        return null;
    }
}

