/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms;

import com.google.common.base.Optional;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinition;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDefinitionCreator;
import com.vmware.opsmgmt.client.extension.alarms.AlarmDetailsCreator;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmDetails;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorTypeInfoCreator;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardInfo;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmDefWizardSpec;
import com.vmware.opsmgmt.client.extension.alarms.wizardinfo.AlarmWizardInfoCreator;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyFacade {
    private final AlarmDefinitionCreator _alarmDefinitionCreator;
    private final AlarmDetailsCreator _alarmDetailsCreator;
    private final AlarmMonitorTypeInfoCreator _alarmMonitorTypeInfoCreator;
    private final AlarmWizardInfoCreator _alarmWizardInfoCreator;
    private static final Log _logger = LogFactory.getLog(PropertyFacade.class);

    public PropertyFacade(AlarmDefinitionCreator alarmDefinitionCreator, AlarmDetailsCreator alarmDetailsCreator, AlarmMonitorTypeInfoCreator alarmMonitorTypeInfoCreator, AlarmWizardInfoCreator alarmWizardInfoCreator) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmDefinitionCreator, alarmDetailsCreator, alarmMonitorTypeInfoCreator, alarmWizardInfoCreator});
        this._alarmDefinitionCreator = alarmDefinitionCreator;
        this._alarmDetailsCreator = alarmDetailsCreator;
        this._alarmMonitorTypeInfoCreator = alarmMonitorTypeInfoCreator;
        this._alarmWizardInfoCreator = alarmWizardInfoCreator;
    }

    public List<AlarmDefinition> createAlarmDefinitions(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        try {
            String string = VcServiceUtil.getServiceName((String)((ManagedObjectReference)object).getServerGuid());
            return this._alarmDefinitionCreator.createAlarmDefinitions(object, string);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public Optional<AlarmDetails> createAlarmDetails(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        try {
            return Optional.of((Object)this._alarmDetailsCreator.createAlarmDetails(object));
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return Optional.absent();
        }
    }

    public List<AlarmMonitorType> createAlarmMonitorTypeInfo(Object object) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object});
        try {
            return this._alarmMonitorTypeInfoCreator.getMonitorTypes((ManagedObjectReference)object);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return Collections.emptyList();
        }
    }

    public AlarmDefWizardInfo createAlarmWizardInfo(Object object, AlarmDefWizardSpec alarmDefWizardSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{object, alarmDefWizardSpec});
        Validate.notNull((Object)alarmDefWizardSpec.monitorType);
        try {
            return this._alarmWizardInfoCreator.createAlarmWizardinfo((ManagedObjectReference)object, alarmDefWizardSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return new AlarmDefWizardInfo();
        }
    }
}

