/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ActionWrapper {
    private static String LOWER_RES_KEY_EXTENSION = ".lower";
    protected AlarmTriggeringAction _action;
    protected String _title;
    protected String _titleLower;

    public ActionWrapper(AlarmTriggeringAction alarmTriggeringAction, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmTriggeringAction, string});
        this._action = alarmTriggeringAction;
        this._title = Localization.getVpxString(string);
        this._titleLower = Localization.getVpxString(string + LOWER_RES_KEY_EXTENSION);
    }

    public AlarmTriggeringAction getAction() {
        return this._action;
    }

    public List<ActionConfigDescription> getConfiguration() {
        return Collections.emptyList();
    }

    public void setConfiguration(List<ActionConfigDescription> list) {
    }

    public String getConfigString() {
        return "";
    }

    public void setConfigString(String string) {
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
    }

    public String getTitleLower() {
        return this._titleLower;
    }

    public AlarmTriggeringAction.TransitionSpec getGreenToYellow() {
        return this.getTransitionForStates(ManagedEntity.Status.green, ManagedEntity.Status.yellow);
    }

    public void setGreenToYellow(AlarmTriggeringAction.TransitionSpec transitionSpec) {
        AlarmTriggeringAction.TransitionSpec transitionSpec2 = this.getGreenToYellow();
        this.updateTransitionSpec(transitionSpec, transitionSpec2);
    }

    public AlarmTriggeringAction.TransitionSpec getYellowToRed() {
        return this.getTransitionForStates(ManagedEntity.Status.yellow, ManagedEntity.Status.red);
    }

    public void setYellowToRed(AlarmTriggeringAction.TransitionSpec transitionSpec) {
        AlarmTriggeringAction.TransitionSpec transitionSpec2 = this.getYellowToRed();
        this.updateTransitionSpec(transitionSpec, transitionSpec2);
    }

    public AlarmTriggeringAction.TransitionSpec getRedToYellow() {
        return this.getTransitionForStates(ManagedEntity.Status.red, ManagedEntity.Status.yellow);
    }

    public void setRedToYellow(AlarmTriggeringAction.TransitionSpec transitionSpec) {
        AlarmTriggeringAction.TransitionSpec transitionSpec2 = this.getRedToYellow();
        this.updateTransitionSpec(transitionSpec, transitionSpec2);
    }

    public AlarmTriggeringAction.TransitionSpec getYellowToGreen() {
        return this.getTransitionForStates(ManagedEntity.Status.yellow, ManagedEntity.Status.green);
    }

    public void setYellowToGreen(AlarmTriggeringAction.TransitionSpec transitionSpec) {
        AlarmTriggeringAction.TransitionSpec transitionSpec2 = this.getYellowToGreen();
        this.updateTransitionSpec(transitionSpec, transitionSpec2);
    }

    public String validateConfigString(String string) {
        return "";
    }

    public boolean supportsConfiguration() {
        return false;
    }

    public String validateConfiguration() {
        if (this.isAllSpecsEmpty()) {
            return Localization.getString("actionWrapper.transitionspec.is.emtpty");
        }
        return this.validateConfigurationInternal();
    }

    protected String validateConfigurationInternal() {
        return "";
    }

    private boolean isAllSpecsEmpty() {
        return this.getGreenToYellow() == null && this.getYellowToRed() == null && this.getRedToYellow() == null && this.getYellowToGreen() == null;
    }

    private void updateTransitionSpec(AlarmTriggeringAction.TransitionSpec transitionSpec, AlarmTriggeringAction.TransitionSpec transitionSpec2) {
        if (this._action.transitionSpecs == null) {
            this._action.transitionSpecs = new AlarmTriggeringAction.TransitionSpec[]{transitionSpec};
            return;
        }
        int n = -1;
        for (int i = 0; i < this._action.transitionSpecs.length; ++i) {
            if (!this._action.transitionSpecs[i].equals(transitionSpec2)) continue;
            n = i;
            break;
        }
        if (transitionSpec == null) {
            if (transitionSpec2 != null && n != -1) {
                ArrayList<AlarmTriggeringAction.TransitionSpec> arrayList = new ArrayList<AlarmTriggeringAction.TransitionSpec>();
                for (int i = 0; i < this._action.transitionSpecs.length; ++i) {
                    if (i == n) continue;
                    arrayList.add(this._action.transitionSpecs[i]);
                }
                this._action.transitionSpecs = arrayList.toArray(new AlarmTriggeringAction.TransitionSpec[0]);
            }
            return;
        }
        if (transitionSpec2 != null && n != -1) {
            this._action.transitionSpecs[n] = transitionSpec;
        }
    }

    private AlarmTriggeringAction.TransitionSpec getTransitionForStates(ManagedEntity.Status status, ManagedEntity.Status status2) {
        for (AlarmTriggeringAction.TransitionSpec transitionSpec : this._action.transitionSpecs) {
            if (transitionSpec == null || transitionSpec.startState != status || transitionSpec.finalState != status2) continue;
            return transitionSpec;
        }
        return null;
    }
}

