/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.action.MethodAction;
import com.vmware.vim.binding.vim.action.MethodActionArgument;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class MigrateVmActionWrapper
extends ActionWrapper {
    public static final String RESOURCE_POOL = "resourcePool";
    public static final String HOST = "host";
    public static final String PRIORITY = "priority";
    private String _rpName;
    private String _hostName;
    private ManagedObjectReference _resourcePool;
    private ManagedObjectReference _host;
    private VirtualMachine.MovePriority _priority;
    private final MethodAction _migrateAction;

    public MigrateVmActionWrapper(AlarmTriggeringAction alarmTriggeringAction) {
        super(alarmTriggeringAction, "Alarm.AlarmHelper.MigrateVM");
        this._migrateAction = (MethodAction)alarmTriggeringAction.action;
        this._resourcePool = (ManagedObjectReference)this.getArgumentValue(RESOURCE_POOL);
        this._host = (ManagedObjectReference)this.getArgumentValue(HOST);
        this._priority = (VirtualMachine.MovePriority)this.getArgumentValue(PRIORITY);
    }

    @Override
    public List<ActionConfigDescription> getConfiguration() {
        ArrayList<ActionConfigDescription> arrayList = new ArrayList<ActionConfigDescription>();
        ActionConfigDescription actionConfigDescription = new ActionConfigDescription(RESOURCE_POOL, Localization.getString("action.migrate.resourcePool"), this._resourcePool, this._rpName);
        arrayList.add(actionConfigDescription);
        ActionConfigDescription actionConfigDescription2 = new ActionConfigDescription(HOST, Localization.getString("action.migrate.host"), this._host, this._hostName);
        arrayList.add(actionConfigDescription2);
        ActionConfigDescription actionConfigDescription3 = new ActionConfigDescription(PRIORITY, Localization.getString("action.migrate.priority"), this._priority, this.getMigrationPriority());
        arrayList.add(actionConfigDescription3);
        return arrayList;
    }

    @Override
    public void setConfiguration(List<ActionConfigDescription> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        MethodAction methodAction = (MethodAction)this._action.action;
        ArrayList<MethodActionArgument> arrayList = new ArrayList<MethodActionArgument>();
        for (ActionConfigDescription actionConfigDescription : list) {
            String string;
            MethodActionArgument methodActionArgument = new MethodActionArgument();
            methodActionArgument.value = actionConfigDescription;
            arrayList.add(methodActionArgument);
            switch (string = actionConfigDescription.getName()) {
                case "resourcePool": {
                    this._resourcePool = (ManagedObjectReference)actionConfigDescription.getValue();
                    this._rpName = actionConfigDescription.getLocalizedValue();
                    break;
                }
                case "host": {
                    this._host = (ManagedObjectReference)actionConfigDescription.getValue();
                    this._hostName = actionConfigDescription.getLocalizedValue();
                    break;
                }
                case "priority": {
                    this._priority = (VirtualMachine.MovePriority)actionConfigDescription.getValue();
                }
            }
        }
        methodAction.argument = arrayList.toArray(new MethodActionArgument[0]);
    }

    @Override
    public String getConfigString() {
        String string = this.getMigrationPriority();
        String string2 = Localization.getFormattedString("action.migrate.config.srting", new String[]{this._rpName, this._hostName, string});
        return string2;
    }

    public ManagedObjectReference getHost() {
        return this._host;
    }

    public void setHost(ManagedObjectReference managedObjectReference) {
        this._host = managedObjectReference;
        this.setArgumentValue(HOST, managedObjectReference);
    }

    public String getHostName() {
        return this._hostName != null ? this._hostName : "";
    }

    public void setHostName(String string) {
        this._hostName = string;
    }

    public ManagedObjectReference getResourcePool() {
        return this._resourcePool;
    }

    public void setResourcePool(ManagedObjectReference managedObjectReference) {
        this._resourcePool = managedObjectReference;
        this.setArgumentValue(RESOURCE_POOL, managedObjectReference);
    }

    public String getRpName() {
        return this._rpName != null ? this._rpName : "";
    }

    public void setRpName(String string) {
        this._rpName = string;
    }

    public VirtualMachine.MovePriority getPriority() {
        return this._priority;
    }

    public void setPriority(VirtualMachine.MovePriority movePriority) {
        this._priority = movePriority;
        this.setArgumentValue(PRIORITY, movePriority);
    }

    @Override
    public boolean supportsConfiguration() {
        return true;
    }

    @Override
    protected String validateConfigurationInternal() {
        if (StringUtil.isNullOrEmpty((String)this._rpName)) {
            return Localization.getString("migrateVmActionWrapper.error.configure.resource.pool");
        }
        if (StringUtil.isNullOrEmpty((String)this._hostName)) {
            return Localization.getString("migrateVmActionWrapper.error.configure.host");
        }
        String string = this.getMigrationPriority();
        if (StringUtil.isNullOrEmpty((String)string)) {
            return Localization.getString("migrateVmActionWrapper.error.configure.priority");
        }
        return "";
    }

    private String getMigrationPriority() {
        Object object = this.getArgumentValue(PRIORITY);
        return this.getLocalizedMovePriority(object);
    }

    private String getLocalizedMovePriority(Object object) {
        String string = "";
        if (VirtualMachine.MovePriority.defaultPriority.equals(object)) {
            string = Localization.getVpxString("VMMigration.MigrationSummaryBuilder.DefaultPriority");
        } else if (VirtualMachine.MovePriority.lowPriority.equals(object)) {
            string = Localization.getVpxString("VMMigration.MigrationSummaryBuilder.LowPriority");
        } else if (VirtualMachine.MovePriority.highPriority.equals(object)) {
            string = Localization.getVpxString("VMMigration.MigrationSummaryBuilder.HighPriority");
        }
        return string;
    }

    private Object getArgumentValue(String string) {
        if (this._migrateAction == null || this._migrateAction.argument == null) {
            return null;
        }
        MethodActionArgument methodActionArgument = null;
        switch (string) {
            case "resourcePool": {
                if (this._migrateAction.argument.length <= 0) break;
                methodActionArgument = this._migrateAction.argument[0];
                break;
            }
            case "host": {
                if (this._migrateAction.argument.length <= 1) break;
                methodActionArgument = this._migrateAction.argument[1];
                break;
            }
            case "priority": {
                if (this._migrateAction.argument.length <= 2) break;
                methodActionArgument = this._migrateAction.argument[2];
            }
        }
        return methodActionArgument != null ? methodActionArgument.value : null;
    }

    private void setArgumentValue(String string, Object object) {
        int n = -1;
        switch (string) {
            case "resourcePool": {
                n = 0;
                break;
            }
            case "host": {
                n = 1;
                break;
            }
            case "priority": {
                n = 2;
            }
        }
        if (n == -1) {
            return;
        }
        Object object2 = this.getConfiguration();
        ActionConfigDescription actionConfigDescription = (ActionConfigDescription)object2.get(n);
        actionConfigDescription = new ActionConfigDescription(actionConfigDescription.getName(), actionConfigDescription.getLocalizedName(), object, actionConfigDescription.getLocalizedValue());
        object2.set(n, actionConfigDescription);
        this.setConfiguration((List<ActionConfigDescription>)object2);
    }
}

