/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.actions;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionConfigDescription;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionWrapper;
import com.vmware.vim.binding.vim.action.SendEmailAction;
import com.vmware.vim.binding.vim.alarm.AlarmTriggeringAction;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class SendMailActionWrapper
extends ActionWrapper {
    public static final String TO_LIST = "toList";
    public static final String CC_LIST = "ccList";
    public static final String SUBJECT = "subject";
    public static final String BODY = "body";

    public SendMailActionWrapper(AlarmTriggeringAction alarmTriggeringAction) {
        super(alarmTriggeringAction, "Alarm.AlarmHelper.SendEmail");
    }

    @Override
    public List<ActionConfigDescription> getConfiguration() {
        ActionConfigDescription actionConfigDescription;
        ArrayList<ActionConfigDescription> arrayList = new ArrayList<ActionConfigDescription>();
        SendEmailAction sendEmailAction = (SendEmailAction)this._action.action;
        ActionConfigDescription actionConfigDescription2 = new ActionConfigDescription(TO_LIST, Localization.getString("actions.email.toList"), sendEmailAction.toList, sendEmailAction.toList);
        arrayList.add(actionConfigDescription2);
        if (!StringUtil.isNullOrEmpty((String)sendEmailAction.ccList)) {
            actionConfigDescription = new ActionConfigDescription(CC_LIST, Localization.getString("actions.email.ccList"), sendEmailAction.ccList, sendEmailAction.ccList);
            arrayList.add(actionConfigDescription);
        }
        if (!StringUtil.isNullOrEmpty((String)sendEmailAction.subject)) {
            actionConfigDescription = new ActionConfigDescription(SUBJECT, Localization.getString("actions.email.subject"), sendEmailAction.subject, sendEmailAction.subject);
            arrayList.add(actionConfigDescription);
        }
        if (!StringUtil.isNullOrEmpty((String)sendEmailAction.body)) {
            actionConfigDescription = new ActionConfigDescription(BODY, Localization.getString("actions.email.body"), sendEmailAction.body, sendEmailAction.body);
            arrayList.add(actionConfigDescription);
        }
        return arrayList;
    }

    @Override
    public void setConfiguration(List<ActionConfigDescription> list) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list});
        SendEmailAction sendEmailAction = (SendEmailAction)this._action.action;
        for (ActionConfigDescription actionConfigDescription : list) {
            String string;
            switch (string = actionConfigDescription.getName()) {
                case "toList": {
                    sendEmailAction.toList = actionConfigDescription.getValue().toString();
                    break;
                }
                case "ccList": {
                    sendEmailAction.ccList = actionConfigDescription.getValue().toString();
                    break;
                }
                case "body": {
                    sendEmailAction.body = actionConfigDescription.getValue().toString();
                    break;
                }
                case "subject": {
                    sendEmailAction.subject = actionConfigDescription.getValue().toString();
                }
            }
        }
    }

    @Override
    public String getConfigString() {
        String string = ((SendEmailAction)this._action.action).toList;
        return string == null ? "" : string;
    }

    @Override
    public void setConfigString(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        SendEmailAction sendEmailAction = (SendEmailAction)this._action.action;
        sendEmailAction.toList = string;
        if (sendEmailAction.ccList == null) {
            sendEmailAction.ccList = "";
        }
        if (sendEmailAction.subject == null) {
            sendEmailAction.subject = "";
        }
        if (sendEmailAction.body == null) {
            sendEmailAction.body = "";
        }
    }

    @Override
    public String validateConfigString(String string) {
        String[] stringArray;
        if (StringUtil.isNullOrEmpty((String)string)) {
            return Localization.getString("sendMailActionWrapper.error.configure.email");
        }
        String string2 = ";";
        if (string.lastIndexOf(",") != -1) {
            string2 = ",";
        }
        for (String string3 : stringArray = string.split(string2)) {
            boolean bl = true;
            if (bl) continue;
            String string4 = Localization.getFormattedString("sendMailActionWrapper.error.invalid.email", new String[]{string3});
            return string4;
        }
        return "";
    }

    @Override
    public boolean supportsConfiguration() {
        return true;
    }

    @Override
    protected String validateConfigurationInternal() {
        return this.validateConfigString(this._action.action.toString());
    }
}

