/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.EventExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vise.util.ValidationUtil;

public class EventConditionBuilder {
    private static final String NEW_LINE = "<br />";

    public TriggerConditionGroup build(EventAlarmExpression eventAlarmExpression, AlarmDefinitionInfo alarmDefinitionInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{eventAlarmExpression, alarmDefinitionInfo});
        EventExpressionWrapper eventExpressionWrapper = new EventExpressionWrapper(eventAlarmExpression, alarmDefinitionInfo);
        String string = eventExpressionWrapper.getName();
        String string2 = Localization.getVpxString(string);
        if (string2 != null && string2.length() > 0) {
            string = string2;
        }
        String string3 = this.getArguments(eventExpressionWrapper);
        String string4 = string + string3;
        return new TriggerConditionGroup(string4, eventAlarmExpression.status);
    }

    private String getArguments(EventExpressionWrapper eventExpressionWrapper) {
        EventAlarmExpression eventAlarmExpression = eventExpressionWrapper.getExpression();
        if (eventAlarmExpression.comparisons == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "triggers.metric.argument";
        for (EventAlarmExpression.Comparison comparison : eventAlarmExpression.comparisons) {
            String string2 = Localization.getVpxString(comparison.attributeName);
            String string3 = Localization.getVpxString(comparison.value);
            if (string2 == null && string2.length() == 0) {
                string2 = eventExpressionWrapper.getAttributeName(comparison.attributeName);
            }
            if (string3 == null && string3.length() == 0) {
                string3 = comparison.value;
            }
            String[] stringArray = new String[]{string2, eventExpressionWrapper.getOperator(comparison.operator), string3};
            stringBuilder.append(NEW_LINE + Localization.getFormattedString(string, stringArray));
        }
        return stringBuilder.toString();
    }
}

