/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.MetricExpressionWrapper;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class MetricConditionBuilder {
    private static final String RES_PREFIX = "Alarm.Metadata.";
    private static final String TRIGGERS_METRIC = "triggers.metric";
    private static final String TRIGGERS_METRIC_NO_DURATION = "triggers.metric.no.duration";

    public List<TriggerConditionGroup> build(MetricAlarmExpression metricAlarmExpression, AlarmDefinitionInfo alarmDefinitionInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metricAlarmExpression, alarmDefinitionInfo});
        MetricExpressionWrapper metricExpressionWrapper = new MetricExpressionWrapper(metricAlarmExpression, alarmDefinitionInfo);
        ArrayList<TriggerConditionGroup> arrayList = new ArrayList<TriggerConditionGroup>();
        if (metricAlarmExpression.yellow != null) {
            arrayList.add(this.buildWarningConditionGroup(metricExpressionWrapper));
        }
        if (metricAlarmExpression.red != null) {
            arrayList.add(this.buildCriticalConditionGroup(metricExpressionWrapper));
        }
        return arrayList;
    }

    private TriggerConditionGroup buildCriticalConditionGroup(MetricExpressionWrapper metricExpressionWrapper) {
        String string;
        if (metricExpressionWrapper.getTrigger().supportDuration) {
            String[] stringArray = new String[]{metricExpressionWrapper.getName(), metricExpressionWrapper.getCondition(), metricExpressionWrapper.getCriticalValue(), metricExpressionWrapper.getValueUnit(), metricExpressionWrapper.getCriticalInterval(), metricExpressionWrapper.getCriticalIntervalUnit()};
            string = Localization.getFormattedString(TRIGGERS_METRIC, stringArray);
        } else {
            String[] stringArray = new String[]{metricExpressionWrapper.getName(), metricExpressionWrapper.getCondition(), metricExpressionWrapper.getCriticalValue(), metricExpressionWrapper.getValueUnit()};
            string = Localization.getFormattedString(TRIGGERS_METRIC_NO_DURATION, stringArray);
        }
        return new TriggerConditionGroup(string, ManagedEntity.Status.red);
    }

    private TriggerConditionGroup buildWarningConditionGroup(MetricExpressionWrapper metricExpressionWrapper) {
        String string;
        if (metricExpressionWrapper.getTrigger().supportDuration) {
            String[] stringArray = new String[]{metricExpressionWrapper.getName(), metricExpressionWrapper.getCondition(), metricExpressionWrapper.getWarningValue(), metricExpressionWrapper.getValueUnit(), metricExpressionWrapper.getWarningInterval(), metricExpressionWrapper.getWarningIntervalUnit()};
            string = Localization.getFormattedString(TRIGGERS_METRIC, stringArray);
        } else {
            String[] stringArray = new String[]{metricExpressionWrapper.getName(), metricExpressionWrapper.getCondition(), metricExpressionWrapper.getWarningValue(), metricExpressionWrapper.getValueUnit()};
            string = Localization.getFormattedString(TRIGGERS_METRIC_NO_DURATION, stringArray);
        }
        return new TriggerConditionGroup(string, ManagedEntity.Status.yellow);
    }
}

