/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.StateExpressionWrapper;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class StateConditionBuilder {
    public List<TriggerConditionGroup> build(StateAlarmExpression stateAlarmExpression, AlarmDefinitionInfo alarmDefinitionInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{stateAlarmExpression, alarmDefinitionInfo});
        StateExpressionWrapper stateExpressionWrapper = new StateExpressionWrapper(stateAlarmExpression, alarmDefinitionInfo);
        ArrayList<TriggerConditionGroup> arrayList = new ArrayList<TriggerConditionGroup>();
        if (stateAlarmExpression.yellow != null) {
            arrayList.add(this.buildWarningConditionGroup(stateExpressionWrapper));
        }
        if (stateAlarmExpression.red != null) {
            arrayList.add(this.buildCriticalConditionGroup(stateExpressionWrapper));
        }
        return arrayList;
    }

    private TriggerConditionGroup buildWarningConditionGroup(StateExpressionWrapper stateExpressionWrapper) {
        String string = stateExpressionWrapper.warningValue();
        return this.buildConditionGroup(stateExpressionWrapper, string, ManagedEntity.Status.yellow);
    }

    private TriggerConditionGroup buildCriticalConditionGroup(StateExpressionWrapper stateExpressionWrapper) {
        String string = stateExpressionWrapper.criticalValue();
        return this.buildConditionGroup(stateExpressionWrapper, string, ManagedEntity.Status.red);
    }

    private TriggerConditionGroup buildConditionGroup(StateExpressionWrapper stateExpressionWrapper, String string, ManagedEntity.Status status) {
        String string2 = Localization.getFormattedString("triggers.state", new String[]{stateExpressionWrapper.getName(), stateExpressionWrapper.getCondition(), string});
        return new TriggerConditionGroup(string2, status);
    }
}

