/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.definition.triggers;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.EventConditionBuilder;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.MetricConditionBuilder;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.StateConditionBuilder;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.expressions.AlarmExpressionWrapper;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.List;

public class TriggerConditionFactory {
    private final StateConditionBuilder _stateBuilder = new StateConditionBuilder();
    private final EventConditionBuilder _eventBuilder = new EventConditionBuilder();
    private final MetricConditionBuilder _metricBuilder = new MetricConditionBuilder();

    public List<TriggerConditionGroup> build(AlarmExpressionWrapper alarmExpressionWrapper, AlarmDefinitionInfo alarmDefinitionInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{alarmExpressionWrapper, alarmDefinitionInfo});
        ArrayList<TriggerConditionGroup> arrayList = new ArrayList<TriggerConditionGroup>();
        List<Object> list = new ArrayList();
        for (StateAlarmExpression stateAlarmExpression : alarmExpressionWrapper.getStateExpressions()) {
            list = this._stateBuilder.build(stateAlarmExpression, alarmDefinitionInfo);
            arrayList.addAll(list);
        }
        for (MetricAlarmExpression metricAlarmExpression : alarmExpressionWrapper.getMetricExpressions()) {
            list = this._metricBuilder.build(metricAlarmExpression, alarmDefinitionInfo);
            arrayList.addAll(list);
        }
        for (EventAlarmExpression eventAlarmExpression : alarmExpressionWrapper.getEventExpressions()) {
            arrayList.add(this._eventBuilder.build(eventAlarmExpression, alarmDefinitionInfo));
        }
        return arrayList;
    }
}

