/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.details;

import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.definition.actions.ActionGroup;
import com.vmware.opsmgmt.client.extension.alarms.definition.triggers.TriggerConditionGroup;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmRuleJoiner;
import com.vmware.opsmgmt.client.extension.alarms.details.AlarmRuleSummary;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vise.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class AlarmRulesSummaryBuilder {
    private static final String NEW_LINE = "<br>";
    private List<TriggerConditionGroup> triggerConditionGroups;
    private AlarmRuleJoiner joiner;
    private List<ActionGroup> actionGroups;
    private String repeatText;

    public AlarmRulesSummaryBuilder(List<TriggerConditionGroup> list, AlarmRuleJoiner alarmRuleJoiner, List<ActionGroup> list2, int n) {
        this.triggerConditionGroups = list;
        this.joiner = alarmRuleJoiner;
        this.actionGroups = list2;
        this.repeatText = Localization.getFormattedString("alarm.action.repeat.template", new String[]{Integer.toString(n)});
    }

    public List<AlarmRuleSummary> build() {
        ArrayList<AlarmRuleSummary> arrayList = new ArrayList<AlarmRuleSummary>();
        AlarmRulesSummaryBuilder.addToListIfNotNull(arrayList, this.buildSummaryForState(ManagedEntity.Status.red));
        AlarmRulesSummaryBuilder.addToListIfNotNull(arrayList, this.buildSummaryForState(ManagedEntity.Status.yellow));
        AlarmRulesSummaryBuilder.addToListIfNotNull(arrayList, this.buildSummaryForState(ManagedEntity.Status.gray));
        AlarmRulesSummaryBuilder.addToListIfNotNull(arrayList, this.buildSummaryForState(ManagedEntity.Status.green));
        return arrayList;
    }

    private static <T> void addToListIfNotNull(List<T> list, T t) {
        if (t != null) {
            list.add(t);
        }
    }

    private AlarmRuleSummary buildSummaryForState(ManagedEntity.Status status) {
        String string = this.createAlarmConditionsText(status);
        ManagedEntity.Status status2 = this.getPreviousState(status);
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        AlarmRuleSummary alarmRuleSummary = new AlarmRuleSummary();
        alarmRuleSummary.triggerSummary = string;
        if (status2 != null) {
            alarmRuleSummary.actions = this.getActionGroupsForStateTransition(status2, status);
        }
        return alarmRuleSummary;
    }

    private String createAlarmConditionsText(ManagedEntity.Status status) {
        if (this.triggerConditionGroups == null || this.triggerConditionGroups.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TriggerConditionGroup triggerConditionGroup : this.triggerConditionGroups) {
            if (triggerConditionGroup.getStatus() != status) continue;
            arrayList.add(triggerConditionGroup.getLabelText());
        }
        if (arrayList.isEmpty()) {
            return "";
        }
        String string = this.joinConditions(arrayList, this.joiner);
        if (!StringUtil.isNullOrEmpty((String)string)) {
            return Localization.getFormattedString("triggers.condition.IFTHENTemplate", new String[]{string, NEW_LINE, this.getStatusArgument(status)});
        }
        return "";
    }

    private String getJoinerLocStringId(AlarmRuleJoiner alarmRuleJoiner) {
        if (alarmRuleJoiner == AlarmRuleJoiner.AND) {
            return "triggers.condition.ANDJoinerTemplate";
        }
        return "triggers.condition.ORJoinerTemplate";
    }

    private String getStatusArgument(ManagedEntity.Status status) {
        return "{" + status + "}";
    }

    private List<ActionGroup> getActionGroupsForStateTransition(ManagedEntity.Status status, ManagedEntity.Status status2) {
        if (this.actionGroups == null) {
            return new ArrayList<ActionGroup>();
        }
        String string = this.getStateTransitionText(status, status2);
        ArrayList<ActionGroup> arrayList = new ArrayList<ActionGroup>();
        for (ActionGroup actionGroup : this.actionGroups) {
            if (!string.equals(actionGroup.getStateTransition())) continue;
            arrayList.add(actionGroup);
            if (!actionGroup.repeats()) continue;
            if (StringUtil.isNullOrEmpty((String)actionGroup.getBodyText())) {
                actionGroup.setBodyText(this.repeatText);
                continue;
            }
            actionGroup.setBodyText(actionGroup.getBodyText() + NEW_LINE + this.repeatText);
        }
        return arrayList;
    }

    private String getStateTransitionText(ManagedEntity.Status status, ManagedEntity.Status status2) {
        return status + "2" + status2;
    }

    private String joinConditions(List<String> list, AlarmRuleJoiner alarmRuleJoiner) {
        String string = this.getJoinerLocStringId(alarmRuleJoiner);
        return this.joinLabels(list, 0, list.size() - 1, string, NEW_LINE);
    }

    private String joinLabels(List<String> list, int n, int n2, String string, String string2) {
        if (list == null || n > n2 || n < 0 || n >= list.size() || n2 < 0 || n2 >= list.size()) {
            return "";
        }
        if (n == n2) {
            return list.get(n);
        }
        int n3 = (n + n2) / 2;
        String string3 = this.joinLabels(list, n, n3, string, string2);
        String string4 = this.joinLabels(list, n3 + 1, n2, string, string2);
        if (StringUtil.isNullOrEmpty((String)string2)) {
            return Localization.getFormattedString(string, new String[]{string3, string2, string4});
        }
        return Localization.getFormattedString(string, new String[]{string3, string2, string4});
    }

    private ManagedEntity.Status getPreviousState(ManagedEntity.Status status) {
        switch (status) {
            case red: {
                return ManagedEntity.Status.yellow;
            }
            case yellow: {
                return ManagedEntity.Status.green;
            }
        }
        return null;
    }
}

