/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.expressions;

import com.vmware.vim.binding.vim.alarm.AlarmExpression;
import com.vmware.vim.binding.vim.alarm.AndAlarmExpression;
import com.vmware.vim.binding.vim.alarm.EventAlarmExpression;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vim.binding.vim.alarm.OrAlarmExpression;
import com.vmware.vim.binding.vim.alarm.StateAlarmExpression;
import java.util.ArrayList;
import java.util.List;

public class AlarmExpressionWrapper {
    private List<EventAlarmExpression> _eventExpressions = new ArrayList<EventAlarmExpression>();
    private List<MetricAlarmExpression> _metricExpressions = new ArrayList<MetricAlarmExpression>();
    private List<StateAlarmExpression> _stateExpressions = new ArrayList<StateAlarmExpression>();
    private boolean _isEventBased;
    private boolean _isAndExpression;
    private boolean _isOrExpression;

    public AlarmExpressionWrapper(AlarmExpression alarmExpression) {
        this.processExpressions(alarmExpression);
    }

    private void processExpressions(AlarmExpression alarmExpression) {
        this.computeExpressionLists(alarmExpression);
        this._isEventBased = this.computeIsEventBased();
    }

    private boolean computeIsEventBased() {
        return !this._eventExpressions.isEmpty() && this._metricExpressions.isEmpty() && this._stateExpressions.isEmpty();
    }

    private void computeExpressionLists(AlarmExpression alarmExpression) {
        if (alarmExpression == null) {
            return;
        }
        if (alarmExpression instanceof AndAlarmExpression) {
            this._isAndExpression = true;
            AndAlarmExpression andAlarmExpression = (AndAlarmExpression)alarmExpression;
            for (AlarmExpression alarmExpression2 : andAlarmExpression.expression) {
                this.computeExpressionLists(alarmExpression2);
            }
        } else if (alarmExpression instanceof OrAlarmExpression) {
            this._isOrExpression = true;
            OrAlarmExpression orAlarmExpression = (OrAlarmExpression)alarmExpression;
            for (AlarmExpression alarmExpression3 : orAlarmExpression.expression) {
                this.computeExpressionLists(alarmExpression3);
            }
        } else if (alarmExpression instanceof StateAlarmExpression) {
            this._stateExpressions.add((StateAlarmExpression)alarmExpression);
        } else if (alarmExpression instanceof MetricAlarmExpression) {
            this._metricExpressions.add((MetricAlarmExpression)alarmExpression);
        } else if (alarmExpression instanceof EventAlarmExpression) {
            this._eventExpressions.add((EventAlarmExpression)alarmExpression);
        }
    }

    public List<EventAlarmExpression> getEventExpressions() {
        return this._eventExpressions;
    }

    public List<MetricAlarmExpression> getMetricExpressions() {
        return this._metricExpressions;
    }

    public List<StateAlarmExpression> getStateExpressions() {
        return this._stateExpressions;
    }

    public boolean getIsEventBased() {
        return this._isEventBased;
    }

    public boolean getIsAndExpression() {
        return this._isAndExpression;
    }

    public boolean getIsOrExpression() {
        return this._isOrExpression;
    }
}

