/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.expressions;

import com.vmware.opsmgmt.client.alarms.AlarmDefinitionInfo;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.configuration.MetricTrigger;
import com.vmware.opsmgmt.client.extension.alarms.expressions.ExpressionWrapper;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.alarm.MetricAlarmExpression;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;

public class MetricExpressionWrapper
extends ExpressionWrapper {
    private MetricTrigger _trigger;
    private final MetricAlarmExpression _expression;
    private final String _name;
    private final String _valueUnit;

    public MetricExpressionWrapper(MetricAlarmExpression metricAlarmExpression, AlarmDefinitionInfo alarmDefinitionInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metricAlarmExpression, alarmDefinitionInfo});
        this._expression = metricAlarmExpression;
        this._info = alarmDefinitionInfo;
        String string = this.getCounter(metricAlarmExpression, alarmDefinitionInfo);
        this._trigger = this.alarmConfig.getMetricTrigger(metricAlarmExpression, string);
        if (this._trigger == null) {
            this._trigger = new MetricTrigger();
            this._trigger.monitorObjectType = this._expression.type.getName();
            this._name = this.getNameFallback();
        } else {
            this._name = Localization.getTriggerName(this._trigger);
        }
        this._valueUnit = this.getUnit();
    }

    public String getName() {
        return this._name;
    }

    @Override
    public MetricTrigger getTrigger() {
        return this._trigger;
    }

    public String getCondition() {
        if (MetricAlarmExpression.MetricOperator.isAbove == this._expression.operator) {
            return Localization.getString("triggers.metric.above");
        }
        return Localization.getString("triggers.metric.below");
    }

    public String getWarningValue() {
        return this.getValue(this._expression.yellow);
    }

    public String getCriticalValue() {
        return this.getValue(this._expression.red);
    }

    public String getWarningInterval() {
        return this.getInterval(this._expression.yellowInterval);
    }

    public String getCriticalInterval() {
        return this.getInterval(this._expression.redInterval);
    }

    public String getWarningIntervalUnit() {
        return this.getIntervalUnit(this._expression.yellowInterval);
    }

    public String getCriticalIntervalUnit() {
        return this.getIntervalUnit(this._expression.redInterval);
    }

    public String getValueUnit() {
        return this._valueUnit;
    }

    private String getNameFallback() {
        return Localization.getFormattedString("triggers.metric.name", new String[]{Integer.toString(this._expression.metric.counterId)});
    }

    private String getCounter(MetricAlarmExpression metricAlarmExpression, AlarmDefinitionInfo alarmDefinitionInfo) {
        int n = metricAlarmExpression.metric.counterId;
        for (PerformanceManager.CounterInfo counterInfo : alarmDefinitionInfo.counters) {
            if (counterInfo.key != n) continue;
            return counterInfo.groupInfo.key + "." + counterInfo.nameInfo.key + "." + counterInfo.rollupType;
        }
        return null;
    }

    private String getValue(int n) {
        if (this._trigger.uiToApiValueFactor != 0) {
            n /= this._trigger.uiToApiValueFactor;
        }
        return Integer.toString(n);
    }

    private String getUnit() {
        String string = "";
        if (!StringUtil.isNullOrEmpty((String)this._trigger.unitResourceId)) {
            string = Localization.getVpxString("Alarm.Metadata." + this._trigger.unitResourceId);
        }
        return string;
    }

    private String getInterval(int n) {
        if (n >= 60) {
            n = Math.round(n / 60);
        }
        return Integer.toString(n);
    }

    private String getIntervalUnit(int n) {
        String string = n < 60 ? "triggers.seconds" : "triggers.minutes";
        return Localization.getString(string);
    }
}

