/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.monitortype;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.internal.provider.util.QueryQualifier;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.opsmgmt.client.extension.alarms.Localization;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.MonitorTypeInfoConfigUtil;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlarmMonitorTypeInfoCreator {
    private static final Log _logger = LogFactory.getLog(AlarmMonitorTypeInfoCreator.class);
    private final QueryService _queryService;

    public AlarmMonitorTypeInfoCreator(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    public final List<AlarmMonitorType> getMonitorTypes(ManagedObjectReference managedObjectReference) {
        String string;
        List<AlarmMonitorType> list = MonitorTypeInfoConfigUtil.getMonitorTypeInfoConfig(managedObjectReference);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AlarmMonitorType alarmMonitorType : list) {
            string = Localization.getVpxString(alarmMonitorType.getI18Key());
            alarmMonitorType.setLocalizedType(string);
            if (StringUtil.isNullOrEmpty((String)alarmMonitorType.getDataQueryProperty())) continue;
            if (alarmMonitorType.isRelatedProperty()) {
                arrayList.add(alarmMonitorType.getDataQueryProperty());
                continue;
            }
            arrayList.add(0, alarmMonitorType.getDataQueryProperty());
        }
        if (!arrayList.isEmpty()) {
            AlarmMonitorType alarmMonitorType;
            Collection collection = QueryQualifier.getFromClause(arrayList, null, null);
            alarmMonitorType = new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)managedObjectReference);
            string = this._queryService.select(arrayList).from(collection).where(new PropertyPredicate[]{alarmMonitorType}).build().fetch();
            List list2 = string.getItems();
            if (!CollectionUtil.isNullOrEmpty((Collection)list2)) {
                ResourceItem resourceItem = (ResourceItem)list2.get(0);
                for (AlarmMonitorType alarmMonitorType2 : list) {
                    String string2 = alarmMonitorType2.getDataQueryProperty();
                    if (StringUtil.isNullOrEmpty((String)string2)) continue;
                    Integer n = (Integer)resourceItem.get(string2);
                    alarmMonitorType2.setCount(n);
                }
            }
        }
        if (_logger.isTraceEnabled()) {
            _logger.trace((Object)StringUtil.appendStrings((Object[])new Object[]{"Finish execution of GET /monitorTypes for ", managedObjectReference.toString(), " count=", list.size()}));
        }
        return list;
    }
}

