/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.extension.alarms.monitortype;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.opsmgmt.client.extension.alarms.AlarmsUtil;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmMonitorType;
import com.vmware.opsmgmt.client.extension.alarms.monitortype.AlarmObjectMonitorTypesInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MonitorTypeInfoConfigUtil {
    private static final String CONFIG_FILE_PATH = "/MonitorTypeInfoConfig.json";

    public static List<AlarmMonitorType> getMonitorTypeInfoConfig(ManagedObjectReference managedObjectReference) {
        String string = AlarmsUtil.getNormalizeType(managedObjectReference);
        URL uRL = MonitorTypeInfoConfigUtil.class.getResource(CONFIG_FILE_PATH);
        if (uRL == null) {
            throw new IllegalStateException("Could not find alarm config: /MonitorTypeInfoConfig.json");
        }
        try {
            AlarmObjectMonitorTypesInfo[] alarmObjectMonitorTypesInfoArray;
            ObjectMapper objectMapper = new ObjectMapper();
            for (AlarmObjectMonitorTypesInfo alarmObjectMonitorTypesInfo : alarmObjectMonitorTypesInfoArray = (AlarmObjectMonitorTypesInfo[])objectMapper.readValue(uRL, AlarmObjectMonitorTypesInfo[].class)) {
                if (!string.equals(alarmObjectMonitorTypesInfo.objectType)) continue;
                return Arrays.asList(alarmObjectMonitorTypesInfo.monitorTypes);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return Collections.emptyList();
    }
}

